/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import de.greenrobot.dao.DaoLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DbUtils {
    public static void vacuum(SQLiteDatabase db) {
        db.execSQL("VACUUM");
    }

    public static int executeSqlScript(Context context, SQLiteDatabase db, String assetFilename) throws IOException {
        return DbUtils.executeSqlScript(context, db, assetFilename, true);
    }

    public static int executeSqlScript(Context context, SQLiteDatabase db, String assetFilename, boolean transactional) throws IOException {
        byte[] bytes = DbUtils.readAsset(context, assetFilename);
        String sql = new String(bytes, "UTF-8");
        String[] lines = sql.split(";(\\s)*[\n\r]");
        int count = transactional ? DbUtils.executeSqlStatementsInTx(db, lines) : DbUtils.executeSqlStatements(db, lines);
        DaoLog.i("Executed " + count + " statements from SQL script '" + assetFilename + "'");
        return count;
    }

    public static int executeSqlStatementsInTx(SQLiteDatabase db, String[] statements) {
        db.beginTransaction();
        try {
            int count = DbUtils.executeSqlStatements(db, statements);
            db.setTransactionSuccessful();
            int n = count;
            return n;
        }
        finally {
            db.endTransaction();
        }
    }

    public static int executeSqlStatements(SQLiteDatabase db, String[] statements) {
        int count = 0;
        String[] stringArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).length() > 0) {
                db.execSQL(line);
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static int copyAllBytes(InputStream in, OutputStream out) throws IOException {
        int read;
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            byteCount += read;
        }
        return byteCount;
    }

    public static byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DbUtils.copyAllBytes(in, out);
        return out.toByteArray();
    }

    public static byte[] readAsset(Context context, String filename) throws IOException {
        InputStream in = context.getResources().getAssets().open(filename);
        try {
            byte[] byArray = DbUtils.readAllBytes(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static void logTableDump(SQLiteDatabase db, String tablename) {
        Cursor cursor = db.query(tablename, null, null, null, null, null, null);
        try {
            String dump = DatabaseUtils.dumpCursorToString((Cursor)cursor);
            DaoLog.d(dump);
        }
        finally {
            cursor.close();
        }
    }
}

