/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.identityscope;

import de.greenrobot.dao.identityscope.IdentityScope;
import de.greenrobot.dao.internal.LongHashMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;

public class IdentityScopeLong<T>
implements IdentityScope<Long, T> {
    private final LongHashMap<Reference<T>> map = new LongHashMap();
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public T get(Long key) {
        return this.get2(key);
    }

    @Override
    public T getNoLock(Long key) {
        return this.get2NoLock(key);
    }

    public T get2(long key) {
        Reference<T> ref;
        this.lock.lock();
        try {
            ref = this.map.get(key);
        }
        finally {
            this.lock.unlock();
        }
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public T get2NoLock(long key) {
        Reference<T> ref = this.map.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    @Override
    public void put(Long key, T entity) {
        this.put2(key, entity);
    }

    @Override
    public void putNoLock(Long key, T entity) {
        this.put2NoLock(key, entity);
    }

    public void put2(long key, T entity) {
        this.lock.lock();
        try {
            this.map.put(key, new WeakReference<T>(entity));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void put2NoLock(long key, T entity) {
        this.map.put(key, new WeakReference<T>(entity));
    }

    @Override
    public boolean detach(Long key, T entity) {
        this.lock.lock();
        try {
            if (this.get(key) == entity && entity != null) {
                this.remove(key);
                return true;
            }
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove(Long key) {
        this.lock.lock();
        try {
            this.map.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove(Iterable<Long> keys) {
        this.lock.lock();
        try {
            for (Long key : keys) {
                this.map.remove(key);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void reserveRoom(int count) {
        this.map.reserveRoom(count);
    }
}

