/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.internal;

import android.database.sqlite.SQLiteDatabase;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.identityscope.IdentityScope;
import de.greenrobot.dao.identityscope.IdentityScopeLong;
import de.greenrobot.dao.identityscope.IdentityScopeObject;
import de.greenrobot.dao.identityscope.IdentityScopeType;
import de.greenrobot.dao.internal.TableStatements;
import java.lang.reflect.Field;
import java.util.ArrayList;

public final class DaoConfig
implements Cloneable {
    private static final boolean DEBUG = true;
    private static final String TAG = "DaoConfig";
    public final SQLiteDatabase db;
    public final String tablename;
    public final Property[] properties;
    public final String[] allColumns;
    public final String[] pkColumns;
    public final String[] nonPkColumns;
    public final Property pkProperty;
    public final boolean keyIsNumeric;
    public final TableStatements statements;
    private IdentityScope<?, ?> identityScope;

    public DaoConfig(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> daoClass) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        Class<?> type;
        this.db = db;
        this.tablename = (String)daoClass.getField("TABLENAME").get(null);
        Property[] properties = DaoConfig.reflectProperties(daoClass);
        this.properties = properties;
        this.allColumns = new String[properties.length];
        ArrayList<String> pkColumnList = new ArrayList<String>();
        ArrayList<String> nonPkColumnList = new ArrayList<String>();
        Property lastPkProperty = null;
        int i = 0;
        while (i < properties.length) {
            String name;
            Property property = properties[i];
            this.allColumns[i] = name = property.columnName;
            if (property.primaryKey) {
                pkColumnList.add(name);
                lastPkProperty = property;
            } else {
                nonPkColumnList.add(name);
            }
            ++i;
        }
        String[] nonPkColumnsArray = new String[nonPkColumnList.size()];
        this.nonPkColumns = nonPkColumnList.toArray(nonPkColumnsArray);
        String[] pkColumnsArray = new String[pkColumnList.size()];
        this.pkColumns = pkColumnList.toArray(pkColumnsArray);
        this.pkProperty = this.pkColumns.length == 1 ? lastPkProperty : null;
        this.statements = new TableStatements(db, this.tablename, this.allColumns, this.pkColumns);
        this.keyIsNumeric = this.pkProperty != null ? (type = this.pkProperty.type).equals(Long.TYPE) || type.equals(Long.class) || type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Byte.TYPE) || type.equals(Byte.class) : false;
    }

    private static Property[] reflectProperties(Class<? extends AbstractDao<?, ?>> daoClass) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Class<?> propertiesClass = Class.forName(String.valueOf(daoClass.getName()) + "$Properties");
        Field[] fields = propertiesClass.getDeclaredFields();
        ArrayList<Property> propertyList = new ArrayList<Property>();
        int modifierMask = 9;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Object fieldValue;
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 9) == 9 && (fieldValue = field.get(null)) instanceof Property) {
                propertyList.add((Property)fieldValue);
            }
            ++n2;
        }
        Property[] properties = new Property[propertyList.size()];
        for (Property property : propertyList) {
            if (properties[property.ordinal] != null) {
                throw new DaoException("Duplicate property ordinals");
            }
            properties[property.ordinal] = property;
        }
        return properties;
    }

    public DaoConfig(DaoConfig source) {
        this.db = source.db;
        this.tablename = source.tablename;
        this.properties = source.properties;
        this.allColumns = source.allColumns;
        this.pkColumns = source.pkColumns;
        this.nonPkColumns = source.nonPkColumns;
        this.pkProperty = source.pkProperty;
        this.statements = source.statements;
        this.keyIsNumeric = source.keyIsNumeric;
    }

    public DaoConfig clone() {
        return new DaoConfig(this);
    }

    public IdentityScope<?, ?> getIdentityScope() {
        return this.identityScope;
    }

    public void setIdentityScope(IdentityScope<?, ?> identityScope) {
        this.identityScope = identityScope;
    }

    public void initIdentityScope(IdentityScopeType type) {
        if (type == IdentityScopeType.None) {
            this.identityScope = null;
        } else if (type == IdentityScopeType.Session) {
            this.identityScope = this.keyIsNumeric ? new IdentityScopeLong() : new IdentityScopeObject();
        } else {
            throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
        }
    }
}

