/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.Cursor;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.query.AbstractQuery;
import de.greenrobot.dao.query.AbstractQueryData;

public class CountQuery<T>
extends AbstractQuery<T> {
    private final QueryData<T> queryData;

    static <T2> CountQuery<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        QueryData queryData = new QueryData(dao, sql, CountQuery.toStringArray(initialValues));
        return (CountQuery)queryData.forCurrentThread();
    }

    private CountQuery(QueryData<T> queryData, AbstractDao<T, ?> dao, String sql, String[] initialValues) {
        super(dao, sql, initialValues);
        this.queryData = queryData;
    }

    public CountQuery<T> forCurrentThread() {
        return this.queryData.forCurrentThread(this);
    }

    public long count() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        try {
            if (!cursor.moveToNext()) {
                throw new DaoException("No result for count");
            }
            if (!cursor.isLast()) {
                throw new DaoException("Unexpected row count: " + cursor.getCount());
            }
            if (cursor.getColumnCount() != 1) {
                throw new DaoException("Unexpected column count: " + cursor.getColumnCount());
            }
            long l = cursor.getLong(0);
            return l;
        }
        finally {
            cursor.close();
        }
    }

    /* synthetic */ CountQuery(QueryData queryData, AbstractDao abstractDao, String string, String[] stringArray, CountQuery countQuery) {
        this(queryData, abstractDao, string, stringArray);
    }

    private static final class QueryData<T2>
    extends AbstractQueryData<T2, CountQuery<T2>> {
        private QueryData(AbstractDao<T2, ?> dao, String sql, String[] initialValues) {
            super(dao, sql, initialValues);
        }

        @Override
        protected CountQuery<T2> createQuery() {
            return new CountQuery(this, this.dao, this.sql, (String[])this.initialValues.clone(), null);
        }
    }
}

