/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.DaoLog;
import de.greenrobot.dao.InternalQueryDaoAccess;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.query.CloseableListIterator;
import de.greenrobot.dao.query.CountQuery;
import de.greenrobot.dao.query.DeleteQuery;
import de.greenrobot.dao.query.LazyList;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.WhereCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class QueryBuilder<T> {
    public static boolean LOG_SQL;
    public static boolean LOG_VALUES;
    private StringBuilder orderBuilder;
    private StringBuilder joinBuilder;
    private final List<WhereCondition> whereConditions;
    private final List<Object> values;
    private final AbstractDao<T, ?> dao;
    private final String tablePrefix;
    private Integer limit;
    private Integer offset;

    public static <T2> QueryBuilder<T2> internalCreate(AbstractDao<T2, ?> dao) {
        return new QueryBuilder<T2>(dao);
    }

    protected QueryBuilder(AbstractDao<T, ?> dao) {
        this(dao, "T");
    }

    protected QueryBuilder(AbstractDao<T, ?> dao, String tablePrefix) {
        this.dao = dao;
        this.tablePrefix = tablePrefix;
        this.values = new ArrayList<Object>();
        this.whereConditions = new ArrayList<WhereCondition>();
    }

    private void checkOrderBuilder() {
        if (this.orderBuilder == null) {
            this.orderBuilder = new StringBuilder();
        } else if (this.orderBuilder.length() > 0) {
            this.orderBuilder.append(",");
        }
    }

    public QueryBuilder<T> where(WhereCondition cond, WhereCondition ... condMore) {
        this.whereConditions.add(cond);
        WhereCondition[] whereConditionArray = condMore;
        int n = condMore.length;
        int n2 = 0;
        while (n2 < n) {
            WhereCondition whereCondition = whereConditionArray[n2];
            this.checkCondition(whereCondition);
            this.whereConditions.add(whereCondition);
            ++n2;
        }
        return this;
    }

    public QueryBuilder<T> whereOr(WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        this.whereConditions.add(this.or(cond1, cond2, condMore));
        return this;
    }

    public WhereCondition or(WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        return this.combineWhereConditions(" OR ", cond1, cond2, condMore);
    }

    public WhereCondition and(WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        return this.combineWhereConditions(" AND ", cond1, cond2, condMore);
    }

    protected WhereCondition combineWhereConditions(String combineOp, WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        StringBuilder builder = new StringBuilder("(");
        ArrayList<Object> combinedValues = new ArrayList<Object>();
        this.addCondition(builder, combinedValues, cond1);
        builder.append(combineOp);
        this.addCondition(builder, combinedValues, cond2);
        WhereCondition[] whereConditionArray = condMore;
        int n = condMore.length;
        int n2 = 0;
        while (n2 < n) {
            WhereCondition cond = whereConditionArray[n2];
            builder.append(combineOp);
            this.addCondition(builder, combinedValues, cond);
            ++n2;
        }
        builder.append(')');
        return new WhereCondition.StringCondition(builder.toString(), combinedValues.toArray());
    }

    protected void addCondition(StringBuilder builder, List<Object> values, WhereCondition condition) {
        this.checkCondition(condition);
        condition.appendTo(builder, this.tablePrefix);
        condition.appendValuesTo(values);
    }

    protected void checkCondition(WhereCondition whereCondition) {
        if (whereCondition instanceof WhereCondition.PropertyCondition) {
            this.checkProperty(((WhereCondition.PropertyCondition)whereCondition).property);
        }
    }

    public <J> QueryBuilder<J> join(Class<J> entityClass, Property toOneProperty) {
        throw new UnsupportedOperationException();
    }

    public <J> QueryBuilder<J> joinToMany(Class<J> entityClass, Property toManyProperty) {
        throw new UnsupportedOperationException();
    }

    public QueryBuilder<T> orderAsc(Property ... properties) {
        this.orderAscOrDesc(" ASC", properties);
        return this;
    }

    public QueryBuilder<T> orderDesc(Property ... properties) {
        this.orderAscOrDesc(" DESC", properties);
        return this;
    }

    private void orderAscOrDesc(String ascOrDescWithLeadingSpace, Property ... properties) {
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            this.checkOrderBuilder();
            this.append(this.orderBuilder, property);
            if (String.class.equals(property.type)) {
                this.orderBuilder.append(" COLLATE LOCALIZED");
            }
            this.orderBuilder.append(ascOrDescWithLeadingSpace);
            ++n2;
        }
    }

    public QueryBuilder<T> orderCustom(Property property, String customOrderForProperty) {
        this.checkOrderBuilder();
        this.append(this.orderBuilder, property).append(' ');
        this.orderBuilder.append(customOrderForProperty);
        return this;
    }

    public QueryBuilder<T> orderRaw(String rawOrder) {
        this.checkOrderBuilder();
        this.orderBuilder.append(rawOrder);
        return this;
    }

    protected StringBuilder append(StringBuilder builder, Property property) {
        this.checkProperty(property);
        builder.append(this.tablePrefix).append('.').append('\'').append(property.columnName).append('\'');
        return builder;
    }

    protected void checkProperty(Property property) {
        if (this.dao != null) {
            Property[] properties = this.dao.getProperties();
            boolean found = false;
            Property[] propertyArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                Property property2 = propertyArray[n2];
                if (property == property2) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                throw new DaoException("Property '" + property.name + "' is not part of " + this.dao);
            }
        }
    }

    public QueryBuilder<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder<T> offset(int offset) {
        this.offset = offset;
        return this;
    }

    public Query<T> build() {
        String select = this.joinBuilder == null || this.joinBuilder.length() == 0 ? InternalQueryDaoAccess.getStatements(this.dao).getSelectAll() : SqlUtils.createSqlSelect(this.dao.getTablename(), this.tablePrefix, this.dao.getAllColumns());
        StringBuilder builder = new StringBuilder(select);
        this.appendWhereClause(builder, this.tablePrefix);
        if (this.orderBuilder != null && this.orderBuilder.length() > 0) {
            builder.append(" ORDER BY ").append((CharSequence)this.orderBuilder);
        }
        int limitPosition = -1;
        if (this.limit != null) {
            builder.append(" LIMIT ?");
            this.values.add(this.limit);
            limitPosition = this.values.size() - 1;
        }
        int offsetPosition = -1;
        if (this.offset != null) {
            if (this.limit == null) {
                throw new IllegalStateException("Offset cannot be set without limit");
            }
            builder.append(" OFFSET ?");
            this.values.add(this.offset);
            offsetPosition = this.values.size() - 1;
        }
        String sql = builder.toString();
        if (LOG_SQL) {
            DaoLog.d("Built SQL for query: " + sql);
        }
        if (LOG_VALUES) {
            DaoLog.d("Values for query: " + this.values);
        }
        return Query.create(this.dao, sql, this.values.toArray(), limitPosition, offsetPosition);
    }

    public DeleteQuery<T> buildDelete() {
        String tablename = this.dao.getTablename();
        String baseSql = SqlUtils.createSqlDelete(tablename, null);
        StringBuilder builder = new StringBuilder(baseSql);
        this.appendWhereClause(builder, this.tablePrefix);
        String sql = builder.toString();
        sql = sql.replace(String.valueOf(this.tablePrefix) + ".'", String.valueOf(tablename) + ".'");
        if (LOG_SQL) {
            DaoLog.d("Built SQL for delete query: " + sql);
        }
        if (LOG_VALUES) {
            DaoLog.d("Values for delete query: " + this.values);
        }
        return DeleteQuery.create(this.dao, sql, this.values.toArray());
    }

    public CountQuery<T> buildCount() {
        String tablename = this.dao.getTablename();
        String baseSql = SqlUtils.createSqlSelectCountStar(tablename, this.tablePrefix);
        StringBuilder builder = new StringBuilder(baseSql);
        this.appendWhereClause(builder, this.tablePrefix);
        String sql = builder.toString();
        if (LOG_SQL) {
            DaoLog.d("Built SQL for count query: " + sql);
        }
        if (LOG_VALUES) {
            DaoLog.d("Values for count query: " + this.values);
        }
        return CountQuery.create(this.dao, sql, this.values.toArray());
    }

    private void appendWhereClause(StringBuilder builder, String tablePrefixOrNull) {
        this.values.clear();
        if (!this.whereConditions.isEmpty()) {
            builder.append(" WHERE ");
            ListIterator<WhereCondition> iter = this.whereConditions.listIterator();
            while (iter.hasNext()) {
                if (iter.hasPrevious()) {
                    builder.append(" AND ");
                }
                WhereCondition condition = iter.next();
                condition.appendTo(builder, tablePrefixOrNull);
                condition.appendValuesTo(this.values);
            }
        }
    }

    public List<T> list() {
        return this.build().list();
    }

    public LazyList<T> listLazy() {
        return this.build().listLazy();
    }

    public LazyList<T> listLazyUncached() {
        return this.build().listLazyUncached();
    }

    public CloseableListIterator<T> listIterator() {
        return this.build().listIterator();
    }

    public T unique() {
        return this.build().unique();
    }

    public T uniqueOrThrow() {
        return this.build().uniqueOrThrow();
    }

    public long count() {
        return this.buildCount().count();
    }
}

