/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.test;

import android.app.Application;
import android.app.Instrumentation;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.test.AndroidTestCase;
import de.greenrobot.dao.DbUtils;
import java.util.Random;

public abstract class DbTest
extends AndroidTestCase {
    public static final String DB_NAME = "greendao-unittest-db.temp";
    protected final Random random;
    protected final boolean inMemory;
    protected SQLiteDatabase db;
    private Application application;

    public DbTest() {
        this(true);
    }

    public DbTest(boolean inMemory) {
        this.inMemory = inMemory;
        this.random = new Random();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.db = this.createDatabase();
    }

    public <T extends Application> T createApplication(Class<T> appClass) {
        Application app;
        DbTest.assertNull((String)"Application already created", (Object)this.application);
        try {
            app = Instrumentation.newApplication(appClass, (Context)this.getContext());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create application " + appClass, e);
        }
        app.onCreate();
        this.application = app;
        return (T)app;
    }

    public void terminateApplication() {
        DbTest.assertNotNull((String)"Application not yet created", (Object)this.application);
        this.application.onTerminate();
        this.application = null;
    }

    public <T extends Application> T getApplication() {
        DbTest.assertNotNull((String)"Application not yet created", (Object)this.application);
        return (T)this.application;
    }

    protected SQLiteDatabase createDatabase() {
        if (this.inMemory) {
            return SQLiteDatabase.create(null);
        }
        this.getContext().deleteDatabase(DB_NAME);
        return this.getContext().openOrCreateDatabase(DB_NAME, 0, null);
    }

    protected void tearDown() throws Exception {
        if (this.application != null) {
            this.terminateApplication();
        }
        this.db.close();
        if (!this.inMemory) {
            this.getContext().deleteDatabase(DB_NAME);
        }
        super.tearDown();
    }

    protected void logTableDump(String tablename) {
        DbUtils.logTableDump(this.db, tablename);
    }
}

