package com.sherchen.heartrate.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;

import com.sherchen.heartrate.greendao.HistoryEntity;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table HISTORY_ENTITY.
*/
public class HistoryEntityDao extends AbstractDao<HistoryEntity, Long> {

    public static final String TABLENAME = "HISTORY_ENTITY";

    /**
     * Properties of entity HistoryEntity.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property CalculateTime = new Property(1, Long.class, "calculateTime", false, "CALCULATE_TIME");
        public final static Property Rate = new Property(2, Integer.class, "rate", false, "RATE");
    };


    public HistoryEntityDao(DaoConfig config) {
        super(config);
    }
    
    public HistoryEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'HISTORY_ENTITY' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'CALCULATE_TIME' INTEGER," + // 1: calculateTime
                "'RATE' INTEGER);"); // 2: rate
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'HISTORY_ENTITY'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, HistoryEntity entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long calculateTime = entity.getCalculateTime();
        if (calculateTime != null) {
            stmt.bindLong(2, calculateTime);
        }
 
        Integer rate = entity.getRate();
        if (rate != null) {
            stmt.bindLong(3, rate);
        }
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public HistoryEntity readEntity(Cursor cursor, int offset) {
        HistoryEntity entity = new HistoryEntity( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // calculateTime
            cursor.isNull(offset + 2) ? null : cursor.getInt(offset + 2) // rate
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, HistoryEntity entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setCalculateTime(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setRate(cursor.isNull(offset + 2) ? null : cursor.getInt(offset + 2));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(HistoryEntity entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(HistoryEntity entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
}
