/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smack.util.DateFormatType;

public class StringUtils {
    public static final DateFormat XEP_0082_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateFormat dateFormatter = DateFormatType.XEP_0082_DATE_PROFILE.createFormatter();
    private static final Pattern datePattern = Pattern.compile("^\\d+-\\d+-\\d+$");
    private static final DateFormat timeFormatter = DateFormatType.XEP_0082_TIME_MILLIS_ZONE_PROFILE.createFormatter();
    private static final Pattern timePattern = Pattern.compile("^(\\d+:){2}\\d+.\\d+(Z|([+-](\\d+:\\d+)))$");
    private static final DateFormat timeNoZoneFormatter = DateFormatType.XEP_0082_TIME_MILLIS_PROFILE.createFormatter();
    private static final Pattern timeNoZonePattern = Pattern.compile("^(\\d+:){2}\\d+.\\d+$");
    private static final DateFormat timeNoMillisFormatter = DateFormatType.XEP_0082_TIME_ZONE_PROFILE.createFormatter();
    private static final Pattern timeNoMillisPattern = Pattern.compile("^(\\d+:){2}\\d+(Z|([+-](\\d+:\\d+)))$");
    private static final DateFormat timeNoMillisNoZoneFormatter = DateFormatType.XEP_0082_TIME_PROFILE.createFormatter();
    private static final Pattern timeNoMillisNoZonePattern = Pattern.compile("^(\\d+:){2}\\d+$");
    private static final DateFormat dateTimeFormatter = DateFormatType.XEP_0082_DATETIME_MILLIS_PROFILE.createFormatter();
    private static final Pattern dateTimePattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+.\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final DateFormat dateTimeNoMillisFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final Pattern dateTimeNoMillisPattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final DateFormat xep0091Formatter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private static final DateFormat xep0091Date6DigitFormatter = new SimpleDateFormat("yyyyMd'T'HH:mm:ss");
    private static final DateFormat xep0091Date7Digit1MonthFormatter = new SimpleDateFormat("yyyyMdd'T'HH:mm:ss");
    private static final DateFormat xep0091Date7Digit2MonthFormatter = new SimpleDateFormat("yyyyMMd'T'HH:mm:ss");
    private static final Pattern xep0091Pattern = Pattern.compile("^\\d+T\\d+:\\d+:\\d+$");
    private static final List<PatternCouplings> couplings = new ArrayList<PatternCouplings>();
    private static final char[] QUOTE_ENCODE;
    private static final char[] APOS_ENCODE;
    private static final char[] AMP_ENCODE;
    private static final char[] LT_ENCODE;
    private static final char[] GT_ENCODE;
    private static MessageDigest digest;
    private static Random randGen;
    private static char[] numbersAndLetters;

    public static Date parseXEP0082Date(String string) throws ParseException {
        return StringUtils.parseDate(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Date parseDate(String string) throws ParseException {
        Matcher matcher = xep0091Pattern.matcher(string);
        if (matcher.matches()) {
            int n = string.split("T")[0].length();
            if (n >= 8) {
                DateFormat dateFormat = xep0091Formatter;
                // MONITORENTER : dateFormat
                // MONITOREXIT : dateFormat
                return xep0091Formatter.parse(string);
            }
            Date date = StringUtils.handleDateWithMissingLeadingZeros(string, n);
            if (date != null) {
                return date;
            }
        } else {
            for (PatternCouplings patternCouplings : couplings) {
                matcher = patternCouplings.pattern.matcher(string);
                if (!matcher.matches()) continue;
                DateFormat dateFormat = patternCouplings.formatter;
                // MONITORENTER : dateFormat
                // MONITOREXIT : dateFormat
                return patternCouplings.formatter.parse(string);
            }
        }
        DateFormat dateFormat = dateTimeNoMillisFormatter;
        // MONITORENTER : dateFormat
        // MONITOREXIT : dateFormat
        return dateTimeNoMillisFormatter.parse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date handleDateWithMissingLeadingZeros(String string, int n) throws ParseException {
        if (n == 6) {
            DateFormat dateFormat = xep0091Date6DigitFormatter;
            synchronized (dateFormat) {
                return xep0091Date6DigitFormatter.parse(string);
            }
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = StringUtils.parseXEP91Date(string, xep0091Date7Digit1MonthFormatter);
        Calendar calendar3 = StringUtils.parseXEP91Date(string, xep0091Date7Digit2MonthFormatter);
        List<Calendar> list = StringUtils.filterDatesBefore(calendar, calendar2, calendar3);
        if (!list.isEmpty()) {
            return StringUtils.determineNearestDate(calendar, list).getTime();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Calendar parseXEP91Date(String string, DateFormat dateFormat) {
        try {
            DateFormat dateFormat2 = dateFormat;
            synchronized (dateFormat2) {
                dateFormat.parse(string);
                return dateFormat.getCalendar();
            }
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static List<Calendar> filterDatesBefore(Calendar calendar, Calendar ... calendarArray) {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        for (Calendar calendar2 : calendarArray) {
            if (calendar2 == null || !calendar2.before(calendar)) continue;
            arrayList.add(calendar2);
        }
        return arrayList;
    }

    private static Calendar determineNearestDate(final Calendar calendar, List<Calendar> list) {
        Collections.sort(list, new Comparator<Calendar>(){

            @Override
            public int compare(Calendar calendar3, Calendar calendar2) {
                Long l = new Long(calendar.getTimeInMillis() - calendar3.getTimeInMillis());
                Long l2 = new Long(calendar.getTimeInMillis() - calendar2.getTimeInMillis());
                return l.compareTo(l2);
            }
        });
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXEP0082Date(Date date) {
        DateFormat dateFormat = dateTimeFormatter;
        synchronized (dateFormat) {
            return dateTimeFormatter.format(date);
        }
    }

    public static String formatDate(Date date, DateFormatType dateFormatType) {
        return null;
    }

    public static String parseName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("@");
        if (n <= 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String parseServer(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("@");
        if (n + 1 > string.length()) {
            return "";
        }
        int n2 = string.indexOf("/");
        if (n2 > 0 && n2 > n) {
            return string.substring(n + 1, n2);
        }
        return string.substring(n + 1);
    }

    public static String parseResource(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("/");
        if (n + 1 > string.length() || n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String parseBareAddress(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("/");
        if (n < 0) {
            return string;
        }
        if (n == 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String escapeNode(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 8);
        int n = string.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\22");
                    continue block11;
                }
                case '&': {
                    stringBuilder.append("\\26");
                    continue block11;
                }
                case '\'': {
                    stringBuilder.append("\\27");
                    continue block11;
                }
                case '/': {
                    stringBuilder.append("\\2f");
                    continue block11;
                }
                case ':': {
                    stringBuilder.append("\\3a");
                    continue block11;
                }
                case '<': {
                    stringBuilder.append("\\3c");
                    continue block11;
                }
                case '>': {
                    stringBuilder.append("\\3e");
                    continue block11;
                }
                case '@': {
                    stringBuilder.append("\\40");
                    continue block11;
                }
                case '\\': {
                    stringBuilder.append("\\5c");
                    continue block11;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        stringBuilder.append("\\20");
                        continue block11;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String unescapeNode(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        int n = cArray.length;
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i + 2 < n) {
                char c2 = cArray[i + 1];
                char c3 = cArray[i + 2];
                if (c2 == '2') {
                    switch (c3) {
                        case '0': {
                            stringBuilder.append(' ');
                            i += 2;
                            continue block12;
                        }
                        case '2': {
                            stringBuilder.append('\"');
                            i += 2;
                            continue block12;
                        }
                        case '6': {
                            stringBuilder.append('&');
                            i += 2;
                            continue block12;
                        }
                        case '7': {
                            stringBuilder.append('\'');
                            i += 2;
                            continue block12;
                        }
                        case 'f': {
                            stringBuilder.append('/');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '3') {
                    switch (c3) {
                        case 'a': {
                            stringBuilder.append(':');
                            i += 2;
                            continue block12;
                        }
                        case 'c': {
                            stringBuilder.append('<');
                            i += 2;
                            continue block12;
                        }
                        case 'e': {
                            stringBuilder.append('>');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '4') {
                    if (c3 == '0') {
                        stringBuilder.append("@");
                        i += 2;
                        continue;
                    }
                } else if (c2 == '5' && c3 == 'c') {
                    stringBuilder.append("\\");
                    i += 2;
                    continue;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String escapeForXML(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        StringBuilder stringBuilder = new StringBuilder((int)((double)n3 * 1.3));
        for (n = 0; n < n3; ++n) {
            char c = cArray[n];
            if (c > '>') continue;
            if (c == '<') {
                if (n > n2) {
                    stringBuilder.append(cArray, n2, n - n2);
                }
                n2 = n + 1;
                stringBuilder.append(LT_ENCODE);
                continue;
            }
            if (c == '>') {
                if (n > n2) {
                    stringBuilder.append(cArray, n2, n - n2);
                }
                n2 = n + 1;
                stringBuilder.append(GT_ENCODE);
                continue;
            }
            if (c == '&') {
                if (n > n2) {
                    stringBuilder.append(cArray, n2, n - n2);
                }
                if (n3 > n + 5 && cArray[n + 1] == '#' && Character.isDigit(cArray[n + 2]) && Character.isDigit(cArray[n + 3]) && Character.isDigit(cArray[n + 4]) && cArray[n + 5] == ';') continue;
                n2 = n + 1;
                stringBuilder.append(AMP_ENCODE);
                continue;
            }
            if (c == '\"') {
                if (n > n2) {
                    stringBuilder.append(cArray, n2, n - n2);
                }
                n2 = n + 1;
                stringBuilder.append(QUOTE_ENCODE);
                continue;
            }
            if (c != '\'') continue;
            if (n > n2) {
                stringBuilder.append(cArray, n2, n - n2);
            }
            n2 = n + 1;
            stringBuilder.append(APOS_ENCODE);
        }
        if (n2 == 0) {
            return string;
        }
        if (n > n2) {
            stringBuilder.append(cArray, n2, n - n2);
        }
        return stringBuilder.toString();
    }

    public static synchronized String hash(String string) {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.err.println("Failed to load the SHA-1 MessageDigest. Jive will be unable to function normally.");
            }
        }
        try {
            digest.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException);
        }
        return StringUtils.encodeHex(digest.digest());
    }

    public static String encodeHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            if ((by & 0xFF) < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toString(by & 0xFF, 16));
        }
        return stringBuilder.toString();
    }

    public static String encodeBase64(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return StringUtils.encodeBase64(byArray);
    }

    public static String encodeBase64(byte[] byArray) {
        return StringUtils.encodeBase64(byArray, false);
    }

    public static String encodeBase64(byte[] byArray, boolean bl) {
        return StringUtils.encodeBase64(byArray, 0, byArray.length, bl);
    }

    public static String encodeBase64(byte[] byArray, int n, int n2, boolean bl) {
        return Base64.encodeBytes(byArray, n, n2, bl ? 0 : 8);
    }

    public static byte[] decodeBase64(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        byArray = Base64.decode(byArray, 0, byArray.length, 0);
        return byArray;
    }

    public static String randomString(int n) {
        if (n < 1) {
            return null;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(cArray);
    }

    private StringUtils() {
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        XEP_0082_UTC_FORMAT.setTimeZone(timeZone);
        dateFormatter.setTimeZone(timeZone);
        timeFormatter.setTimeZone(timeZone);
        timeNoZoneFormatter.setTimeZone(timeZone);
        timeNoMillisFormatter.setTimeZone(timeZone);
        timeNoMillisNoZoneFormatter.setTimeZone(timeZone);
        dateTimeFormatter.setTimeZone(timeZone);
        dateTimeNoMillisFormatter.setTimeZone(timeZone);
        xep0091Formatter.setTimeZone(timeZone);
        xep0091Date6DigitFormatter.setTimeZone(timeZone);
        xep0091Date7Digit1MonthFormatter.setTimeZone(timeZone);
        xep0091Date7Digit1MonthFormatter.setLenient(false);
        xep0091Date7Digit2MonthFormatter.setTimeZone(timeZone);
        xep0091Date7Digit2MonthFormatter.setLenient(false);
        couplings.add(new PatternCouplings(datePattern, dateFormatter));
        couplings.add(new PatternCouplings(dateTimePattern, dateTimeFormatter));
        couplings.add(new PatternCouplings(dateTimeNoMillisPattern, dateTimeNoMillisFormatter));
        couplings.add(new PatternCouplings(timePattern, timeFormatter));
        couplings.add(new PatternCouplings(timeNoZonePattern, timeNoZoneFormatter));
        couplings.add(new PatternCouplings(timeNoMillisPattern, timeNoMillisFormatter));
        couplings.add(new PatternCouplings(timeNoMillisNoZonePattern, timeNoMillisNoZoneFormatter));
        QUOTE_ENCODE = "&quot;".toCharArray();
        APOS_ENCODE = "&apos;".toCharArray();
        AMP_ENCODE = "&amp;".toCharArray();
        LT_ENCODE = "&lt;".toCharArray();
        GT_ENCODE = "&gt;".toCharArray();
        digest = null;
        randGen = new Random();
        numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }

    private static class PatternCouplings {
        Pattern pattern;
        DateFormat formatter;

        public PatternCouplings(Pattern pattern, DateFormat dateFormat) {
            this.pattern = pattern;
            this.formatter = dateFormat;
        }
    }
}

