/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.MessageEventNotificationListener;
import org.jivesoftware.smackx.MessageEventRequestListener;
import org.jivesoftware.smackx.packet.MessageEvent;

public class MessageEventManager {
    private List<MessageEventNotificationListener> messageEventNotificationListeners = new ArrayList<MessageEventNotificationListener>();
    private List<MessageEventRequestListener> messageEventRequestListeners = new ArrayList<MessageEventRequestListener>();
    private Connection con;
    private PacketFilter packetFilter = new PacketExtensionFilter("x", "jabber:x:event");
    private PacketListener packetListener;

    public MessageEventManager(Connection connection) {
        this.con = connection;
        this.init();
    }

    public static void addNotificationsRequests(Message message, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setOffline(bl);
        messageEvent.setDelivered(bl2);
        messageEvent.setDisplayed(bl3);
        messageEvent.setComposing(bl4);
        message.addExtension(messageEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        List<MessageEventRequestListener> list = this.messageEventRequestListeners;
        synchronized (list) {
            if (!this.messageEventRequestListeners.contains(messageEventRequestListener)) {
                this.messageEventRequestListeners.add(messageEventRequestListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        List<MessageEventRequestListener> list = this.messageEventRequestListeners;
        synchronized (list) {
            this.messageEventRequestListeners.remove(messageEventRequestListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        List<MessageEventNotificationListener> list = this.messageEventNotificationListeners;
        synchronized (list) {
            if (!this.messageEventNotificationListeners.contains(messageEventNotificationListener)) {
                this.messageEventNotificationListeners.add(messageEventNotificationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        List<MessageEventNotificationListener> list = this.messageEventNotificationListeners;
        synchronized (list) {
            this.messageEventNotificationListeners.remove(messageEventNotificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEventRequestListeners(String string, String string2, String string3) {
        MessageEventRequestListener[] messageEventRequestListenerArray = null;
        List<MessageEventRequestListener> list = this.messageEventRequestListeners;
        synchronized (list) {
            messageEventRequestListenerArray = new MessageEventRequestListener[this.messageEventRequestListeners.size()];
            this.messageEventRequestListeners.toArray(messageEventRequestListenerArray);
        }
        try {
            Method method = MessageEventRequestListener.class.getDeclaredMethod(string3, String.class, String.class, MessageEventManager.class);
            for (int i = 0; i < messageEventRequestListenerArray.length; ++i) {
                method.invoke((Object)messageEventRequestListenerArray[i], string, string2, this);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEventNotificationListeners(String string, String string2, String string3) {
        MessageEventNotificationListener[] messageEventNotificationListenerArray = null;
        List<MessageEventNotificationListener> list = this.messageEventNotificationListeners;
        synchronized (list) {
            messageEventNotificationListenerArray = new MessageEventNotificationListener[this.messageEventNotificationListeners.size()];
            this.messageEventNotificationListeners.toArray(messageEventNotificationListenerArray);
        }
        try {
            Method method = MessageEventNotificationListener.class.getDeclaredMethod(string3, String.class, String.class);
            for (int i = 0; i < messageEventNotificationListenerArray.length; ++i) {
                method.invoke((Object)messageEventNotificationListenerArray[i], string, string2);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private void init() {
        this.packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                MessageEvent messageEvent = (MessageEvent)message.getExtension("x", "jabber:x:event");
                if (messageEvent.isMessageEventRequest()) {
                    Iterator<String> iterator = messageEvent.getEventTypes();
                    while (iterator.hasNext()) {
                        MessageEventManager.this.fireMessageEventRequestListeners(message.getFrom(), message.getPacketID(), iterator.next().concat("NotificationRequested"));
                    }
                } else {
                    Iterator<String> iterator = messageEvent.getEventTypes();
                    while (iterator.hasNext()) {
                        MessageEventManager.this.fireMessageEventNotificationListeners(message.getFrom(), messageEvent.getPacketID(), iterator.next().concat("Notification"));
                    }
                }
            }
        };
        this.con.addPacketListener(this.packetListener, this.packetFilter);
    }

    public void sendDeliveredNotification(String string, String string2) {
        Message message = new Message(string);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDelivered(true);
        messageEvent.setPacketID(string2);
        message.addExtension(messageEvent);
        this.con.sendPacket(message);
    }

    public void sendDisplayedNotification(String string, String string2) {
        Message message = new Message(string);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDisplayed(true);
        messageEvent.setPacketID(string2);
        message.addExtension(messageEvent);
        this.con.sendPacket(message);
    }

    public void sendComposingNotification(String string, String string2) {
        Message message = new Message(string);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setComposing(true);
        messageEvent.setPacketID(string2);
        message.addExtension(messageEvent);
        this.con.sendPacket(message);
    }

    public void sendCancelledNotification(String string, String string2) {
        Message message = new Message(string);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setCancelled(true);
        messageEvent.setPacketID(string2);
        message.addExtension(messageEvent);
        this.con.sendPacket(message);
    }

    public void destroy() {
        if (this.con != null) {
            this.con.removePacketListener(this.packetListener);
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }
}

