/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.carbons;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.forward.Forwarded;
import org.xmlpull.v1.XmlPullParser;

public class Carbon
implements PacketExtension {
    public static final String NAMESPACE = "urn:xmpp:carbons:2";
    private Direction dir;
    private Forwarded fwd;

    public Carbon(Direction direction, Forwarded forwarded) {
        this.dir = direction;
        this.fwd = forwarded;
    }

    public Direction getDirection() {
        return this.dir;
    }

    public Forwarded getForwarded() {
        return this.fwd;
    }

    @Override
    public String getElementName() {
        return this.dir.toString();
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        stringBuilder.append(this.fwd.toXML());
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }

    public static class Private
    implements PacketExtension {
        public static final String ELEMENT = "private";

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return Carbon.NAMESPACE;
        }

        @Override
        public String toXML() {
            return "<private xmlns=\"urn:xmpp:carbons:2\"/>";
        }
    }

    public static class Provider
    implements PacketExtensionProvider {
        @Override
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            Direction direction = Direction.valueOf(xmlPullParser.getName());
            Forwarded forwarded = null;
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && xmlPullParser.getName().equals("forwarded")) {
                    forwarded = (Forwarded)new Forwarded.Provider().parseExtension(xmlPullParser);
                    continue;
                }
                if (n != 3 || direction != Direction.valueOf(xmlPullParser.getName())) continue;
                bl = true;
            }
            if (forwarded == null) {
                throw new Exception("sent/received must contain exactly one <forwarded> tag");
            }
            return new Carbon(direction, forwarded);
        }
    }

    public static enum Direction {
        received,
        sent;

    }
}

