/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.carbons;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.carbons.Carbon;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class CarbonManager {
    private static Map<Connection, CarbonManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private Connection connection;
    private volatile boolean enabled_state = false;

    private CarbonManager(Connection connection) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        serviceDiscoveryManager.addFeature("urn:xmpp:carbons:2");
        this.connection = connection;
        instances.put(connection, this);
    }

    public static CarbonManager getInstanceFor(Connection connection) {
        CarbonManager carbonManager = instances.get(connection);
        if (carbonManager == null) {
            carbonManager = new CarbonManager(connection);
        }
        return carbonManager;
    }

    private IQ carbonsEnabledIQ(final boolean bl) {
        IQ iQ = new IQ(){

            @Override
            public String getChildElementXML() {
                return "<" + (bl ? "enable" : "disable") + " xmlns='" + "urn:xmpp:carbons:2" + "'/>";
            }
        };
        iQ.setType(IQ.Type.SET);
        return iQ;
    }

    public boolean isSupportedByServer() {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(this.connection.getServiceName());
            return discoverInfo.containsFeature("urn:xmpp:carbons:2");
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }

    public void sendCarbonsEnabled(final boolean bl) {
        IQ iQ = this.carbonsEnabledIQ(bl);
        this.connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                IQ iQ = (IQ)packet;
                if (iQ.getType() == IQ.Type.RESULT) {
                    CarbonManager.this.enabled_state = bl;
                }
                CarbonManager.this.connection.removePacketListener(this);
            }
        }, new PacketIDFilter(iQ.getPacketID()));
        this.connection.sendPacket(iQ);
    }

    public boolean setCarbonsEnabled(boolean bl) {
        if (this.enabled_state == bl) {
            return true;
        }
        IQ iQ = this.carbonsEnabledIQ(bl);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(iQ.getPacketID()));
        this.connection.sendPacket(iQ);
        IQ iQ2 = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ2 != null && iQ2.getType() == IQ.Type.RESULT) {
            this.enabled_state = bl;
            return true;
        }
        return false;
    }

    public boolean enableCarbons() {
        return this.setCarbonsEnabled(true);
    }

    public boolean disableCarbons() {
        return this.setCarbonsEnabled(false);
    }

    public boolean getCarbonsEnabled() {
        return this.enabled_state;
    }

    public static Carbon getCarbon(Message message) {
        Carbon carbon = (Carbon)message.getExtension("received", "urn:xmpp:carbons:2");
        if (carbon == null) {
            carbon = (Carbon)message.getExtension("sent", "urn:xmpp:carbons:2");
        }
        return carbon;
    }

    public static void disableCarbons(Message message) {
        message.addExtension(new Carbon.Private());
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new CarbonManager(connection);
            }
        });
    }
}

