/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.ServerPingTask;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.jivesoftware.smackx.ping.packet.Pong;

public class PingManager {
    public static final String NAMESPACE = "urn:xmpp:ping";
    public static final String ELEMENT = "ping";
    private static Map<Connection, PingManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private Connection connection;
    private Thread serverPingThread;
    private ServerPingTask serverPingTask;
    private int pingInterval = SmackConfiguration.getDefaultPingInterval();
    private Set<PingFailedListener> pingFailedListeners = Collections.synchronizedSet(new HashSet());
    private long pingMinDelta = 100L;
    private long lastPingStamp = 0L;
    private long lastServerPingStamp = -1L;

    private PingManager(Connection connection) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        serviceDiscoveryManager.addFeature(NAMESPACE);
        this.connection = connection;
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(Ping.class);
        connection.addPacketListener(new PingPacketListener(), packetTypeFilter);
        connection.addConnectionListener(new PingConnectionListener());
        instances.put(connection, this);
        this.maybeStartPingServerTask();
    }

    public static PingManager getInstanceFor(Connection connection) {
        PingManager pingManager = instances.get(connection);
        if (pingManager == null) {
            pingManager = new PingManager(connection);
        }
        return pingManager;
    }

    public void setPingIntervall(int n) {
        this.pingInterval = n;
        if (this.serverPingTask != null) {
            this.serverPingTask.setPingInterval(n);
        }
    }

    public int getPingIntervall() {
        return this.pingInterval;
    }

    public void registerPingFailedListener(PingFailedListener pingFailedListener) {
        this.pingFailedListeners.add(pingFailedListener);
    }

    public void unregisterPingFailedListener(PingFailedListener pingFailedListener) {
        this.pingFailedListeners.remove(pingFailedListener);
    }

    public void disablePingFloodProtection() {
        this.setPingMinimumInterval(-1L);
    }

    public void setPingMinimumInterval(long l) {
        this.pingMinDelta = l;
    }

    public long getPingMinimumInterval() {
        return this.pingMinDelta;
    }

    public IQ ping(String string, long l) {
        if (!this.connection.isAuthenticated()) {
            return null;
        }
        Ping ping = new Ping(this.connection.getUser(), string);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(ping.getPacketID()));
        this.connection.sendPacket(ping);
        IQ iQ = (IQ)packetCollector.nextResult(l);
        packetCollector.cancel();
        return iQ;
    }

    public IQ ping(String string) {
        return this.ping(string, SmackConfiguration.getPacketReplyTimeout());
    }

    public boolean pingEntity(String string, long l) {
        IQ iQ = this.ping(string, l);
        return iQ != null && iQ.getType() != IQ.Type.ERROR;
    }

    public boolean pingEntity(String string) {
        return this.pingEntity(string, SmackConfiguration.getPacketReplyTimeout());
    }

    public boolean pingMyServer(long l) {
        IQ iQ = this.ping(this.connection.getServiceName(), l);
        if (iQ == null) {
            for (PingFailedListener pingFailedListener : this.pingFailedListeners) {
                pingFailedListener.pingFailed();
            }
            return false;
        }
        this.lastServerPingStamp = System.currentTimeMillis();
        return true;
    }

    public boolean pingMyServer() {
        return this.pingMyServer(SmackConfiguration.getPacketReplyTimeout());
    }

    public boolean isPingSupported(String string) {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(string);
            return discoverInfo.containsFeature(NAMESPACE);
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }

    public long getLastSuccessfulPing() {
        long l = -1L;
        if (this.serverPingTask != null) {
            l = this.serverPingTask.getLastSucessfulPing();
        }
        return Math.max(l, this.lastServerPingStamp);
    }

    protected Set<PingFailedListener> getPingFailedListeners() {
        return this.pingFailedListeners;
    }

    private void maybeStartPingServerTask() {
        if (this.serverPingTask != null) {
            this.serverPingTask.setDone();
            this.serverPingThread.interrupt();
            this.serverPingTask = null;
            this.serverPingThread = null;
        }
        if (this.pingInterval > 0) {
            this.serverPingTask = new ServerPingTask(this.connection, this.pingInterval);
            this.serverPingThread = new Thread(this.serverPingTask);
            this.serverPingThread.setDaemon(true);
            this.serverPingThread.setName("Smack Ping Server Task (" + this.connection.getServiceName() + ")");
            this.serverPingThread.start();
        }
    }

    private void maybeStopPingServerTask() {
        if (this.serverPingThread != null) {
            this.serverPingTask.setDone();
            this.serverPingThread.interrupt();
        }
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new PingManager(connection);
            }
        });
    }

    private class PingPacketListener
    implements PacketListener {
        @Override
        public void processPacket(Packet packet) {
            if (PingManager.this.pingMinDelta > 0L) {
                long l = System.currentTimeMillis();
                long l2 = l - PingManager.this.lastPingStamp;
                PingManager.this.lastPingStamp = l;
                if (l2 < PingManager.this.pingMinDelta) {
                    return;
                }
            }
            Pong pong = new Pong((Ping)packet);
            PingManager.this.connection.sendPacket(pong);
        }
    }

    private class PingConnectionListener
    extends AbstractConnectionListener {
        private PingConnectionListener() {
        }

        @Override
        public void connectionClosed() {
            PingManager.this.maybeStopPingServerTask();
        }

        @Override
        public void connectionClosedOnError(Exception exception) {
            PingManager.this.maybeStopPingServerTask();
        }

        @Override
        public void reconnectionSuccessful() {
            PingManager.this.maybeStartPingServerTask();
        }
    }
}

