/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.lang.ref.WeakReference;
import java.util.Set;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.PingManager;

class ServerPingTask
implements Runnable {
    private WeakReference<Connection> weakConnection;
    private int pingInterval;
    private volatile long lastSuccessfulPing = -1L;
    private int delta = 1000;
    private int tries = 3;

    protected ServerPingTask(Connection connection, int n) {
        this.weakConnection = new WeakReference<Connection>(connection);
        this.pingInterval = n;
    }

    protected void setDone() {
        this.pingInterval = -1;
    }

    protected void setPingInterval(int n) {
        this.pingInterval = n;
    }

    protected int getIntInterval() {
        return this.pingInterval;
    }

    protected long getLastSucessfulPing() {
        return this.lastSuccessfulPing;
    }

    @Override
    public void run() {
        Connection connection;
        this.sleep(60000);
        block2: while (this.pingInterval > 0 && (connection = (Connection)this.weakConnection.get()) != null) {
            if (connection.isAuthenticated()) {
                PingManager pingManager = PingManager.getInstanceFor(connection);
                boolean bl = false;
                for (int i = 0; i < this.tries; ++i) {
                    if (i != 0) {
                        try {
                            Thread.sleep(this.delta);
                        }
                        catch (InterruptedException interruptedException) {
                            break block2;
                        }
                    }
                    if (!(bl = pingManager.pingMyServer())) continue;
                    this.lastSuccessfulPing = System.currentTimeMillis();
                    break;
                }
                if (!bl) {
                    Set<PingFailedListener> set = pingManager.getPingFailedListeners();
                    for (PingFailedListener pingFailedListener : set) {
                        pingFailedListener.pingFailed();
                    }
                }
            }
            this.sleep();
        }
    }

    private void sleep(int n) {
        int n2 = this.pingInterval + n;
        if (n2 > 0) {
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void sleep() {
        this.sleep(0);
    }
}

