/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;

public class DeliveryReceiptManager
implements PacketListener {
    private static Map<Connection, DeliveryReceiptManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private Connection connection;
    private boolean auto_receipts_enabled = false;
    private Set<ReceiptReceivedListener> receiptReceivedListeners = Collections.synchronizedSet(new HashSet());

    private DeliveryReceiptManager(Connection connection) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        serviceDiscoveryManager.addFeature("urn:xmpp:receipts");
        this.connection = connection;
        instances.put(connection, this);
        connection.addPacketListener(this, new PacketExtensionFilter("urn:xmpp:receipts"));
    }

    public static synchronized DeliveryReceiptManager getInstanceFor(Connection connection) {
        DeliveryReceiptManager deliveryReceiptManager = instances.get(connection);
        if (deliveryReceiptManager == null) {
            deliveryReceiptManager = new DeliveryReceiptManager(connection);
        }
        return deliveryReceiptManager;
    }

    public boolean isSupported(String string) {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(string);
            return discoverInfo.containsFeature("urn:xmpp:receipts");
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }

    @Override
    public void processPacket(Packet packet) {
        Object object;
        Object object2;
        DeliveryReceipt deliveryReceipt = (DeliveryReceipt)packet.getExtension("received", "urn:xmpp:receipts");
        if (deliveryReceipt != null) {
            object2 = this.receiptReceivedListeners.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                object.onReceiptReceived(packet.getFrom(), packet.getTo(), deliveryReceipt.getId());
            }
        }
        if (this.auto_receipts_enabled && (object2 = (DeliveryReceiptRequest)packet.getExtension("request", "urn:xmpp:receipts")) != null) {
            object = new Message(packet.getFrom(), Message.Type.normal);
            ((Packet)object).addExtension(new DeliveryReceipt(packet.getPacketID()));
            this.connection.sendPacket((Packet)object);
        }
    }

    public void setAutoReceiptsEnabled(boolean bl) {
        this.auto_receipts_enabled = bl;
    }

    public void enableAutoReceipts() {
        this.setAutoReceiptsEnabled(true);
    }

    public void disableAutoReceipts() {
        this.setAutoReceiptsEnabled(false);
    }

    public boolean getAutoReceiptsEnabled() {
        return this.auto_receipts_enabled;
    }

    public void registerReceiptReceivedListener(ReceiptReceivedListener receiptReceivedListener) {
        this.receiptReceivedListeners.add(receiptReceivedListener);
    }

    public void unregisterReceiptReceivedListener(ReceiptReceivedListener receiptReceivedListener) {
        this.receiptReceivedListeners.remove(receiptReceivedListener);
    }

    public static boolean hasDeliveryReceiptRequest(Packet packet) {
        return packet.getExtension("request", "urn:xmpp:receipts") != null;
    }

    public static void addDeliveryReceiptRequest(Message message) {
        message.addExtension(new DeliveryReceiptRequest());
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new DeliveryReceiptManager(connection);
            }
        });
    }

    public static interface ReceiptReceivedListener {
        public void onReceiptReceived(String var1, String var2, String var3);
    }
}

