/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.search.UserSearch;

public class UserSearchManager {
    private Connection con;
    private UserSearch userSearch;

    public UserSearchManager(Connection connection) {
        this.con = connection;
        this.userSearch = new UserSearch();
    }

    public Form getSearchForm(String string) throws XMPPException {
        return this.userSearch.getSearchForm(this.con, string);
    }

    public ReportedData getSearchResults(Form form, String string) throws XMPPException {
        return this.userSearch.sendSearchForm(this.con, form, string);
    }

    public Collection<String> getSearchServices() throws XMPPException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.con);
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(this.con.getServiceName());
        Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
        while (iterator.hasNext()) {
            DiscoverItems.Item item = iterator.next();
            try {
                DiscoverInfo discoverInfo;
                try {
                    discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
                }
                catch (XMPPException xMPPException) {
                    continue;
                }
                if (!discoverInfo.containsFeature("jabber:iq:search")) continue;
                arrayList.add(item.getEntityID());
            }
            catch (Exception exception) {
                break;
            }
        }
        return arrayList;
    }
}

