/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jivesoftware.smackx.workgroup.QueueUser;

public class WorkgroupQueue {
    private String name;
    private Status status = Status.CLOSED;
    private int averageWaitTime = -1;
    private Date oldestEntry = null;
    private Set<QueueUser> users = Collections.emptySet();
    private int maxChats = 0;
    private int currentChats = 0;

    WorkgroupQueue(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    void setStatus(Status status) {
        this.status = status;
    }

    public int getUserCount() {
        if (this.users == null) {
            return 0;
        }
        return this.users.size();
    }

    public Iterator<QueueUser> getUsers() {
        if (this.users == null) {
            return new HashSet().iterator();
        }
        return Collections.unmodifiableSet(this.users).iterator();
    }

    void setUsers(Set<QueueUser> set) {
        this.users = set;
    }

    public int getAverageWaitTime() {
        return this.averageWaitTime;
    }

    void setAverageWaitTime(int n) {
        this.averageWaitTime = n;
    }

    public Date getOldestEntry() {
        return this.oldestEntry;
    }

    void setOldestEntry(Date date) {
        this.oldestEntry = date;
    }

    public int getMaxChats() {
        return this.maxChats;
    }

    void setMaxChats(int n) {
        this.maxChats = n;
    }

    public int getCurrentChats() {
        return this.currentChats;
    }

    void setCurrentChats(int n) {
        this.currentChats = n;
    }

    public static class Status {
        public static final Status OPEN = new Status("open");
        public static final Status ACTIVE = new Status("active");
        public static final Status CLOSED = new Status("closed");
        private String value;

        public static Status fromString(String string) {
            if (string == null) {
                return null;
            }
            string = string.toLowerCase();
            if (OPEN.toString().equals(string)) {
                return OPEN;
            }
            if (ACTIVE.toString().equals(string)) {
                return ACTIVE;
            }
            if (CLOSED.toString().equals(string)) {
                return CLOSED;
            }
            return null;
        }

        private Status(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

