/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.ext.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.workgroup.ext.history.AgentChatSession;
import org.xmlpull.v1.XmlPullParser;

public class AgentChatHistory
extends IQ {
    private String agentJID;
    private int maxSessions;
    private long startDate;
    private List<AgentChatSession> agentChatSessions = new ArrayList<AgentChatSession>();
    public static final String ELEMENT_NAME = "chat-sessions";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";

    public AgentChatHistory(String string, int n, Date date) {
        this.agentJID = string;
        this.maxSessions = n;
        this.startDate = date.getTime();
    }

    public AgentChatHistory(String string, int n) {
        this.agentJID = string;
        this.maxSessions = n;
        this.startDate = 0L;
    }

    public AgentChatHistory() {
    }

    public void addChatSession(AgentChatSession agentChatSession) {
        this.agentChatSessions.add(agentChatSession);
    }

    public Collection<AgentChatSession> getAgentChatSessions() {
        return this.agentChatSessions;
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=");
        stringBuilder.append('\"');
        stringBuilder.append(NAMESPACE);
        stringBuilder.append('\"');
        stringBuilder.append(" agentJID=\"" + this.agentJID + "\"");
        stringBuilder.append(" maxSessions=\"" + this.maxSessions + "\"");
        stringBuilder.append(" startDate=\"" + this.startDate + "\"");
        stringBuilder.append("></").append(ELEMENT_NAME).append("> ");
        return stringBuilder.toString();
    }

    public static class InternalProvider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser.getEventType() != 2) {
                throw new IllegalStateException("Parser not in proper position, or bad XML.");
            }
            AgentChatHistory agentChatHistory = new AgentChatHistory();
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && "chat-session".equals(xmlPullParser.getName())) {
                    agentChatHistory.addChatSession(this.parseChatSetting(xmlPullParser));
                    continue;
                }
                if (n != 3 || !AgentChatHistory.ELEMENT_NAME.equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return agentChatHistory;
        }

        private AgentChatSession parseChatSetting(XmlPullParser xmlPullParser) throws Exception {
            boolean bl = false;
            Date date = null;
            long l = 0L;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && "date".equals(xmlPullParser.getName())) {
                    String string5 = xmlPullParser.nextText();
                    long l2 = Long.valueOf(string5);
                    date = new Date(l2);
                    continue;
                }
                if (n == 2 && "duration".equals(xmlPullParser.getName())) {
                    l = Long.valueOf(xmlPullParser.nextText());
                    continue;
                }
                if (n == 2 && "visitorsName".equals(xmlPullParser.getName())) {
                    string = xmlPullParser.nextText();
                    continue;
                }
                if (n == 2 && "visitorsEmail".equals(xmlPullParser.getName())) {
                    string2 = xmlPullParser.nextText();
                    continue;
                }
                if (n == 2 && "sessionID".equals(xmlPullParser.getName())) {
                    string3 = xmlPullParser.nextText();
                    continue;
                }
                if (n == 2 && "question".equals(xmlPullParser.getName())) {
                    string4 = xmlPullParser.nextText();
                    continue;
                }
                if (n != 3 || !"chat-session".equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return new AgentChatSession(date, l, string, string2, string3, string4);
        }
    }
}

