/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.workgroup.agent.InvitationRequest;
import org.jivesoftware.smackx.workgroup.agent.OfferContent;
import org.jivesoftware.smackx.workgroup.agent.TransferRequest;
import org.jivesoftware.smackx.workgroup.agent.UserRequest;
import org.jivesoftware.smackx.workgroup.packet.RoomInvitation;
import org.jivesoftware.smackx.workgroup.packet.RoomTransfer;
import org.jivesoftware.smackx.workgroup.util.MetaDataUtils;
import org.xmlpull.v1.XmlPullParser;

public class OfferRequestProvider
implements IQProvider {
    @Override
    public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
        Object object;
        String string;
        int n = xmlPullParser.getEventType();
        String string2 = null;
        int n2 = -1;
        OfferContent offerContent = null;
        boolean bl = false;
        Map<String, List<String>> map = new HashMap<String, List<String>>();
        if (n != 2) {
            // empty if block
        }
        String string3 = string = xmlPullParser.getAttributeValue("", "jid");
        while (!bl) {
            n = xmlPullParser.next();
            if (n == 2) {
                PacketExtension packetExtension;
                object = xmlPullParser.getName();
                if ("timeout".equals(object)) {
                    n2 = Integer.parseInt(xmlPullParser.nextText());
                    continue;
                }
                if ("metadata".equals(object)) {
                    map = MetaDataUtils.parseMetaData(xmlPullParser);
                    continue;
                }
                if ("session".equals(object)) {
                    string2 = xmlPullParser.getAttributeValue("", "id");
                    continue;
                }
                if ("user".equals(object)) {
                    string3 = xmlPullParser.getAttributeValue("", "id");
                    continue;
                }
                if ("user-request".equals(object)) {
                    offerContent = UserRequest.getInstance();
                    continue;
                }
                if ("invite".equals(object)) {
                    packetExtension = (RoomInvitation)PacketParserUtils.parsePacketExtension("invite", "http://jabber.org/protocol/workgroup", xmlPullParser);
                    offerContent = new InvitationRequest(((RoomInvitation)packetExtension).getInviter(), ((RoomInvitation)packetExtension).getRoom(), ((RoomInvitation)packetExtension).getReason());
                    continue;
                }
                if (!"transfer".equals(object)) continue;
                packetExtension = (RoomTransfer)PacketParserUtils.parsePacketExtension("transfer", "http://jabber.org/protocol/workgroup", xmlPullParser);
                offerContent = new TransferRequest(((RoomTransfer)packetExtension).getInviter(), ((RoomTransfer)packetExtension).getRoom(), ((RoomTransfer)packetExtension).getReason());
                continue;
            }
            if (n != 3 || !"offer".equals(xmlPullParser.getName())) continue;
            bl = true;
        }
        object = new OfferRequestPacket(string, string3, n2, map, string2, offerContent);
        ((IQ)object).setType(IQ.Type.SET);
        return object;
    }

    public static class OfferRequestPacket
    extends IQ {
        private int timeout;
        private String userID;
        private String userJID;
        private Map<String, List<String>> metaData;
        private String sessionID;
        private OfferContent content;

        public OfferRequestPacket(String string, String string2, int n, Map<String, List<String>> map, String string3, OfferContent offerContent) {
            this.userJID = string;
            this.userID = string2;
            this.timeout = n;
            this.metaData = map;
            this.sessionID = string3;
            this.content = offerContent;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getUserJID() {
            return this.userJID;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public OfferContent getContent() {
            return this.content;
        }

        public Map<String, List<String>> getMetaData() {
            return this.metaData;
        }

        @Override
        public String getChildElementXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<offer xmlns=\"http://jabber.org/protocol/workgroup\" jid=\"").append(this.userJID).append("\">");
            stringBuilder.append("<timeout>").append(this.timeout).append("</timeout>");
            if (this.sessionID != null) {
                stringBuilder.append('<').append("session");
                stringBuilder.append(" session=\"");
                stringBuilder.append(this.getSessionID()).append("\" xmlns=\"");
                stringBuilder.append("http://jivesoftware.com/protocol/workgroup").append("\"/>");
            }
            if (this.metaData != null) {
                stringBuilder.append(MetaDataUtils.serializeMetaData(this.metaData));
            }
            if (this.userID != null) {
                stringBuilder.append('<').append("user");
                stringBuilder.append(" id=\"");
                stringBuilder.append(this.userID).append("\" xmlns=\"");
                stringBuilder.append("http://jivesoftware.com/protocol/workgroup").append("\"/>");
            }
            stringBuilder.append("</offer>");
            return stringBuilder.toString();
        }
    }
}

