/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MetaDataUtils {
    public static Map<String, List<String>> parseMetaData(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getEventType();
        if (n == 2 && xmlPullParser.getName().equals("metadata") && xmlPullParser.getNamespace().equals("http://jivesoftware.com/protocol/workgroup")) {
            Hashtable<String, List<String>> hashtable = new Hashtable<String, List<String>>();
            n = xmlPullParser.nextTag();
            while (n != 3 || !xmlPullParser.getName().equals("metadata")) {
                List<String> list;
                String string = xmlPullParser.getAttributeValue(0);
                String string2 = xmlPullParser.nextText();
                if (hashtable.containsKey(string)) {
                    list = (List)hashtable.get(string);
                    list.add(string2);
                } else {
                    list = new ArrayList();
                    list.add(string2);
                    hashtable.put(string, list);
                }
                n = xmlPullParser.nextTag();
            }
            return hashtable;
        }
        return Collections.emptyMap();
    }

    public static String serializeMetaData(Map<String, List<String>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null && map.size() > 0) {
            stringBuilder.append("<metadata xmlns=\"http://jivesoftware.com/protocol/workgroup\">");
            for (String string : map.keySet()) {
                List<String> list = map.get(string);
                for (String string2 : list) {
                    stringBuilder.append("<value name=\"").append(string).append("\">");
                    stringBuilder.append(StringUtils.escapeForXML(string2));
                    stringBuilder.append("</value>");
                }
            }
            stringBuilder.append("</metadata>");
        }
        return stringBuilder.toString();
    }
}

