/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jivesoftware.smackx.workgroup.util.ReverseListIterator;

public final class ModelUtil {
    private ModelUtil() {
    }

    public static final boolean areEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static final boolean areBooleansEqual(Boolean bl, Boolean bl2) {
        return bl == Boolean.TRUE && bl2 == Boolean.TRUE || bl != Boolean.TRUE && bl2 != Boolean.TRUE;
    }

    public static final boolean areDifferent(Object object, Object object2) {
        return !ModelUtil.areEqual(object, object2);
    }

    public static final boolean areBooleansDifferent(Boolean bl, Boolean bl2) {
        return !ModelUtil.areBooleansEqual(bl, bl2);
    }

    public static final boolean hasNonNullElement(Object[] objectArray) {
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null) continue;
                return true;
            }
        }
        return false;
    }

    public static final String concat(String[] stringArray) {
        return ModelUtil.concat(stringArray, " ");
    }

    public static final String concat(String[] stringArray, String string) {
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                if (string2 == null) continue;
                stringBuilder.append(string2).append(string);
            }
            int n = stringBuilder.length();
            if (n > 0) {
                stringBuilder.setLength(n - 1);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static final boolean hasLength(String string) {
        return string != null && string.length() > 0;
    }

    public static final String nullifyIfEmpty(String string) {
        return ModelUtil.hasLength(string) ? string : null;
    }

    public static final String nullifyingToString(Object object) {
        return object != null ? ModelUtil.nullifyIfEmpty(object.toString()) : null;
    }

    public static boolean hasStringChanged(String string, String string2) {
        if (string == null && string2 == null) {
            return false;
        }
        if (string == null && string2 != null || string != null && string2 == null) {
            return true;
        }
        return !string.equals(string2);
    }

    public static String getTimeFromLong(long l) {
        long l2 = (l %= 86400000L) / 3600000L;
        long l3 = (l %= 3600000L) / 60000L;
        long l4 = (l %= 60000L) / 1000L;
        l %= 1000L;
        StringBuilder stringBuilder = new StringBuilder();
        if (l2 > 0L) {
            stringBuilder.append(l2 + " " + "h" + ", ");
        }
        if (l3 > 0L) {
            stringBuilder.append(l3 + " " + "min" + ", ");
        }
        stringBuilder.append(l4 + " " + "sec");
        String string = stringBuilder.toString();
        return string;
    }

    public static <T> List<T> iteratorAsList(Iterator<T> iterator) {
        ArrayList<T> arrayList = new ArrayList<T>(10);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static <T> Iterator<T> reverseListIterator(ListIterator<T> listIterator) {
        return new ReverseListIterator<T>(listIterator);
    }
}

