/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.buffer;

import java.util.List;
import org.github.mikephil.charting.buffer.AbstractBuffer;
import org.github.mikephil.charting.data.BarEntry;

public class BarBuffer
extends AbstractBuffer<BarEntry> {
    protected float mBarSpace = 0.0f;
    protected float mGroupSpace = 0.0f;
    protected int mDataSetIndex = 0;
    protected int mDataSetCount = 1;
    protected boolean mContainsStacks = false;
    protected boolean mInverted = false;

    public BarBuffer(int size, float groupspace, int dataSetCount, boolean containsStacks) {
        super(size);
        this.mGroupSpace = groupspace;
        this.mDataSetCount = dataSetCount;
        this.mContainsStacks = containsStacks;
    }

    public void setBarSpace(float barspace) {
        this.mBarSpace = barspace;
    }

    public void setDataSet(int index) {
        this.mDataSetIndex = index;
    }

    public void setInverted(boolean inverted) {
        this.mInverted = inverted;
    }

    protected void addBar(float left, float top, float right, float bottom) {
        this.buffer[this.index++] = left;
        this.buffer[this.index++] = top;
        this.buffer[this.index++] = right;
        this.buffer[this.index++] = bottom;
    }

    @Override
    public void feed(List<BarEntry> entries) {
        float size = (float)entries.size() * this.phaseX;
        int dataSetOffset = this.mDataSetCount - 1;
        float barSpaceHalf = this.mBarSpace / 2.0f;
        float groupSpaceHalf = this.mGroupSpace / 2.0f;
        float barWidth = 0.5f;
        int i = 0;
        while ((float)i < size) {
            BarEntry e = entries.get(i);
            float x = (float)(e.getXIndex() + e.getXIndex() * dataSetOffset + this.mDataSetIndex) + this.mGroupSpace * (float)e.getXIndex() + groupSpaceHalf;
            float y = e.getVal();
            float[] vals = e.getVals();
            if (!this.mContainsStacks || vals == null) {
                float top;
                float bottom;
                float left = x - barWidth + barSpaceHalf;
                float right = x + barWidth - barSpaceHalf;
                if (this.mInverted) {
                    bottom = y >= 0.0f ? y : 0.0f;
                    top = y <= 0.0f ? y : 0.0f;
                } else {
                    top = y >= 0.0f ? y : 0.0f;
                    float f = bottom = y <= 0.0f ? y : 0.0f;
                }
                if (top > 0.0f) {
                    top *= this.phaseY;
                } else {
                    bottom *= this.phaseY;
                }
                this.addBar(left, top, right, bottom);
            } else {
                float posY = 0.0f;
                float negY = -e.getNegativeSum();
                float yStart = 0.0f;
                int k = 0;
                while (k < vals.length) {
                    float top;
                    float bottom;
                    float value = vals[k];
                    if (value >= 0.0f) {
                        y = posY;
                        posY = yStart = posY + value;
                    } else {
                        y = negY;
                        yStart = negY + Math.abs(value);
                        negY += Math.abs(value);
                    }
                    float left = x - barWidth + barSpaceHalf;
                    float right = x + barWidth - barSpaceHalf;
                    if (this.mInverted) {
                        bottom = y >= yStart ? y : yStart;
                        top = y <= yStart ? y : yStart;
                    } else {
                        top = y >= yStart ? y : yStart;
                        bottom = y <= yStart ? y : yStart;
                    }
                    this.addBar(left, top *= this.phaseY, right, bottom *= this.phaseY);
                    ++k;
                }
            }
            ++i;
        }
        this.reset();
    }
}

