/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.buffer;

import java.util.List;
import org.github.mikephil.charting.buffer.AbstractBuffer;
import org.github.mikephil.charting.data.CandleEntry;

public class CandleBodyBuffer
extends AbstractBuffer<CandleEntry> {
    private float mBodySpace = 0.0f;

    public CandleBodyBuffer(int size) {
        super(size);
    }

    public void setBodySpace(float bodySpace) {
        this.mBodySpace = bodySpace;
    }

    private void addBody(float left, float top, float right, float bottom) {
        this.buffer[this.index++] = left;
        this.buffer[this.index++] = top;
        this.buffer[this.index++] = right;
        this.buffer[this.index++] = bottom;
    }

    @Override
    public void feed(List<CandleEntry> entries) {
        int size = (int)Math.ceil((float)(this.mTo - this.mFrom) * this.phaseX + (float)this.mFrom);
        int i = this.mFrom;
        while (i < size) {
            CandleEntry e = entries.get(i);
            this.addBody((float)e.getXIndex() - 0.5f + this.mBodySpace, e.getClose() * this.phaseY, (float)e.getXIndex() + 0.5f - this.mBodySpace, e.getOpen() * this.phaseY);
            ++i;
        }
        this.reset();
    }
}

