/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.buffer;

import java.util.List;
import org.github.mikephil.charting.buffer.AbstractBuffer;
import org.github.mikephil.charting.data.CandleEntry;

public class CandleShadowBuffer
extends AbstractBuffer<CandleEntry> {
    public CandleShadowBuffer(int size) {
        super(size);
    }

    private void addShadow(float x1, float y1, float x2, float y2) {
        this.buffer[this.index++] = x1;
        this.buffer[this.index++] = y1;
        this.buffer[this.index++] = x2;
        this.buffer[this.index++] = y2;
    }

    @Override
    public void feed(List<CandleEntry> entries) {
        int size = (int)Math.ceil((float)(this.mTo - this.mFrom) * this.phaseX + (float)this.mFrom);
        int i = this.mFrom;
        while (i < size) {
            CandleEntry e = entries.get(i);
            this.addShadow(e.getXIndex(), e.getHigh() * this.phaseY, e.getXIndex(), e.getLow() * this.phaseY);
            ++i;
        }
        this.reset();
    }
}

