/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.buffer;

import java.util.List;
import org.github.mikephil.charting.buffer.AbstractBuffer;
import org.github.mikephil.charting.data.Entry;

public class CircleBuffer
extends AbstractBuffer<Entry> {
    public CircleBuffer(int size) {
        super(size);
    }

    protected void addCircle(float x, float y) {
        this.buffer[this.index++] = x;
        this.buffer[this.index++] = y;
    }

    @Override
    public void feed(List<Entry> entries) {
        int size = (int)Math.ceil((float)(this.mTo - this.mFrom) * this.phaseX + (float)this.mFrom);
        int i = this.mFrom;
        while (i < size) {
            Entry e = entries.get(i);
            this.addCircle(e.getXIndex(), e.getVal() * this.phaseY);
            ++i;
        }
        this.reset();
    }
}

