/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.buffer;

import java.util.List;
import org.github.mikephil.charting.buffer.BarBuffer;
import org.github.mikephil.charting.data.BarEntry;

public class HorizontalBarBuffer
extends BarBuffer {
    public HorizontalBarBuffer(int size, float groupspace, int dataSetCount, boolean containsStacks) {
        super(size, groupspace, dataSetCount, containsStacks);
    }

    @Override
    public void feed(List<BarEntry> entries) {
        float size = (float)entries.size() * this.phaseX;
        int dataSetOffset = this.mDataSetCount - 1;
        float barSpaceHalf = this.mBarSpace / 2.0f;
        float groupSpaceHalf = this.mGroupSpace / 2.0f;
        float barWidth = 0.5f;
        int i = 0;
        while ((float)i < size) {
            BarEntry e = entries.get(i);
            float x = (float)(e.getXIndex() + e.getXIndex() * dataSetOffset + this.mDataSetIndex) + this.mGroupSpace * (float)e.getXIndex() + groupSpaceHalf;
            float y = e.getVal();
            float[] vals = e.getVals();
            if (!this.mContainsStacks || vals == null) {
                float right;
                float left;
                float bottom = x - barWidth + barSpaceHalf;
                float top = x + barWidth - barSpaceHalf;
                if (this.mInverted) {
                    left = y >= 0.0f ? y : 0.0f;
                    right = y <= 0.0f ? y : 0.0f;
                } else {
                    right = y >= 0.0f ? y : 0.0f;
                    float f = left = y <= 0.0f ? y : 0.0f;
                }
                if (right > 0.0f) {
                    right *= this.phaseY;
                } else {
                    left *= this.phaseY;
                }
                this.addBar(left, top, right, bottom);
            } else {
                float posY = 0.0f;
                float negY = -e.getNegativeSum();
                float yStart = 0.0f;
                int k = 0;
                while (k < vals.length) {
                    float right;
                    float left;
                    float value = vals[k];
                    if (value >= 0.0f) {
                        y = posY;
                        posY = yStart = posY + value;
                    } else {
                        y = negY;
                        yStart = negY + Math.abs(value);
                        negY += Math.abs(value);
                    }
                    float bottom = x - barWidth + barSpaceHalf;
                    float top = x + barWidth - barSpaceHalf;
                    if (this.mInverted) {
                        left = y >= yStart ? y : yStart;
                        right = y <= yStart ? y : yStart;
                    } else {
                        right = y >= yStart ? y : yStart;
                        left = y <= yStart ? y : yStart;
                    }
                    this.addBar(left *= this.phaseY, top, right *= this.phaseY, bottom);
                    ++k;
                }
            }
            ++i;
        }
        this.reset();
    }
}

