/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.charts;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import org.github.mikephil.charting.charts.BarChart;
import org.github.mikephil.charting.charts.Chart;
import org.github.mikephil.charting.charts.HorizontalBarChart;
import org.github.mikephil.charting.components.Legend;
import org.github.mikephil.charting.components.XAxis;
import org.github.mikephil.charting.components.YAxis;
import org.github.mikephil.charting.data.BarData;
import org.github.mikephil.charting.data.BarEntry;
import org.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import org.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import org.github.mikephil.charting.data.Entry;
import org.github.mikephil.charting.data.filter.Approximator;
import org.github.mikephil.charting.highlight.ChartHighlighter;
import org.github.mikephil.charting.highlight.Highlight;
import org.github.mikephil.charting.interfaces.BarLineScatterCandleBubbleDataProvider;
import org.github.mikephil.charting.jobs.MoveViewJob;
import org.github.mikephil.charting.listener.BarLineChartTouchListener;
import org.github.mikephil.charting.listener.OnDrawListener;
import org.github.mikephil.charting.renderer.XAxisRenderer;
import org.github.mikephil.charting.renderer.YAxisRenderer;
import org.github.mikephil.charting.utils.PointD;
import org.github.mikephil.charting.utils.Transformer;
import org.github.mikephil.charting.utils.Utils;

@SuppressLint(value={"RtlHardcoded"})
public abstract class BarLineChartBase<T extends BarLineScatterCandleBubbleData<? extends BarLineScatterCandleBubbleDataSet<? extends Entry>>>
extends Chart<T>
implements BarLineScatterCandleBubbleDataProvider {
    protected int mMaxVisibleCount = 100;
    private boolean mAutoScaleMinMaxEnabled = false;
    private Integer mAutoScaleLastLowestVisibleXIndex = null;
    private Integer mAutoScaleLastHighestVisibleXIndex = null;
    protected boolean mPinchZoomEnabled = false;
    protected boolean mDoubleTapToZoomEnabled = true;
    protected boolean mHighlightPerDragEnabled = true;
    private boolean mDragEnabled = true;
    private boolean mScaleXEnabled = true;
    private boolean mScaleYEnabled = true;
    protected boolean mFilterData = false;
    protected Paint mGridBackgroundPaint;
    protected Paint mBorderPaint;
    protected boolean mDrawGridBackground = true;
    protected boolean mDrawBorders = false;
    protected float mMinOffset = 10.0f;
    protected OnDrawListener mDrawListener;
    protected YAxis mAxisLeft;
    protected YAxis mAxisRight;
    protected XAxis mXAxis;
    protected YAxisRenderer mAxisRendererLeft;
    protected YAxisRenderer mAxisRendererRight;
    protected Transformer mLeftAxisTransformer;
    protected Transformer mRightAxisTransformer;
    protected XAxisRenderer mXAxisRenderer;
    private long totalTime = 0L;
    private long drawCycles = 0L;
    private boolean mCustomViewPortEnabled = false;

    public BarLineChartBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public BarLineChartBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarLineChartBase(Context context) {
        super(context);
    }

    @Override
    protected void init() {
        super.init();
        this.mAxisLeft = new YAxis(YAxis.AxisDependency.LEFT);
        this.mAxisRight = new YAxis(YAxis.AxisDependency.RIGHT);
        this.mXAxis = new XAxis();
        this.mLeftAxisTransformer = new Transformer(this.mViewPortHandler);
        this.mRightAxisTransformer = new Transformer(this.mViewPortHandler);
        this.mAxisRendererLeft = new YAxisRenderer(this.mViewPortHandler, this.mAxisLeft, this.mLeftAxisTransformer);
        this.mAxisRendererRight = new YAxisRenderer(this.mViewPortHandler, this.mAxisRight, this.mRightAxisTransformer);
        this.mXAxisRenderer = new XAxisRenderer(this.mViewPortHandler, this.mXAxis, this.mLeftAxisTransformer);
        this.mHighlighter = new ChartHighlighter<BarLineChartBase>(this);
        this.mChartTouchListener = new BarLineChartTouchListener(this, this.mViewPortHandler.getMatrixTouch());
        this.mGridBackgroundPaint = new Paint();
        this.mGridBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mGridBackgroundPaint.setColor(Color.rgb((int)240, (int)240, (int)240));
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(-16777216);
        this.mBorderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        long starttime = System.currentTimeMillis();
        this.calcModulus();
        this.mXAxisRenderer.calcXBounds(this, this.mXAxis.mAxisLabelModulus);
        this.mRenderer.calcXBounds(this, this.mXAxis.mAxisLabelModulus);
        this.drawGridBackground(canvas);
        if (this.mAxisLeft.isEnabled()) {
            this.mAxisRendererLeft.computeAxis(this.mAxisLeft.mAxisMinimum, this.mAxisLeft.mAxisMaximum);
        }
        if (this.mAxisRight.isEnabled()) {
            this.mAxisRendererRight.computeAxis(this.mAxisRight.mAxisMinimum, this.mAxisRight.mAxisMaximum);
        }
        this.mXAxisRenderer.renderAxisLine(canvas);
        this.mAxisRendererLeft.renderAxisLine(canvas);
        this.mAxisRendererRight.renderAxisLine(canvas);
        if (this.mAutoScaleMinMaxEnabled) {
            int lowestVisibleXIndex = this.getLowestVisibleXIndex();
            int highestVisibleXIndex = this.getHighestVisibleXIndex();
            if (this.mAutoScaleLastLowestVisibleXIndex == null || this.mAutoScaleLastLowestVisibleXIndex != lowestVisibleXIndex || this.mAutoScaleLastHighestVisibleXIndex == null || this.mAutoScaleLastHighestVisibleXIndex != highestVisibleXIndex) {
                this.calcMinMax();
                this.calculateOffsets();
                this.mAutoScaleLastLowestVisibleXIndex = lowestVisibleXIndex;
                this.mAutoScaleLastHighestVisibleXIndex = highestVisibleXIndex;
            }
        }
        int clipRestoreCount = canvas.save();
        canvas.clipRect(this.mViewPortHandler.getContentRect());
        this.mXAxisRenderer.renderGridLines(canvas);
        this.mAxisRendererLeft.renderGridLines(canvas);
        this.mAxisRendererRight.renderGridLines(canvas);
        if (this.mXAxis.isDrawLimitLinesBehindDataEnabled()) {
            this.mXAxisRenderer.renderLimitLines(canvas);
        }
        if (this.mAxisLeft.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererLeft.renderLimitLines(canvas);
        }
        if (this.mAxisRight.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererRight.renderLimitLines(canvas);
        }
        this.mRenderer.drawData(canvas);
        if (!this.mXAxis.isDrawLimitLinesBehindDataEnabled()) {
            this.mXAxisRenderer.renderLimitLines(canvas);
        }
        if (!this.mAxisLeft.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererLeft.renderLimitLines(canvas);
        }
        if (!this.mAxisRight.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererRight.renderLimitLines(canvas);
        }
        if (this.valuesToHighlight()) {
            this.mRenderer.drawHighlighted(canvas, this.mIndicesToHighlight);
        }
        canvas.restoreToCount(clipRestoreCount);
        this.mRenderer.drawExtras(canvas);
        this.mXAxisRenderer.renderAxisLabels(canvas);
        this.mAxisRendererLeft.renderAxisLabels(canvas);
        this.mAxisRendererRight.renderAxisLabels(canvas);
        this.mRenderer.drawValues(canvas);
        this.mLegendRenderer.renderLegend(canvas);
        this.drawMarkers(canvas);
        this.drawDescription(canvas);
        if (this.mLogEnabled) {
            long drawtime = System.currentTimeMillis() - starttime;
            this.totalTime += drawtime;
            ++this.drawCycles;
            long average = this.totalTime / this.drawCycles;
            Log.i((String)"MPAndroidChart", (String)("Drawtime: " + drawtime + " ms, average: " + average + " ms, cycles: " + this.drawCycles));
        }
    }

    public void resetTracking() {
        this.totalTime = 0L;
        this.drawCycles = 0L;
    }

    protected void prepareValuePxMatrix() {
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("Preparing Value-Px Matrix, xmin: " + this.mXChartMin + ", xmax: " + this.mXChartMax + ", xdelta: " + this.mDeltaX));
        }
        this.mRightAxisTransformer.prepareMatrixValuePx(this.mXChartMin, this.mDeltaX, this.mAxisRight.mAxisRange, this.mAxisRight.mAxisMinimum);
        this.mLeftAxisTransformer.prepareMatrixValuePx(this.mXChartMin, this.mDeltaX, this.mAxisLeft.mAxisRange, this.mAxisLeft.mAxisMinimum);
    }

    protected void prepareOffsetMatrix() {
        this.mRightAxisTransformer.prepareMatrixOffset(this.mAxisRight.isInverted());
        this.mLeftAxisTransformer.prepareMatrixOffset(this.mAxisLeft.isInverted());
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mDataNotSet) {
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)"Preparing... DATA NOT SET.");
            }
            return;
        }
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)"Preparing...");
        }
        if (this.mRenderer != null) {
            this.mRenderer.initBuffers();
        }
        this.calcMinMax();
        this.mAxisRendererLeft.computeAxis(this.mAxisLeft.mAxisMinimum, this.mAxisLeft.mAxisMaximum);
        this.mAxisRendererRight.computeAxis(this.mAxisRight.mAxisMinimum, this.mAxisRight.mAxisMaximum);
        this.mXAxisRenderer.computeAxis(((BarLineScatterCandleBubbleData)this.mData).getXValAverageLength(), ((BarLineScatterCandleBubbleData)this.mData).getXVals());
        if (this.mLegend != null) {
            this.mLegendRenderer.computeLegend(this.mData);
        }
        this.calculateOffsets();
    }

    @Override
    protected void calcMinMax() {
        if (this.mAutoScaleMinMaxEnabled) {
            ((BarLineScatterCandleBubbleData)this.mData).calcMinMax(this.getLowestVisibleXIndex(), this.getHighestVisibleXIndex());
        }
        float minLeft = ((BarLineScatterCandleBubbleData)this.mData).getYMin(YAxis.AxisDependency.LEFT);
        float maxLeft = ((BarLineScatterCandleBubbleData)this.mData).getYMax(YAxis.AxisDependency.LEFT);
        float minRight = ((BarLineScatterCandleBubbleData)this.mData).getYMin(YAxis.AxisDependency.RIGHT);
        float maxRight = ((BarLineScatterCandleBubbleData)this.mData).getYMax(YAxis.AxisDependency.RIGHT);
        float leftRange = Math.abs(maxLeft - (this.mAxisLeft.isStartAtZeroEnabled() ? 0.0f : minLeft));
        float rightRange = Math.abs(maxRight - (this.mAxisRight.isStartAtZeroEnabled() ? 0.0f : minRight));
        if (leftRange == 0.0f) {
            maxLeft += 1.0f;
            if (!this.mAxisLeft.isStartAtZeroEnabled()) {
                minLeft -= 1.0f;
            }
        }
        if (rightRange == 0.0f) {
            maxRight += 1.0f;
            if (!this.mAxisRight.isStartAtZeroEnabled()) {
                minRight -= 1.0f;
            }
        }
        float topSpaceLeft = leftRange / 100.0f * this.mAxisLeft.getSpaceTop();
        float topSpaceRight = rightRange / 100.0f * this.mAxisRight.getSpaceTop();
        float bottomSpaceLeft = leftRange / 100.0f * this.mAxisLeft.getSpaceBottom();
        float bottomSpaceRight = rightRange / 100.0f * this.mAxisRight.getSpaceBottom();
        this.mXChartMax = ((BarLineScatterCandleBubbleData)this.mData).getXVals().size() - 1;
        this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        if (this.mAxisLeft.isStartAtZeroEnabled()) {
            if (minLeft < 0.0f && maxLeft < 0.0f) {
                this.mAxisLeft.mAxisMinimum = Math.min(0.0f, !Float.isNaN(this.mAxisLeft.getAxisMinValue()) ? this.mAxisLeft.getAxisMinValue() : minLeft - bottomSpaceLeft);
                this.mAxisLeft.mAxisMaximum = 0.0f;
            } else if ((double)minLeft >= 0.0) {
                this.mAxisLeft.mAxisMinimum = 0.0f;
                this.mAxisLeft.mAxisMaximum = Math.max(0.0f, !Float.isNaN(this.mAxisLeft.getAxisMaxValue()) ? this.mAxisLeft.getAxisMaxValue() : maxLeft + topSpaceLeft);
            } else {
                this.mAxisLeft.mAxisMinimum = Math.min(0.0f, !Float.isNaN(this.mAxisLeft.getAxisMinValue()) ? this.mAxisLeft.getAxisMinValue() : minLeft - bottomSpaceLeft);
                this.mAxisLeft.mAxisMaximum = Math.max(0.0f, !Float.isNaN(this.mAxisLeft.getAxisMaxValue()) ? this.mAxisLeft.getAxisMaxValue() : maxLeft + topSpaceLeft);
            }
        } else {
            this.mAxisLeft.mAxisMinimum = !Float.isNaN(this.mAxisLeft.getAxisMinValue()) ? this.mAxisLeft.getAxisMinValue() : minLeft - bottomSpaceLeft;
            float f = this.mAxisLeft.mAxisMaximum = !Float.isNaN(this.mAxisLeft.getAxisMaxValue()) ? this.mAxisLeft.getAxisMaxValue() : maxLeft + topSpaceLeft;
        }
        if (this.mAxisRight.isStartAtZeroEnabled()) {
            if (minRight < 0.0f && maxRight < 0.0f) {
                this.mAxisRight.mAxisMinimum = Math.min(0.0f, !Float.isNaN(this.mAxisRight.getAxisMinValue()) ? this.mAxisRight.getAxisMinValue() : minRight - bottomSpaceRight);
                this.mAxisRight.mAxisMaximum = 0.0f;
            } else if (minRight >= 0.0f) {
                this.mAxisRight.mAxisMinimum = 0.0f;
                this.mAxisRight.mAxisMaximum = Math.max(0.0f, !Float.isNaN(this.mAxisRight.getAxisMaxValue()) ? this.mAxisRight.getAxisMaxValue() : maxRight + topSpaceRight);
            } else {
                this.mAxisRight.mAxisMinimum = Math.min(0.0f, !Float.isNaN(this.mAxisRight.getAxisMinValue()) ? this.mAxisRight.getAxisMinValue() : minRight - bottomSpaceRight);
                this.mAxisRight.mAxisMaximum = Math.max(0.0f, !Float.isNaN(this.mAxisRight.getAxisMaxValue()) ? this.mAxisRight.getAxisMaxValue() : maxRight + topSpaceRight);
            }
        } else {
            this.mAxisRight.mAxisMinimum = !Float.isNaN(this.mAxisRight.getAxisMinValue()) ? this.mAxisRight.getAxisMinValue() : minRight - bottomSpaceRight;
            this.mAxisRight.mAxisMaximum = !Float.isNaN(this.mAxisRight.getAxisMaxValue()) ? this.mAxisRight.getAxisMaxValue() : maxRight + topSpaceRight;
        }
        this.mAxisLeft.mAxisRange = Math.abs(this.mAxisLeft.mAxisMaximum - this.mAxisLeft.mAxisMinimum);
        this.mAxisRight.mAxisRange = Math.abs(this.mAxisRight.mAxisMaximum - this.mAxisRight.mAxisMinimum);
    }

    @Override
    public void calculateOffsets() {
        if (!this.mCustomViewPortEnabled) {
            float offsetLeft = 0.0f;
            float offsetRight = 0.0f;
            float offsetTop = 0.0f;
            float offsetBottom = 0.0f;
            if (this.mLegend != null && this.mLegend.isEnabled()) {
                float yOffset;
                if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART_CENTER) {
                    offsetRight += Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getXOffset() * 2.0f;
                } else if (this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART_CENTER) {
                    offsetLeft += Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getXOffset() * 2.0f;
                } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
                    yOffset = this.mLegend.mTextHeightMax;
                    offsetBottom += Math.min(this.mLegend.mNeededHeight + yOffset, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                } else if (this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.ABOVE_CHART_CENTER) {
                    yOffset = this.mLegend.mTextHeightMax;
                    offsetTop += Math.min(this.mLegend.mNeededHeight + yOffset, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                }
            }
            if (this.mAxisLeft.needsOffset()) {
                offsetLeft += this.mAxisLeft.getRequiredWidthSpace(this.mAxisRendererLeft.getPaintAxisLabels());
            }
            if (this.mAxisRight.needsOffset()) {
                offsetRight += this.mAxisRight.getRequiredWidthSpace(this.mAxisRendererRight.getPaintAxisLabels());
            }
            if (this.mXAxis.isEnabled() && this.mXAxis.isDrawLabelsEnabled()) {
                float xlabelheight = (float)this.mXAxis.mLabelRotatedHeight + this.mXAxis.getYOffset();
                if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
                    offsetBottom += xlabelheight;
                } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
                    offsetTop += xlabelheight;
                } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
                    offsetBottom += xlabelheight;
                    offsetTop += xlabelheight;
                }
            }
            float minOffset = Utils.convertDpToPixel(this.mMinOffset);
            this.mViewPortHandler.restrainViewPort(Math.max(minOffset, offsetLeft += this.getExtraLeftOffset()), Math.max(minOffset, offsetTop += this.getExtraTopOffset()), Math.max(minOffset, offsetRight += this.getExtraRightOffset()), Math.max(minOffset, offsetBottom += this.getExtraBottomOffset()));
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)("offsetLeft: " + offsetLeft + ", offsetTop: " + offsetTop + ", offsetRight: " + offsetRight + ", offsetBottom: " + offsetBottom));
                Log.i((String)"MPAndroidChart", (String)("Content: " + this.mViewPortHandler.getContentRect().toString()));
            }
        }
        this.prepareOffsetMatrix();
        this.prepareValuePxMatrix();
    }

    protected void calcModulus() {
        if (this.mXAxis == null || !this.mXAxis.isEnabled()) {
            return;
        }
        if (!this.mXAxis.isAxisModulusCustom()) {
            float[] values = new float[9];
            this.mViewPortHandler.getMatrixTouch().getValues(values);
            this.mXAxis.mAxisLabelModulus = (int)Math.ceil((float)(((BarLineScatterCandleBubbleData)this.mData).getXValCount() * this.mXAxis.mLabelRotatedWidth) / (this.mViewPortHandler.contentWidth() * values[0]));
        }
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("X-Axis modulus: " + this.mXAxis.mAxisLabelModulus + ", x-axis label width: " + this.mXAxis.mLabelWidth + ", x-axis label rotated width: " + this.mXAxis.mLabelRotatedWidth + ", content width: " + this.mViewPortHandler.contentWidth()));
        }
        if (this.mXAxis.mAxisLabelModulus < 1) {
            this.mXAxis.mAxisLabelModulus = 1;
        }
    }

    @Override
    protected float[] getMarkerPosition(Entry e, Highlight highlight) {
        int dataSetIndex = highlight.getDataSetIndex();
        float xPos = e.getXIndex();
        float yPos = e.getVal();
        if (this instanceof BarChart) {
            BarData bd = (BarData)this.mData;
            float space = bd.getGroupSpace();
            int setCount = ((BarLineScatterCandleBubbleData)this.mData).getDataSetCount();
            int i = e.getXIndex();
            if (this instanceof HorizontalBarChart) {
                float y;
                yPos = y = (float)(i + i * (setCount - 1) + dataSetIndex) + space * (float)i + space / 2.0f;
                BarEntry entry = (BarEntry)e;
                xPos = entry.getVals() != null ? highlight.getRange().to : e.getVal();
                xPos *= this.mAnimator.getPhaseY();
            } else {
                float x;
                xPos = x = (float)(i + i * (setCount - 1) + dataSetIndex) + space * (float)i + space / 2.0f;
                BarEntry entry = (BarEntry)e;
                yPos = entry.getVals() != null ? highlight.getRange().to : e.getVal();
                yPos *= this.mAnimator.getPhaseY();
            }
        } else {
            yPos *= this.mAnimator.getPhaseY();
        }
        float[] pts = new float[]{xPos, yPos};
        this.getTransformer(((BarLineScatterCandleBubbleDataSet)((BarLineScatterCandleBubbleData)this.mData).getDataSetByIndex(dataSetIndex)).getAxisDependency()).pointValuesToPixel(pts);
        return pts;
    }

    protected void drawGridBackground(Canvas c) {
        if (this.mDrawGridBackground) {
            c.drawRect(this.mViewPortHandler.getContentRect(), this.mGridBackgroundPaint);
        }
        if (this.mDrawBorders) {
            c.drawRect(this.mViewPortHandler.getContentRect(), this.mBorderPaint);
        }
    }

    @Override
    public Transformer getTransformer(YAxis.AxisDependency which) {
        if (which == YAxis.AxisDependency.LEFT) {
            return this.mLeftAxisTransformer;
        }
        return this.mRightAxisTransformer;
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (this.mChartTouchListener == null || this.mDataNotSet) {
            return false;
        }
        if (!this.mTouchEnabled) {
            return false;
        }
        return this.mChartTouchListener.onTouch((View)this, event);
    }

    public void computeScroll() {
        if (this.mChartTouchListener instanceof BarLineChartTouchListener) {
            ((BarLineChartTouchListener)this.mChartTouchListener).computeScroll();
        }
    }

    public void zoomIn() {
        Matrix save = this.mViewPortHandler.zoomIn((float)this.getWidth() / 2.0f, -((float)this.getHeight() / 2.0f));
        this.mViewPortHandler.refresh(save, (View)this, true);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void zoomOut() {
        Matrix save = this.mViewPortHandler.zoomOut((float)this.getWidth() / 2.0f, -((float)this.getHeight() / 2.0f));
        this.mViewPortHandler.refresh(save, (View)this, true);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void zoom(float scaleX, float scaleY, float x, float y) {
        Matrix save = this.mViewPortHandler.zoom(scaleX, scaleY, x, -y);
        this.mViewPortHandler.refresh(save, (View)this, true);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void fitScreen() {
        Matrix save = this.mViewPortHandler.fitScreen();
        this.mViewPortHandler.refresh(save, (View)this, true);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void setScaleMinima(float scaleX, float scaleY) {
        this.mViewPortHandler.setMinimumScaleX(scaleX);
        this.mViewPortHandler.setMinimumScaleY(scaleY);
    }

    public void setVisibleXRangeMaximum(float maxXRange) {
        float xScale = this.mDeltaX / maxXRange;
        this.mViewPortHandler.setMinimumScaleX(xScale);
    }

    public void setVisibleXRangeMinimum(float minXRange) {
        float xScale = this.mDeltaX / minXRange;
        this.mViewPortHandler.setMaximumScaleX(xScale);
    }

    public void setVisibleXRange(float minXRange, float maxXRange) {
        float maxScale = this.mDeltaX / minXRange;
        float minScale = this.mDeltaX / maxXRange;
        this.mViewPortHandler.setMinMaxScaleX(minScale, maxScale);
    }

    public void setVisibleYRangeMaximum(float maxYRange, YAxis.AxisDependency axis) {
        float yScale = this.getDeltaY(axis) / maxYRange;
        this.mViewPortHandler.setMinimumScaleY(yScale);
    }

    public void moveViewToX(float xIndex) {
        MoveViewJob job = new MoveViewJob(this.mViewPortHandler, xIndex, 0.0f, this.getTransformer(YAxis.AxisDependency.LEFT), (View)this);
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(job);
        } else {
            this.mJobs.add(job);
        }
    }

    public void moveViewToY(float yValue, YAxis.AxisDependency axis) {
        float valsInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
        MoveViewJob job = new MoveViewJob(this.mViewPortHandler, 0.0f, yValue + valsInView / 2.0f, this.getTransformer(axis), (View)this);
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(job);
        } else {
            this.mJobs.add(job);
        }
    }

    public void moveViewTo(float xIndex, float yValue, YAxis.AxisDependency axis) {
        float valsInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
        MoveViewJob job = new MoveViewJob(this.mViewPortHandler, xIndex, yValue + valsInView / 2.0f, this.getTransformer(axis), (View)this);
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(job);
        } else {
            this.mJobs.add(job);
        }
    }

    public void centerViewTo(int xIndex, float yValue, YAxis.AxisDependency axis) {
        float valsInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
        float xsInView = (float)this.getXAxis().getValues().size() / this.mViewPortHandler.getScaleX();
        MoveViewJob job = new MoveViewJob(this.mViewPortHandler, (float)xIndex - xsInView / 2.0f, yValue + valsInView / 2.0f, this.getTransformer(axis), (View)this);
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(job);
        } else {
            this.mJobs.add(job);
        }
    }

    public void setViewPortOffsets(final float left, final float top, final float right, final float bottom) {
        this.mCustomViewPortEnabled = true;
        this.post(new Runnable(){

            @Override
            public void run() {
                BarLineChartBase.this.mViewPortHandler.restrainViewPort(left, top, right, bottom);
                BarLineChartBase.this.prepareOffsetMatrix();
                BarLineChartBase.this.prepareValuePxMatrix();
            }
        });
    }

    public void resetViewPortOffsets() {
        this.mCustomViewPortEnabled = false;
        this.calculateOffsets();
    }

    public float getDeltaY(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            return this.mAxisLeft.mAxisRange;
        }
        return this.mAxisRight.mAxisRange;
    }

    public void setOnDrawListener(OnDrawListener drawListener) {
        this.mDrawListener = drawListener;
    }

    public OnDrawListener getDrawListener() {
        return this.mDrawListener;
    }

    public PointF getPosition(Entry e, YAxis.AxisDependency axis) {
        if (e == null) {
            return null;
        }
        float[] vals = new float[]{e.getXIndex(), e.getVal()};
        this.getTransformer(axis).pointValuesToPixel(vals);
        return new PointF(vals[0], vals[1]);
    }

    public void setMaxVisibleValueCount(int count) {
        this.mMaxVisibleCount = count;
    }

    @Override
    public int getMaxVisibleCount() {
        return this.mMaxVisibleCount;
    }

    public void setHighlightPerDragEnabled(boolean enabled) {
        this.mHighlightPerDragEnabled = enabled;
    }

    public boolean isHighlightPerDragEnabled() {
        return this.mHighlightPerDragEnabled;
    }

    public void setGridBackgroundColor(int color) {
        this.mGridBackgroundPaint.setColor(color);
    }

    public void setDragEnabled(boolean enabled) {
        this.mDragEnabled = enabled;
    }

    public boolean isDragEnabled() {
        return this.mDragEnabled;
    }

    public void setScaleEnabled(boolean enabled) {
        this.mScaleXEnabled = enabled;
        this.mScaleYEnabled = enabled;
    }

    public void setScaleXEnabled(boolean enabled) {
        this.mScaleXEnabled = enabled;
    }

    public void setScaleYEnabled(boolean enabled) {
        this.mScaleYEnabled = enabled;
    }

    public boolean isScaleXEnabled() {
        return this.mScaleXEnabled;
    }

    public boolean isScaleYEnabled() {
        return this.mScaleYEnabled;
    }

    public void setDoubleTapToZoomEnabled(boolean enabled) {
        this.mDoubleTapToZoomEnabled = enabled;
    }

    public boolean isDoubleTapToZoomEnabled() {
        return this.mDoubleTapToZoomEnabled;
    }

    public void setDrawGridBackground(boolean enabled) {
        this.mDrawGridBackground = enabled;
    }

    public void setDrawBorders(boolean enabled) {
        this.mDrawBorders = enabled;
    }

    public void setBorderWidth(float width) {
        this.mBorderPaint.setStrokeWidth(Utils.convertDpToPixel(width));
    }

    public void setBorderColor(int color) {
        this.mBorderPaint.setColor(color);
    }

    public float getMinOffset() {
        return this.mMinOffset;
    }

    public void setMinOffset(float minOffset) {
        this.mMinOffset = minOffset;
    }

    public Highlight getHighlightByTouchPoint(float x, float y) {
        if (this.mDataNotSet || this.mData == null) {
            Log.e((String)"MPAndroidChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        return this.mHighlighter.getHighlight(x, y);
    }

    public PointD getValuesByTouchPoint(float x, float y, YAxis.AxisDependency axis) {
        float[] pts = new float[]{x, y};
        this.getTransformer(axis).pixelsToValue(pts);
        double xTouchVal = pts[0];
        double yTouchVal = pts[1];
        return new PointD(xTouchVal, yTouchVal);
    }

    public PointD getPixelsForValues(float x, float y, YAxis.AxisDependency axis) {
        float[] pts = new float[]{x, y};
        this.getTransformer(axis).pointValuesToPixel(pts);
        return new PointD(pts[0], pts[1]);
    }

    public float getYValueByTouchPoint(float x, float y, YAxis.AxisDependency axis) {
        return (float)this.getValuesByTouchPoint((float)x, (float)y, (YAxis.AxisDependency)axis).y;
    }

    public Entry getEntryByTouchPoint(float x, float y) {
        Highlight h = this.getHighlightByTouchPoint(x, y);
        if (h != null) {
            return ((BarLineScatterCandleBubbleData)this.mData).getEntryForHighlight(h);
        }
        return null;
    }

    public BarLineScatterCandleBubbleDataSet<? extends Entry> getDataSetByTouchPoint(float x, float y) {
        Highlight h = this.getHighlightByTouchPoint(x, y);
        if (h != null) {
            return (BarLineScatterCandleBubbleDataSet)((BarLineScatterCandleBubbleData)this.mData).getDataSetByIndex(h.getDataSetIndex());
        }
        return null;
    }

    @Override
    public int getLowestVisibleXIndex() {
        float[] pts = new float[]{this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        return pts[0] <= 0.0f ? 0 : (int)(pts[0] + 1.0f);
    }

    @Override
    public int getHighestVisibleXIndex() {
        float[] pts = new float[]{this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        return pts[0] >= (float)((BarLineScatterCandleBubbleData)this.mData).getXValCount() ? ((BarLineScatterCandleBubbleData)this.mData).getXValCount() - 1 : (int)pts[0];
    }

    public float getScaleX() {
        if (this.mViewPortHandler == null) {
            return 1.0f;
        }
        return this.mViewPortHandler.getScaleX();
    }

    public float getScaleY() {
        if (this.mViewPortHandler == null) {
            return 1.0f;
        }
        return this.mViewPortHandler.getScaleY();
    }

    public boolean isFullyZoomedOut() {
        return this.mViewPortHandler.isFullyZoomedOut();
    }

    public YAxis getAxisLeft() {
        return this.mAxisLeft;
    }

    public YAxis getAxisRight() {
        return this.mAxisRight;
    }

    public YAxis getAxis(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            return this.mAxisLeft;
        }
        return this.mAxisRight;
    }

    @Override
    public boolean isInverted(YAxis.AxisDependency axis) {
        return this.getAxis(axis).isInverted();
    }

    public XAxis getXAxis() {
        return this.mXAxis;
    }

    public void enableFiltering(Approximator a) {
        this.mFilterData = true;
    }

    public void disableFiltering() {
        this.mFilterData = false;
    }

    public boolean isFilteringEnabled() {
        return this.mFilterData;
    }

    public void setPinchZoom(boolean enabled) {
        this.mPinchZoomEnabled = enabled;
    }

    public boolean isPinchZoomEnabled() {
        return this.mPinchZoomEnabled;
    }

    public void setDragOffsetX(float offset) {
        this.mViewPortHandler.setDragOffsetX(offset);
    }

    public void setDragOffsetY(float offset) {
        this.mViewPortHandler.setDragOffsetY(offset);
    }

    public boolean hasNoDragOffset() {
        return this.mViewPortHandler.hasNoDragOffset();
    }

    public XAxisRenderer getRendererXAxis() {
        return this.mXAxisRenderer;
    }

    public void setXAxisRenderer(XAxisRenderer xAxisRenderer) {
        this.mXAxisRenderer = xAxisRenderer;
    }

    public YAxisRenderer getRendererLeftYAxis() {
        return this.mAxisRendererLeft;
    }

    public void setRendererLeftYAxis(YAxisRenderer rendererLeftYAxis) {
        this.mAxisRendererLeft = rendererLeftYAxis;
    }

    public YAxisRenderer getRendererRightYAxis() {
        return this.mAxisRendererRight;
    }

    public void setRendererRightYAxis(YAxisRenderer rendererRightYAxis) {
        this.mAxisRendererRight = rendererRightYAxis;
    }

    @Override
    public float getYChartMax() {
        return Math.max(this.mAxisLeft.mAxisMaximum, this.mAxisRight.mAxisMaximum);
    }

    @Override
    public float getYChartMin() {
        return Math.min(this.mAxisLeft.mAxisMinimum, this.mAxisRight.mAxisMinimum);
    }

    public boolean isAnyAxisInverted() {
        if (this.mAxisLeft.isInverted()) {
            return true;
        }
        return this.mAxisRight.isInverted();
    }

    public void setAutoScaleMinMaxEnabled(boolean enabled) {
        this.mAutoScaleMinMaxEnabled = enabled;
    }

    public boolean isAutoScaleMinMaxEnabled() {
        return this.mAutoScaleMinMaxEnabled;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 4: {
                this.mGridBackgroundPaint = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        Paint p = super.getPaint(which);
        if (p != null) {
            return p;
        }
        switch (which) {
            case 4: {
                return this.mGridBackgroundPaint;
            }
        }
        return null;
    }
}

