/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.charts;

import android.content.Context;
import android.util.AttributeSet;
import org.github.mikephil.charting.charts.BarLineChartBase;
import org.github.mikephil.charting.data.BarData;
import org.github.mikephil.charting.data.BubbleData;
import org.github.mikephil.charting.data.BubbleDataSet;
import org.github.mikephil.charting.data.CandleData;
import org.github.mikephil.charting.data.CombinedData;
import org.github.mikephil.charting.data.LineData;
import org.github.mikephil.charting.data.ScatterData;
import org.github.mikephil.charting.highlight.CombinedHighlighter;
import org.github.mikephil.charting.interfaces.BarDataProvider;
import org.github.mikephil.charting.interfaces.BubbleDataProvider;
import org.github.mikephil.charting.interfaces.CandleDataProvider;
import org.github.mikephil.charting.interfaces.LineDataProvider;
import org.github.mikephil.charting.interfaces.ScatterDataProvider;
import org.github.mikephil.charting.renderer.CombinedChartRenderer;

public class CombinedChart
extends BarLineChartBase<CombinedData>
implements LineDataProvider,
BarDataProvider,
ScatterDataProvider,
CandleDataProvider,
BubbleDataProvider {
    private boolean mDrawHighlightArrow = false;
    private boolean mDrawValueAboveBar = true;
    private boolean mDrawBarShadow = false;
    protected DrawOrder[] mDrawOrder = new DrawOrder[]{DrawOrder.BAR, DrawOrder.BUBBLE, DrawOrder.LINE, DrawOrder.CANDLE, DrawOrder.SCATTER};

    public CombinedChart(Context context) {
        super(context);
    }

    public CombinedChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CombinedChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mHighlighter = new CombinedHighlighter(this);
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        if (this.getBarData() != null || this.getCandleData() != null || this.getBubbleData() != null) {
            this.mXChartMin = -0.5f;
            this.mXChartMax = (float)((CombinedData)this.mData).getXVals().size() - 0.5f;
            if (this.getBubbleData() != null) {
                for (BubbleDataSet set : this.getBubbleData().getDataSets()) {
                    float xmin = set.getXMin();
                    float xmax = set.getXMax();
                    if (xmin < this.mXChartMin) {
                        this.mXChartMin = xmin;
                    }
                    if (!(xmax > this.mXChartMax)) continue;
                    this.mXChartMax = xmax;
                }
            }
        }
        this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        if (this.mDeltaX == 0.0f && this.getLineData() != null && this.getLineData().getYValCount() > 0) {
            this.mDeltaX = 1.0f;
        }
    }

    @Override
    public void setData(CombinedData data) {
        this.mData = null;
        this.mRenderer = null;
        super.setData(data);
        this.mRenderer = new CombinedChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.mRenderer.initBuffers();
    }

    @Override
    public LineData getLineData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getLineData();
    }

    @Override
    public BarData getBarData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getBarData();
    }

    @Override
    public ScatterData getScatterData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getScatterData();
    }

    @Override
    public CandleData getCandleData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getCandleData();
    }

    @Override
    public BubbleData getBubbleData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getBubbleData();
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return this.mDrawBarShadow;
    }

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return this.mDrawValueAboveBar;
    }

    @Override
    public boolean isDrawHighlightArrowEnabled() {
        return this.mDrawHighlightArrow;
    }

    public void setDrawHighlightArrow(boolean enabled) {
        this.mDrawHighlightArrow = enabled;
    }

    public void setDrawValueAboveBar(boolean enabled) {
        this.mDrawValueAboveBar = enabled;
    }

    public void setDrawBarShadow(boolean enabled) {
        this.mDrawBarShadow = enabled;
    }

    public DrawOrder[] getDrawOrder() {
        return this.mDrawOrder;
    }

    public void setDrawOrder(DrawOrder[] order) {
        if (order == null || order.length <= 0) {
            return;
        }
        this.mDrawOrder = order;
    }

    public static enum DrawOrder {
        BAR,
        BUBBLE,
        LINE,
        CANDLE,
        SCATTER;

    }
}

