/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.data;

import android.graphics.Color;
import java.util.ArrayList;
import java.util.List;
import org.github.mikephil.charting.data.BarEntry;
import org.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import org.github.mikephil.charting.data.DataSet;

public class BarDataSet
extends BarLineScatterCandleBubbleDataSet<BarEntry> {
    private float mBarSpace = 0.15f;
    private int mStackSize = 1;
    private int mBarShadowColor = Color.rgb((int)215, (int)215, (int)215);
    private int mHighLightAlpha = 120;
    private int mEntryCountStacks = 0;
    private String[] mStackLabels = new String[]{"Stack"};

    public BarDataSet(List<BarEntry> yVals, String label) {
        super(yVals, label);
        this.mHighLightColor = Color.rgb((int)0, (int)0, (int)0);
        this.calcStackSize(yVals);
        this.calcEntryCountIncludingStacks(yVals);
    }

    @Override
    public DataSet<BarEntry> copy() {
        ArrayList<BarEntry> yVals = new ArrayList<BarEntry>();
        int i = 0;
        while (i < this.mYVals.size()) {
            yVals.add(((BarEntry)this.mYVals.get(i)).copy());
            ++i;
        }
        BarDataSet copied = new BarDataSet((List<BarEntry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mStackSize = this.mStackSize;
        copied.mBarSpace = this.mBarSpace;
        copied.mBarShadowColor = this.mBarShadowColor;
        copied.mStackLabels = this.mStackLabels;
        copied.mHighLightColor = this.mHighLightColor;
        copied.mHighLightAlpha = this.mHighLightAlpha;
        return copied;
    }

    private void calcEntryCountIncludingStacks(List<BarEntry> yVals) {
        this.mEntryCountStacks = 0;
        int i = 0;
        while (i < yVals.size()) {
            float[] vals = yVals.get(i).getVals();
            this.mEntryCountStacks = vals == null ? ++this.mEntryCountStacks : (this.mEntryCountStacks += vals.length);
            ++i;
        }
    }

    private void calcStackSize(List<BarEntry> yVals) {
        int i = 0;
        while (i < yVals.size()) {
            float[] vals = yVals.get(i).getVals();
            if (vals != null && vals.length > this.mStackSize) {
                this.mStackSize = vals.length;
            }
            ++i;
        }
    }

    @Override
    protected void calcMinMax(int start, int end) {
        int yValCount = this.mYVals.size();
        if (yValCount == 0) {
            return;
        }
        int endValue = end == 0 || end >= yValCount ? yValCount - 1 : end;
        this.mLastStart = start;
        this.mLastEnd = endValue;
        this.mYMin = Float.MAX_VALUE;
        this.mYMax = -3.4028235E38f;
        int i = start;
        while (i <= endValue) {
            BarEntry e = (BarEntry)this.mYVals.get(i);
            if (e != null && !Float.isNaN(e.getVal())) {
                if (e.getVals() == null) {
                    if (e.getVal() < this.mYMin) {
                        this.mYMin = e.getVal();
                    }
                    if (e.getVal() > this.mYMax) {
                        this.mYMax = e.getVal();
                    }
                } else {
                    if (-e.getNegativeSum() < this.mYMin) {
                        this.mYMin = -e.getNegativeSum();
                    }
                    if (e.getPositiveSum() > this.mYMax) {
                        this.mYMax = e.getPositiveSum();
                    }
                }
            }
            ++i;
        }
        if (this.mYMin == Float.MAX_VALUE) {
            this.mYMin = 0.0f;
            this.mYMax = 0.0f;
        }
    }

    public int getStackSize() {
        return this.mStackSize;
    }

    public boolean isStacked() {
        return this.mStackSize > 1;
    }

    public int getEntryCountStacks() {
        return this.mEntryCountStacks;
    }

    public float getBarSpacePercent() {
        return this.mBarSpace * 100.0f;
    }

    public float getBarSpace() {
        return this.mBarSpace;
    }

    public void setBarSpacePercent(float percent) {
        this.mBarSpace = percent / 100.0f;
    }

    public void setBarShadowColor(int color) {
        this.mBarShadowColor = color;
    }

    public int getBarShadowColor() {
        return this.mBarShadowColor;
    }

    public void setHighLightAlpha(int alpha) {
        this.mHighLightAlpha = alpha;
    }

    public int getHighLightAlpha() {
        return this.mHighLightAlpha;
    }

    public void setStackLabels(String[] labels) {
        this.mStackLabels = labels;
    }

    public String[] getStackLabels() {
        return this.mStackLabels;
    }
}

