/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.data;

import org.github.mikephil.charting.data.Entry;

public class BarEntry
extends Entry {
    private float[] mVals;
    private float mNegativeSum;
    private float mPositiveSum;

    public BarEntry(float[] vals, int xIndex) {
        super(BarEntry.calcSum(vals), xIndex);
        this.mVals = vals;
        this.calcPosNegSum();
    }

    public BarEntry(float val, int xIndex) {
        super(val, xIndex);
    }

    public BarEntry(float[] vals, int xIndex, String label) {
        super(BarEntry.calcSum(vals), xIndex, label);
        this.mVals = vals;
        this.calcPosNegSum();
    }

    public BarEntry(float val, int xIndex, Object data) {
        super(val, xIndex, data);
    }

    @Override
    public BarEntry copy() {
        BarEntry copied = new BarEntry(this.getVal(), this.getXIndex(), this.getData());
        copied.setVals(this.mVals);
        return copied;
    }

    public float[] getVals() {
        return this.mVals;
    }

    public void setVals(float[] vals) {
        this.setVal(BarEntry.calcSum(vals));
        this.mVals = vals;
        this.calcPosNegSum();
    }

    @Override
    public float getVal() {
        return super.getVal();
    }

    public boolean isStacked() {
        return this.mVals != null;
    }

    public float getBelowSum(int stackIndex) {
        if (this.mVals == null) {
            return 0.0f;
        }
        float remainder = 0.0f;
        int index = this.mVals.length - 1;
        while (index > stackIndex && index >= 0) {
            remainder += this.mVals[index];
            --index;
        }
        return remainder;
    }

    public float getPositiveSum() {
        return this.mPositiveSum;
    }

    public float getNegativeSum() {
        return this.mNegativeSum;
    }

    private void calcPosNegSum() {
        if (this.mVals == null) {
            this.mNegativeSum = 0.0f;
            this.mPositiveSum = 0.0f;
            return;
        }
        float sumNeg = 0.0f;
        float sumPos = 0.0f;
        float[] fArray = this.mVals;
        int n = this.mVals.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            if (f <= 0.0f) {
                sumNeg += Math.abs(f);
            } else {
                sumPos += f;
            }
            ++n2;
        }
        this.mNegativeSum = sumNeg;
        this.mPositiveSum = sumPos;
    }

    private static float calcSum(float[] vals) {
        if (vals == null) {
            return 0.0f;
        }
        float sum = 0.0f;
        float[] fArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            sum += f;
            ++n2;
        }
        return sum;
    }
}

