/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.data;

import android.graphics.Color;
import java.util.ArrayList;
import java.util.List;
import org.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import org.github.mikephil.charting.data.BubbleEntry;
import org.github.mikephil.charting.data.DataSet;
import org.github.mikephil.charting.utils.Utils;

public class BubbleDataSet
extends BarLineScatterCandleBubbleDataSet<BubbleEntry> {
    protected float mXMax;
    protected float mXMin;
    protected float mMaxSize;
    private float mHighlightCircleWidth = 2.5f;

    public BubbleDataSet(List<BubbleEntry> yVals, String label) {
        super(yVals, label);
    }

    public void setHighlightCircleWidth(float width) {
        this.mHighlightCircleWidth = Utils.convertDpToPixel(width);
    }

    public float getHighlightCircleWidth() {
        return this.mHighlightCircleWidth;
    }

    public void setColor(int color, int alpha) {
        super.setColor(Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color)));
    }

    @Override
    protected void calcMinMax(int start, int end) {
        if (this.mYVals.size() == 0) {
            return;
        }
        List entries = this.getYVals();
        int endValue = end == 0 ? this.mYVals.size() - 1 : end;
        this.mLastStart = start;
        this.mLastEnd = endValue;
        this.mYMin = this.yMin((BubbleEntry)entries.get(start));
        this.mYMax = this.yMax((BubbleEntry)entries.get(start));
        int i = start;
        while (i <= endValue) {
            float size;
            BubbleEntry entry = (BubbleEntry)entries.get(i);
            float ymin = this.yMin(entry);
            float ymax = this.yMax(entry);
            if (ymin < this.mYMin) {
                this.mYMin = ymin;
            }
            if (ymax > this.mYMax) {
                this.mYMax = ymax;
            }
            float xmin = this.xMin(entry);
            float xmax = this.xMax(entry);
            if (xmin < this.mXMin) {
                this.mXMin = xmin;
            }
            if (xmax > this.mXMax) {
                this.mXMax = xmax;
            }
            if ((size = this.largestSize(entry)) > this.mMaxSize) {
                this.mMaxSize = size;
            }
            ++i;
        }
    }

    @Override
    public DataSet<BubbleEntry> copy() {
        ArrayList<BubbleEntry> yVals = new ArrayList<BubbleEntry>();
        int i = 0;
        while (i < this.mYVals.size()) {
            yVals.add(((BubbleEntry)this.mYVals.get(i)).copy());
            ++i;
        }
        BubbleDataSet copied = new BubbleDataSet((List<BubbleEntry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mHighLightColor = this.mHighLightColor;
        return copied;
    }

    public float getXMax() {
        return this.mXMax;
    }

    public float getXMin() {
        return this.mXMin;
    }

    public float getMaxSize() {
        return this.mMaxSize;
    }

    private float yMin(BubbleEntry entry) {
        return entry.getVal();
    }

    private float yMax(BubbleEntry entry) {
        return entry.getVal();
    }

    private float xMin(BubbleEntry entry) {
        return entry.getXIndex();
    }

    private float xMax(BubbleEntry entry) {
        return entry.getXIndex();
    }

    private float largestSize(BubbleEntry entry) {
        return entry.getSize();
    }
}

