/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.data;

import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;

public class Entry
implements Parcelable {
    private float mVal = 0.0f;
    private int mXIndex = 0;
    private Object mData = null;
    public static final Parcelable.Creator<Entry> CREATOR = new Parcelable.Creator<Entry>(){

        public Entry createFromParcel(Parcel source) {
            return new Entry(source);
        }

        public Entry[] newArray(int size) {
            return new Entry[size];
        }
    };

    public Entry(float val, int xIndex) {
        this.mVal = val;
        this.mXIndex = xIndex;
    }

    public Entry(float val, int xIndex, Object data) {
        this(val, xIndex);
        this.mData = data;
    }

    public int getXIndex() {
        return this.mXIndex;
    }

    public void setXIndex(int x) {
        this.mXIndex = x;
    }

    public float getVal() {
        return this.mVal;
    }

    public void setVal(float val) {
        this.mVal = val;
    }

    public Object getData() {
        return this.mData;
    }

    public void setData(Object data) {
        this.mData = data;
    }

    public Entry copy() {
        Entry e = new Entry(this.mVal, this.mXIndex, this.mData);
        return e;
    }

    public boolean equalTo(Entry e) {
        if (e == null) {
            return false;
        }
        if (e.mData != this.mData) {
            return false;
        }
        if (e.mXIndex != this.mXIndex) {
            return false;
        }
        return !(Math.abs(e.mVal - this.mVal) > 1.0E-5f);
    }

    public String toString() {
        return "Entry, xIndex: " + this.mXIndex + " val (sum): " + this.getVal();
    }

    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.mVal);
        dest.writeInt(this.mXIndex);
        if (this.mData != null) {
            if (!(this.mData instanceof Parcelable)) throw new ParcelFormatException("Cannot parcel an Entry with non-parcelable data");
            dest.writeInt(1);
            dest.writeParcelable((Parcelable)this.mData, flags);
            return;
        } else {
            dest.writeInt(0);
        }
    }

    protected Entry(Parcel in) {
        this.mVal = in.readFloat();
        this.mXIndex = in.readInt();
        if (in.readInt() == 1) {
            this.mData = in.readParcelable(Object.class.getClassLoader());
        }
    }
}

