/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.data;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import java.util.ArrayList;
import java.util.List;
import org.github.mikephil.charting.data.DataSet;
import org.github.mikephil.charting.data.Entry;
import org.github.mikephil.charting.data.LineRadarDataSet;
import org.github.mikephil.charting.formatter.DefaultFillFormatter;
import org.github.mikephil.charting.formatter.FillFormatter;
import org.github.mikephil.charting.utils.ColorTemplate;
import org.github.mikephil.charting.utils.Utils;

public class LineDataSet
extends LineRadarDataSet<Entry> {
    private List<Integer> mCircleColors = null;
    private int mCircleColorHole = -1;
    private float mCircleSize = 8.0f;
    private float mCubicIntensity = 0.2f;
    private DashPathEffect mDashPathEffect = null;
    private FillFormatter mFillFormatter = new DefaultFillFormatter();
    private boolean mDrawCircles = true;
    private boolean mDrawCubic = false;
    private boolean mDrawCircleHole = true;

    public LineDataSet(List<Entry> yVals, String label) {
        super(yVals, label);
        this.mCircleColors = new ArrayList<Integer>();
        this.mCircleColors.add(Color.rgb((int)140, (int)234, (int)255));
    }

    @Override
    public DataSet<Entry> copy() {
        ArrayList<Entry> yVals = new ArrayList<Entry>();
        int i = 0;
        while (i < this.mYVals.size()) {
            yVals.add(((Entry)this.mYVals.get(i)).copy());
            ++i;
        }
        LineDataSet copied = new LineDataSet((List<Entry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mCircleSize = this.mCircleSize;
        copied.mCircleColors = this.mCircleColors;
        copied.mDashPathEffect = this.mDashPathEffect;
        copied.mDrawCircles = this.mDrawCircles;
        copied.mDrawCubic = this.mDrawCubic;
        copied.mHighLightColor = this.mHighLightColor;
        return copied;
    }

    public void setCubicIntensity(float intensity) {
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        if (intensity < 0.05f) {
            intensity = 0.05f;
        }
        this.mCubicIntensity = intensity;
    }

    public float getCubicIntensity() {
        return this.mCubicIntensity;
    }

    public void setCircleSize(float size) {
        this.mCircleSize = Utils.convertDpToPixel(size);
    }

    public float getCircleSize() {
        return this.mCircleSize;
    }

    public void enableDashedLine(float lineLength, float spaceLength, float phase) {
        this.mDashPathEffect = new DashPathEffect(new float[]{lineLength, spaceLength}, phase);
    }

    public void disableDashedLine() {
        this.mDashPathEffect = null;
    }

    public boolean isDashedLineEnabled() {
        return this.mDashPathEffect != null;
    }

    public DashPathEffect getDashPathEffect() {
        return this.mDashPathEffect;
    }

    public void setDrawCircles(boolean enabled) {
        this.mDrawCircles = enabled;
    }

    public boolean isDrawCirclesEnabled() {
        return this.mDrawCircles;
    }

    public void setDrawCubic(boolean enabled) {
        this.mDrawCubic = enabled;
    }

    public boolean isDrawCubicEnabled() {
        return this.mDrawCubic;
    }

    public List<Integer> getCircleColors() {
        return this.mCircleColors;
    }

    public int getCircleColor(int index) {
        return this.mCircleColors.get(index % this.mCircleColors.size());
    }

    public void setCircleColors(List<Integer> colors) {
        this.mCircleColors = colors;
    }

    public void setCircleColors(int[] colors) {
        this.mCircleColors = ColorTemplate.createColors(colors);
    }

    public void setCircleColors(int[] colors, Context c) {
        ArrayList<Integer> clrs = new ArrayList<Integer>();
        int[] nArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            int color = nArray[n2];
            clrs.add(c.getResources().getColor(color));
            ++n2;
        }
        this.mCircleColors = clrs;
    }

    public void setCircleColor(int color) {
        this.resetCircleColors();
        this.mCircleColors.add(color);
    }

    public void resetCircleColors() {
        this.mCircleColors = new ArrayList<Integer>();
    }

    public void setCircleColorHole(int color) {
        this.mCircleColorHole = color;
    }

    public int getCircleHoleColor() {
        return this.mCircleColorHole;
    }

    public void setDrawCircleHole(boolean enabled) {
        this.mDrawCircleHole = enabled;
    }

    public boolean isDrawCircleHoleEnabled() {
        return this.mDrawCircleHole;
    }

    public void setFillFormatter(FillFormatter formatter) {
        this.mFillFormatter = formatter == null ? new DefaultFillFormatter() : formatter;
    }

    public FillFormatter getFillFormatter() {
        return this.mFillFormatter;
    }
}

