/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.highlight;

import java.util.ArrayList;
import java.util.List;
import org.github.mikephil.charting.components.YAxis;
import org.github.mikephil.charting.data.DataSet;
import org.github.mikephil.charting.highlight.Highlight;
import org.github.mikephil.charting.interfaces.BarLineScatterCandleBubbleDataProvider;
import org.github.mikephil.charting.utils.SelectionDetail;
import org.github.mikephil.charting.utils.Utils;

public class ChartHighlighter<T extends BarLineScatterCandleBubbleDataProvider> {
    protected T mChart;

    public ChartHighlighter(T chart) {
        this.mChart = chart;
    }

    public Highlight getHighlight(float x, float y) {
        int xIndex = this.getXIndex(x);
        if (xIndex == -2147483647) {
            return null;
        }
        int dataSetIndex = this.getDataSetIndex(xIndex, x, y);
        if (dataSetIndex == -2147483647) {
            return null;
        }
        return new Highlight(xIndex, dataSetIndex);
    }

    protected int getXIndex(float x) {
        float[] pts = new float[2];
        pts[0] = x;
        this.mChart.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        return Math.round(pts[0]);
    }

    protected int getDataSetIndex(int xIndex, float x, float y) {
        float rightdist;
        List<SelectionDetail> valsAtIndex = this.getSelectionDetailsAtIndex(xIndex);
        float leftdist = Utils.getMinimumDistance(valsAtIndex, y, YAxis.AxisDependency.LEFT);
        YAxis.AxisDependency axis = leftdist < (rightdist = Utils.getMinimumDistance(valsAtIndex, y, YAxis.AxisDependency.RIGHT)) ? YAxis.AxisDependency.LEFT : YAxis.AxisDependency.RIGHT;
        int dataSetIndex = Utils.getClosestDataSetIndex(valsAtIndex, y, axis);
        return dataSetIndex;
    }

    protected List<SelectionDetail> getSelectionDetailsAtIndex(int xIndex) {
        ArrayList<SelectionDetail> vals = new ArrayList<SelectionDetail>();
        float[] pts = new float[2];
        int i = 0;
        while (i < this.mChart.getData().getDataSetCount()) {
            float yVal;
            Object dataSet = this.mChart.getData().getDataSetByIndex(i);
            if (((DataSet)dataSet).isHighlightEnabled() && (yVal = ((DataSet)dataSet).getYValForXIndex(xIndex)) != Float.NaN) {
                pts[1] = yVal;
                this.mChart.getTransformer(((DataSet)dataSet).getAxisDependency()).pointValuesToPixel(pts);
                if (!Float.isNaN(pts[1])) {
                    vals.add(new SelectionDetail(pts[1], i, (DataSet<?>)dataSet));
                }
            }
            ++i;
        }
        return vals;
    }
}

