/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.highlight;

import java.util.ArrayList;
import java.util.List;
import org.github.mikephil.charting.data.ChartData;
import org.github.mikephil.charting.data.CombinedData;
import org.github.mikephil.charting.data.DataSet;
import org.github.mikephil.charting.highlight.ChartHighlighter;
import org.github.mikephil.charting.interfaces.BarLineScatterCandleBubbleDataProvider;
import org.github.mikephil.charting.utils.SelectionDetail;

public class CombinedHighlighter
extends ChartHighlighter<BarLineScatterCandleBubbleDataProvider> {
    public CombinedHighlighter(BarLineScatterCandleBubbleDataProvider chart) {
        super(chart);
    }

    @Override
    protected List<SelectionDetail> getSelectionDetailsAtIndex(int xIndex) {
        CombinedData data = (CombinedData)this.mChart.getData();
        List<ChartData> dataObjects = data.getAllData();
        ArrayList<SelectionDetail> vals = new ArrayList<SelectionDetail>();
        float[] pts = new float[2];
        int i = 0;
        while (i < dataObjects.size()) {
            int j = 0;
            while (j < dataObjects.get(i).getDataSetCount()) {
                float yVal;
                Object dataSet = dataObjects.get(i).getDataSetByIndex(j);
                if (((DataSet)dataSet).isHighlightEnabled() && (yVal = ((DataSet)dataSet).getYValForXIndex(xIndex)) != Float.NaN) {
                    pts[1] = yVal;
                    this.mChart.getTransformer(((DataSet)dataSet).getAxisDependency()).pointValuesToPixel(pts);
                    if (!Float.isNaN(pts[1])) {
                        vals.add(new SelectionDetail(pts[1], j, (DataSet<?>)dataSet));
                    }
                }
                ++j;
            }
            ++i;
        }
        return vals;
    }
}

