/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import java.util.List;
import org.github.mikephil.charting.animation.ChartAnimator;
import org.github.mikephil.charting.data.BubbleData;
import org.github.mikephil.charting.data.BubbleDataSet;
import org.github.mikephil.charting.data.BubbleEntry;
import org.github.mikephil.charting.data.Entry;
import org.github.mikephil.charting.highlight.Highlight;
import org.github.mikephil.charting.interfaces.BubbleDataProvider;
import org.github.mikephil.charting.renderer.DataRenderer;
import org.github.mikephil.charting.utils.Transformer;
import org.github.mikephil.charting.utils.Utils;
import org.github.mikephil.charting.utils.ViewPortHandler;

public class BubbleChartRenderer
extends DataRenderer {
    protected BubbleDataProvider mChart;
    private float[] sizeBuffer = new float[4];
    private float[] pointBuffer = new float[2];
    private float[] _hsvBuffer = new float[3];

    public BubbleChartRenderer(BubbleDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(Utils.convertDpToPixel(1.5f));
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        for (BubbleDataSet set : bubbleData.getDataSets()) {
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set);
        }
    }

    protected float getShapeSize(float entrySize, float maxSize, float reference) {
        float factor = maxSize == 0.0f ? 1.0f : (float)Math.sqrt(entrySize / maxSize);
        float shapeSize = reference * factor;
        return shapeSize;
    }

    protected void drawDataSet(Canvas c, BubbleDataSet dataSet) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        List entries = dataSet.getYVals();
        Object entryFrom = dataSet.getEntryForXIndex(this.mMinX);
        Object entryTo = dataSet.getEntryForXIndex(this.mMaxX);
        int minx = Math.max(dataSet.getEntryPosition((Entry)entryFrom), 0);
        int maxx = Math.min(dataSet.getEntryPosition((Entry)entryTo) + 1, entries.size());
        this.sizeBuffer[0] = 0.0f;
        this.sizeBuffer[2] = 1.0f;
        trans.pointValuesToPixel(this.sizeBuffer);
        float maxBubbleWidth = Math.abs(this.sizeBuffer[2] - this.sizeBuffer[0]);
        float maxBubbleHeight = Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop());
        float referenceSize = Math.min(maxBubbleHeight, maxBubbleWidth);
        int j = minx;
        while (j < maxx) {
            BubbleEntry entry = (BubbleEntry)entries.get(j);
            this.pointBuffer[0] = (float)(entry.getXIndex() - minx) * phaseX + (float)minx;
            this.pointBuffer[1] = entry.getVal() * phaseY;
            trans.pointValuesToPixel(this.pointBuffer);
            float shapeHalf = this.getShapeSize(entry.getSize(), dataSet.getMaxSize(), referenceSize) / 2.0f;
            if (this.mViewPortHandler.isInBoundsTop(this.pointBuffer[1] + shapeHalf) && this.mViewPortHandler.isInBoundsBottom(this.pointBuffer[1] - shapeHalf) && this.mViewPortHandler.isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) {
                if (!this.mViewPortHandler.isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
                int color = dataSet.getColor(entry.getXIndex());
                this.mRenderPaint.setColor(color);
                c.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.mRenderPaint);
            }
            ++j;
        }
    }

    @Override
    public void drawValues(Canvas c) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        if (bubbleData == null) {
            return;
        }
        if (bubbleData.getYValCount() < (int)Math.ceil((float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX())) {
            List dataSets = bubbleData.getDataSets();
            float lineHeight = Utils.calcTextHeight(this.mValuePaint, "1");
            int i = 0;
            while (i < dataSets.size()) {
                BubbleDataSet dataSet = (BubbleDataSet)dataSets.get(i);
                if (dataSet.isDrawValuesEnabled() && dataSet.getEntryCount() != 0) {
                    this.applyValueTextStyle(dataSet);
                    float phaseX = this.mAnimator.getPhaseX();
                    float phaseY = this.mAnimator.getPhaseY();
                    float alpha = phaseX == 1.0f ? phaseY : phaseX;
                    int valueTextColor = dataSet.getValueTextColor();
                    valueTextColor = Color.argb((int)Math.round(255.0f * alpha), (int)Color.red((int)valueTextColor), (int)Color.green((int)valueTextColor), (int)Color.blue((int)valueTextColor));
                    this.mValuePaint.setColor(valueTextColor);
                    List entries = dataSet.getYVals();
                    Object entryFrom = dataSet.getEntryForXIndex(this.mMinX);
                    Object entryTo = dataSet.getEntryForXIndex(this.mMaxX);
                    int minx = dataSet.getEntryPosition((Entry)entryFrom);
                    int maxx = Math.min(dataSet.getEntryPosition((Entry)entryTo) + 1, dataSet.getEntryCount());
                    float[] positions = this.mChart.getTransformer(dataSet.getAxisDependency()).generateTransformedValuesBubble(entries, phaseX, phaseY, minx, maxx);
                    int j = 0;
                    while (j < positions.length) {
                        float x = positions[j];
                        float y = positions[j + 1];
                        if (!this.mViewPortHandler.isInBoundsRight(x)) break;
                        if (this.mViewPortHandler.isInBoundsLeft(x) && this.mViewPortHandler.isInBoundsY(y)) {
                            BubbleEntry entry = (BubbleEntry)entries.get(j / 2 + minx);
                            this.drawValue(c, dataSet.getValueFormatter(), entry.getSize(), entry, i, x, y + 0.5f * lineHeight);
                        }
                        j += 2;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        Highlight[] highlightArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            Highlight indice = highlightArray[n2];
            BubbleDataSet dataSet = (BubbleDataSet)bubbleData.getDataSetByIndex(indice.getDataSetIndex());
            if (dataSet != null && dataSet.isHighlightEnabled()) {
                Object entryFrom = dataSet.getEntryForXIndex(this.mMinX);
                Object entryTo = dataSet.getEntryForXIndex(this.mMaxX);
                int minx = dataSet.getEntryPosition((Entry)entryFrom);
                int maxx = Math.min(dataSet.getEntryPosition((Entry)entryTo) + 1, dataSet.getEntryCount());
                BubbleEntry entry = (BubbleEntry)bubbleData.getEntryForHighlight(indice);
                if (entry != null && entry.getXIndex() == indice.getXIndex()) {
                    Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                    this.sizeBuffer[0] = 0.0f;
                    this.sizeBuffer[2] = 1.0f;
                    trans.pointValuesToPixel(this.sizeBuffer);
                    float maxBubbleWidth = Math.abs(this.sizeBuffer[2] - this.sizeBuffer[0]);
                    float maxBubbleHeight = Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop());
                    float referenceSize = Math.min(maxBubbleHeight, maxBubbleWidth);
                    this.pointBuffer[0] = (float)(entry.getXIndex() - minx) * phaseX + (float)minx;
                    this.pointBuffer[1] = entry.getVal() * phaseY;
                    trans.pointValuesToPixel(this.pointBuffer);
                    float shapeHalf = this.getShapeSize(entry.getSize(), dataSet.getMaxSize(), referenceSize) / 2.0f;
                    if (this.mViewPortHandler.isInBoundsTop(this.pointBuffer[1] + shapeHalf) && this.mViewPortHandler.isInBoundsBottom(this.pointBuffer[1] - shapeHalf) && this.mViewPortHandler.isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) {
                        if (!this.mViewPortHandler.isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
                        if (indice.getXIndex() >= minx && indice.getXIndex() < maxx) {
                            int originalColor = dataSet.getColor(entry.getXIndex());
                            Color.RGBToHSV((int)Color.red((int)originalColor), (int)Color.green((int)originalColor), (int)Color.blue((int)originalColor), (float[])this._hsvBuffer);
                            this._hsvBuffer[2] = this._hsvBuffer[2] * 0.5f;
                            int color = Color.HSVToColor((int)Color.alpha((int)originalColor), (float[])this._hsvBuffer);
                            this.mHighlightPaint.setColor(color);
                            this.mHighlightPaint.setStrokeWidth(dataSet.getHighlightCircleWidth());
                            c.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.mHighlightPaint);
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

