/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.List;
import org.github.mikephil.charting.animation.ChartAnimator;
import org.github.mikephil.charting.buffer.CandleBodyBuffer;
import org.github.mikephil.charting.buffer.CandleShadowBuffer;
import org.github.mikephil.charting.data.CandleData;
import org.github.mikephil.charting.data.CandleDataSet;
import org.github.mikephil.charting.data.CandleEntry;
import org.github.mikephil.charting.highlight.Highlight;
import org.github.mikephil.charting.interfaces.CandleDataProvider;
import org.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import org.github.mikephil.charting.utils.Transformer;
import org.github.mikephil.charting.utils.Utils;
import org.github.mikephil.charting.utils.ViewPortHandler;

public class CandleStickChartRenderer
extends LineScatterCandleRadarRenderer {
    protected CandleDataProvider mChart;
    private CandleShadowBuffer[] mShadowBuffers;
    private CandleBodyBuffer[] mBodyBuffers;

    public CandleStickChartRenderer(CandleDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
    }

    @Override
    public void initBuffers() {
        CandleData candleData = this.mChart.getCandleData();
        this.mShadowBuffers = new CandleShadowBuffer[candleData.getDataSetCount()];
        this.mBodyBuffers = new CandleBodyBuffer[candleData.getDataSetCount()];
        int i = 0;
        while (i < this.mShadowBuffers.length) {
            CandleDataSet set = (CandleDataSet)candleData.getDataSetByIndex(i);
            this.mShadowBuffers[i] = new CandleShadowBuffer(set.getValueCount() * 4);
            this.mBodyBuffers[i] = new CandleBodyBuffer(set.getValueCount() * 4);
            ++i;
        }
    }

    @Override
    public void drawData(Canvas c) {
        CandleData candleData = this.mChart.getCandleData();
        for (CandleDataSet set : candleData.getDataSets()) {
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, CandleDataSet dataSet) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        int dataSetIndex = this.mChart.getCandleData().getIndexOfDataSet(dataSet);
        List<CandleEntry> entries = dataSet.getYVals();
        int minx = Math.max(this.mMinX, 0);
        int maxx = Math.min(this.mMaxX + 1, entries.size());
        int range = (maxx - minx) * 4;
        int to = (int)Math.ceil((float)(maxx - minx) * phaseX + (float)minx);
        CandleBodyBuffer bodyBuffer = this.mBodyBuffers[dataSetIndex];
        bodyBuffer.setBodySpace(dataSet.getBodySpace());
        bodyBuffer.setPhases(phaseX, phaseY);
        bodyBuffer.limitFrom(minx);
        bodyBuffer.limitTo(maxx);
        bodyBuffer.feed(entries);
        trans.pointValuesToPixel(bodyBuffer.buffer);
        CandleShadowBuffer shadowBuffer = this.mShadowBuffers[dataSetIndex];
        shadowBuffer.setPhases(phaseX, phaseY);
        shadowBuffer.limitFrom(minx);
        shadowBuffer.limitTo(maxx);
        shadowBuffer.feed(entries);
        trans.pointValuesToPixel(shadowBuffer.buffer);
        this.mRenderPaint.setStrokeWidth(dataSet.getShadowWidth());
        int j = 0;
        while (j < range) {
            CandleEntry e = entries.get(j / 4 + minx);
            if (this.fitsBounds(e.getXIndex(), this.mMinX, to)) {
                if (dataSet.getShadowColorSameAsCandle()) {
                    if (e.getOpen() > e.getClose()) {
                        this.mRenderPaint.setColor(dataSet.getDecreasingColor() == -1 ? dataSet.getColor(j) : dataSet.getDecreasingColor());
                    } else if (e.getOpen() < e.getClose()) {
                        this.mRenderPaint.setColor(dataSet.getIncreasingColor() == -1 ? dataSet.getColor(j) : dataSet.getIncreasingColor());
                    } else {
                        this.mRenderPaint.setColor(dataSet.getShadowColor() == -1 ? dataSet.getColor(j) : dataSet.getShadowColor());
                    }
                } else {
                    this.mRenderPaint.setColor(dataSet.getShadowColor() == -1 ? dataSet.getColor(j) : dataSet.getShadowColor());
                }
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
                c.drawLine(shadowBuffer.buffer[j], shadowBuffer.buffer[j + 1], shadowBuffer.buffer[j + 2], shadowBuffer.buffer[j + 3], this.mRenderPaint);
                float leftBody = bodyBuffer.buffer[j];
                float open = bodyBuffer.buffer[j + 1];
                float rightBody = bodyBuffer.buffer[j + 2];
                float close = bodyBuffer.buffer[j + 3];
                if (open > close) {
                    if (dataSet.getDecreasingColor() == -1) {
                        this.mRenderPaint.setColor(dataSet.getColor(j / 4 + minx));
                    } else {
                        this.mRenderPaint.setColor(dataSet.getDecreasingColor());
                    }
                    this.mRenderPaint.setStyle(dataSet.getDecreasingPaintStyle());
                    c.drawRect(leftBody, close, rightBody, open, this.mRenderPaint);
                } else if (open < close) {
                    if (dataSet.getIncreasingColor() == -1) {
                        this.mRenderPaint.setColor(dataSet.getColor(j / 4 + minx));
                    } else {
                        this.mRenderPaint.setColor(dataSet.getIncreasingColor());
                    }
                    this.mRenderPaint.setStyle(dataSet.getIncreasingPaintStyle());
                    c.drawRect(leftBody, open, rightBody, close, this.mRenderPaint);
                } else {
                    this.mRenderPaint.setColor(dataSet.getShadowColor());
                    c.drawLine(leftBody, open, rightBody, close, this.mRenderPaint);
                }
            }
            j += 4;
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if ((float)this.mChart.getCandleData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            List dataSets = this.mChart.getCandleData().getDataSets();
            int i = 0;
            while (i < dataSets.size()) {
                CandleDataSet dataSet = (CandleDataSet)dataSets.get(i);
                if (dataSet.isDrawValuesEnabled() && dataSet.getEntryCount() != 0) {
                    this.applyValueTextStyle(dataSet);
                    Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                    List<CandleEntry> entries = dataSet.getYVals();
                    int minx = Math.max(this.mMinX, 0);
                    int maxx = Math.min(this.mMaxX + 1, entries.size());
                    float[] positions = trans.generateTransformedValuesCandle(entries, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), minx, maxx);
                    float yOffset = Utils.convertDpToPixel(5.0f);
                    int j = 0;
                    while (j < positions.length) {
                        float x = positions[j];
                        float y = positions[j + 1];
                        if (!this.mViewPortHandler.isInBoundsRight(x)) break;
                        if (this.mViewPortHandler.isInBoundsLeft(x) && this.mViewPortHandler.isInBoundsY(y)) {
                            CandleEntry entry = entries.get(j / 2 + minx);
                            this.drawValue(c, dataSet.getValueFormatter(), entry.getHigh(), entry, i, x, y - yOffset);
                        }
                        j += 2;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        int i = 0;
        while (i < indices.length) {
            CandleEntry e;
            int xIndex = indices[i].getXIndex();
            CandleDataSet set = (CandleDataSet)this.mChart.getCandleData().getDataSetByIndex(indices[i].getDataSetIndex());
            if (set != null && set.isHighlightEnabled() && (e = (CandleEntry)set.getEntryForXIndex(xIndex)) != null && e.getXIndex() == xIndex) {
                float low = e.getLow() * this.mAnimator.getPhaseY();
                float high = e.getHigh() * this.mAnimator.getPhaseY();
                float y = (low + high) / 2.0f;
                float min = this.mChart.getYChartMin();
                float max = this.mChart.getYChartMax();
                float[] pts = new float[]{xIndex, y};
                this.mChart.getTransformer(set.getAxisDependency()).pointValuesToPixel(pts);
                this.drawHighlightLines(c, pts, set);
            }
            ++i;
        }
    }
}

