/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import java.util.ArrayList;
import java.util.List;
import org.github.mikephil.charting.animation.ChartAnimator;
import org.github.mikephil.charting.charts.CombinedChart;
import org.github.mikephil.charting.highlight.Highlight;
import org.github.mikephil.charting.interfaces.BarLineScatterCandleBubbleDataProvider;
import org.github.mikephil.charting.renderer.BarChartRenderer;
import org.github.mikephil.charting.renderer.BubbleChartRenderer;
import org.github.mikephil.charting.renderer.CandleStickChartRenderer;
import org.github.mikephil.charting.renderer.DataRenderer;
import org.github.mikephil.charting.renderer.LineChartRenderer;
import org.github.mikephil.charting.renderer.ScatterChartRenderer;
import org.github.mikephil.charting.utils.ViewPortHandler;

public class CombinedChartRenderer
extends DataRenderer {
    protected List<DataRenderer> mRenderers;

    public CombinedChartRenderer(CombinedChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.createRenderers(chart, animator, viewPortHandler);
    }

    protected void createRenderers(CombinedChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        CombinedChart.DrawOrder[] orders;
        this.mRenderers = new ArrayList<DataRenderer>();
        CombinedChart.DrawOrder[] drawOrderArray = orders = chart.getDrawOrder();
        int n = orders.length;
        int n2 = 0;
        while (n2 < n) {
            CombinedChart.DrawOrder order = drawOrderArray[n2];
            switch (order) {
                case BAR: {
                    if (chart.getBarData() == null) break;
                    this.mRenderers.add(new BarChartRenderer(chart, animator, viewPortHandler));
                    break;
                }
                case BUBBLE: {
                    if (chart.getBubbleData() == null) break;
                    this.mRenderers.add(new BubbleChartRenderer(chart, animator, viewPortHandler));
                    break;
                }
                case LINE: {
                    if (chart.getLineData() == null) break;
                    this.mRenderers.add(new LineChartRenderer(chart, animator, viewPortHandler));
                    break;
                }
                case CANDLE: {
                    if (chart.getCandleData() == null) break;
                    this.mRenderers.add(new CandleStickChartRenderer(chart, animator, viewPortHandler));
                    break;
                }
                case SCATTER: {
                    if (chart.getScatterData() == null) break;
                    this.mRenderers.add(new ScatterChartRenderer(chart, animator, viewPortHandler));
                }
            }
            ++n2;
        }
    }

    @Override
    public void initBuffers() {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.initBuffers();
        }
    }

    @Override
    public void drawData(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawData(c);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawValues(c);
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawExtras(c);
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawHighlighted(c, indices);
        }
    }

    @Override
    public void calcXBounds(BarLineScatterCandleBubbleDataProvider chart, int xAxisModulus) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.calcXBounds(chart, xAxisModulus);
        }
    }

    public DataRenderer getSubRenderer(int index) {
        if (index >= this.mRenderers.size() || index < 0) {
            return null;
        }
        return this.mRenderers.get(index);
    }

    public List<DataRenderer> getSubRenderers() {
        return this.mRenderers;
    }

    public void setSubRenderers(List<DataRenderer> renderers) {
        this.mRenderers = renderers;
    }
}

