/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.List;
import org.github.mikephil.charting.animation.ChartAnimator;
import org.github.mikephil.charting.buffer.BarBuffer;
import org.github.mikephil.charting.buffer.HorizontalBarBuffer;
import org.github.mikephil.charting.data.BarData;
import org.github.mikephil.charting.data.BarDataSet;
import org.github.mikephil.charting.data.BarEntry;
import org.github.mikephil.charting.formatter.ValueFormatter;
import org.github.mikephil.charting.interfaces.BarDataProvider;
import org.github.mikephil.charting.renderer.BarChartRenderer;
import org.github.mikephil.charting.utils.Transformer;
import org.github.mikephil.charting.utils.Utils;
import org.github.mikephil.charting.utils.ViewPortHandler;

public class HorizontalBarChartRenderer
extends BarChartRenderer {
    public HorizontalBarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(chart, animator, viewPortHandler);
        this.mValuePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new HorizontalBarBuffer[barData.getDataSetCount()];
        int i = 0;
        while (i < this.mBarBuffers.length) {
            BarDataSet set = (BarDataSet)barData.getDataSetByIndex(i);
            this.mBarBuffers[i] = new HorizontalBarBuffer(set.getValueCount() * 4 * set.getStackSize(), barData.getGroupSpace(), barData.getDataSetCount(), set.isStacked());
            ++i;
        }
    }

    @Override
    protected void drawDataSet(Canvas c, BarDataSet dataSet, int index) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.mShadowPaint.setColor(dataSet.getBarShadowColor());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        List<BarEntry> entries = dataSet.getYVals();
        BarBuffer buffer = this.mBarBuffers[index];
        buffer.setPhases(phaseX, phaseY);
        buffer.setBarSpace(dataSet.getBarSpace());
        buffer.setDataSet(index);
        buffer.setInverted(this.mChart.isInverted(dataSet.getAxisDependency()));
        buffer.feed(entries);
        trans.pointValuesToPixel(buffer.buffer);
        int j = 0;
        while (j < buffer.size()) {
            if (!this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 3])) break;
            if (this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) {
                if (this.mChart.isDrawBarShadowEnabled()) {
                    c.drawRect(this.mViewPortHandler.contentLeft(), buffer.buffer[j + 1], this.mViewPortHandler.contentRight(), buffer.buffer[j + 3], this.mShadowPaint);
                }
                this.mRenderPaint.setColor(dataSet.getColor(j / 4));
                c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
            }
            j += 4;
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.passesCheck()) {
            List dataSets = this.mChart.getBarData().getDataSets();
            float valueOffsetPlus = Utils.convertDpToPixel(5.0f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.mChart.isDrawValueAboveBarEnabled();
            int i = 0;
            while (i < this.mChart.getBarData().getDataSetCount()) {
                BarDataSet dataSet = (BarDataSet)dataSets.get(i);
                if (dataSet.isDrawValuesEnabled() && dataSet.getEntryCount() != 0) {
                    BarEntry e;
                    int j;
                    boolean isInverted = this.mChart.isInverted(dataSet.getAxisDependency());
                    this.applyValueTextStyle(dataSet);
                    float halfTextHeight = (float)Utils.calcTextHeight(this.mValuePaint, "10") / 2.0f;
                    ValueFormatter formatter = dataSet.getValueFormatter();
                    Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                    List<BarEntry> entries = dataSet.getYVals();
                    float[] valuePoints = this.getTransformedValues(trans, entries, i);
                    if (!dataSet.isStacked()) {
                        j = 0;
                        while ((float)j < (float)valuePoints.length * this.mAnimator.getPhaseX()) {
                            if (this.mViewPortHandler.isInBoundsTop(valuePoints[j + 1])) {
                                if (this.mViewPortHandler.isInBoundsX(valuePoints[j]) && this.mViewPortHandler.isInBoundsBottom(valuePoints[j + 1])) {
                                    e = entries.get(j / 2);
                                    float val = e.getVal();
                                    String formattedValue = formatter.getFormattedValue(val, e, i, this.mViewPortHandler);
                                    float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, formattedValue);
                                    posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                    float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                                    if (isInverted) {
                                        posOffset = -posOffset - valueTextWidth;
                                        negOffset = -negOffset - valueTextWidth;
                                    }
                                    this.drawValue(c, formattedValue, valuePoints[j] + (val >= 0.0f ? posOffset : negOffset), valuePoints[j + 1] + halfTextHeight);
                                }
                                j += 2;
                                continue;
                            }
                            break;
                        }
                    } else {
                        j = 0;
                        while ((float)j < (float)(valuePoints.length - 1) * this.mAnimator.getPhaseX()) {
                            e = entries.get(j / 2);
                            float[] vals = e.getVals();
                            if (vals == null) {
                                if (!this.mViewPortHandler.isInBoundsTop(valuePoints[j + 1])) break;
                                if (this.mViewPortHandler.isInBoundsX(valuePoints[j]) && this.mViewPortHandler.isInBoundsBottom(valuePoints[j + 1])) {
                                    float val = e.getVal();
                                    String formattedValue = formatter.getFormattedValue(val, e, i, this.mViewPortHandler);
                                    float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, formattedValue);
                                    posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                    float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                                    if (isInverted) {
                                        posOffset = -posOffset - valueTextWidth;
                                        negOffset = -negOffset - valueTextWidth;
                                    }
                                    this.drawValue(c, formattedValue, valuePoints[j] + (e.getVal() >= 0.0f ? posOffset : negOffset), valuePoints[j + 1] + halfTextHeight);
                                }
                            } else {
                                float[] transformed = new float[vals.length * 2];
                                float posY = 0.0f;
                                float negY = -e.getNegativeSum();
                                int k = 0;
                                int idx = 0;
                                while (k < transformed.length) {
                                    float y;
                                    float value = vals[idx];
                                    if (value >= 0.0f) {
                                        y = posY += value;
                                    } else {
                                        y = negY;
                                        negY -= value;
                                    }
                                    transformed[k] = y * this.mAnimator.getPhaseY();
                                    k += 2;
                                    ++idx;
                                }
                                trans.pointValuesToPixel(transformed);
                                k = 0;
                                while (k < transformed.length) {
                                    float val = vals[k / 2];
                                    String formattedValue = formatter.getFormattedValue(val, e, i, this.mViewPortHandler);
                                    float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, formattedValue);
                                    posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                    float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                                    if (isInverted) {
                                        posOffset = -posOffset - valueTextWidth;
                                        negOffset = -negOffset - valueTextWidth;
                                    }
                                    float x = transformed[k] + (val >= 0.0f ? posOffset : negOffset);
                                    float y = valuePoints[j + 1];
                                    if (!this.mViewPortHandler.isInBoundsTop(y)) break;
                                    if (this.mViewPortHandler.isInBoundsX(x) && this.mViewPortHandler.isInBoundsBottom(y)) {
                                        this.drawValue(c, formattedValue, x, y + halfTextHeight);
                                    }
                                    k += 2;
                                }
                            }
                            j += 2;
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void drawValue(Canvas c, String valueText, float x, float y) {
        c.drawText(valueText, x, y, this.mValuePaint);
    }

    @Override
    protected void prepareBarHighlight(float x, float y1, float y2, float barspaceHalf, Transformer trans) {
        float top = x - 0.5f + barspaceHalf;
        float bottom = x + 0.5f - barspaceHalf;
        float left = y1;
        float right = y2;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectValueToPixelHorizontal(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    public float[] getTransformedValues(Transformer trans, List<BarEntry> entries, int dataSetIndex) {
        return trans.generateTransformedValuesHorizontalBarChart(entries, dataSetIndex, this.mChart.getBarData(), this.mAnimator.getPhaseY());
    }

    @Override
    protected boolean passesCheck() {
        return (float)this.mChart.getBarData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleY();
    }
}

