/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PathEffect;
import org.github.mikephil.charting.animation.ChartAnimator;
import org.github.mikephil.charting.data.LineScatterCandleRadarDataSet;
import org.github.mikephil.charting.renderer.DataRenderer;
import org.github.mikephil.charting.utils.ViewPortHandler;

public abstract class LineScatterCandleRadarRenderer
extends DataRenderer {
    private Path mHighlightLinePath = new Path();

    public LineScatterCandleRadarRenderer(ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
    }

    protected void drawHighlightLines(Canvas c, float[] pts, LineScatterCandleRadarDataSet set) {
        this.mHighlightPaint.setColor(set.getHighLightColor());
        this.mHighlightPaint.setStrokeWidth(set.getHighlightLineWidth());
        this.mHighlightPaint.setPathEffect((PathEffect)set.getDashPathEffectHighlight());
        if (set.isVerticalHighlightIndicatorEnabled()) {
            this.mHighlightLinePath.reset();
            this.mHighlightLinePath.moveTo(pts[0], this.mViewPortHandler.contentTop());
            this.mHighlightLinePath.lineTo(pts[0], this.mViewPortHandler.contentBottom());
            c.drawPath(this.mHighlightLinePath, this.mHighlightPaint);
        }
        if (set.isHorizontalHighlightIndicatorEnabled()) {
            this.mHighlightLinePath.reset();
            this.mHighlightLinePath.moveTo(this.mViewPortHandler.contentLeft(), pts[1]);
            this.mHighlightLinePath.lineTo(this.mViewPortHandler.contentRight(), pts[1]);
            c.drawPath(this.mHighlightLinePath, this.mHighlightPaint);
        }
    }
}

