/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import java.util.List;
import org.github.mikephil.charting.animation.ChartAnimator;
import org.github.mikephil.charting.charts.RadarChart;
import org.github.mikephil.charting.data.Entry;
import org.github.mikephil.charting.data.RadarData;
import org.github.mikephil.charting.data.RadarDataSet;
import org.github.mikephil.charting.highlight.Highlight;
import org.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import org.github.mikephil.charting.utils.Utils;
import org.github.mikephil.charting.utils.ViewPortHandler;

public class RadarChartRenderer
extends LineScatterCandleRadarRenderer {
    protected RadarChart mChart;
    protected Paint mWebPaint;

    public RadarChartRenderer(RadarChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
        this.mWebPaint = new Paint(1);
        this.mWebPaint.setStyle(Paint.Style.STROKE);
    }

    public Paint getWebPaint() {
        return this.mWebPaint;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        RadarData radarData = (RadarData)this.mChart.getData();
        for (RadarDataSet set : radarData.getDataSets()) {
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, RadarDataSet dataSet) {
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        PointF center = this.mChart.getCenterOffsets();
        List entries = dataSet.getYVals();
        Path surface = new Path();
        boolean hasMovedToPoint = false;
        int j = 0;
        while (j < entries.size()) {
            this.mRenderPaint.setColor(dataSet.getColor(j));
            Entry e = (Entry)entries.get(j);
            PointF p = Utils.getPosition(center, (e.getVal() - this.mChart.getYChartMin()) * factor, sliceangle * (float)j + this.mChart.getRotationAngle());
            if (!Float.isNaN(p.x)) {
                if (!hasMovedToPoint) {
                    surface.moveTo(p.x, p.y);
                    hasMovedToPoint = true;
                } else {
                    surface.lineTo(p.x, p.y);
                }
            }
            ++j;
        }
        surface.close();
        if (dataSet.isDrawFilledEnabled()) {
            this.mRenderPaint.setStyle(Paint.Style.FILL);
            this.mRenderPaint.setAlpha(dataSet.getFillAlpha());
            c.drawPath(surface, this.mRenderPaint);
            this.mRenderPaint.setAlpha(255);
        }
        this.mRenderPaint.setStrokeWidth(dataSet.getLineWidth());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        if (!dataSet.isDrawFilledEnabled() || dataSet.getFillAlpha() < 255) {
            c.drawPath(surface, this.mRenderPaint);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        PointF center = this.mChart.getCenterOffsets();
        float yoffset = Utils.convertDpToPixel(5.0f);
        int i = 0;
        while (i < ((RadarData)this.mChart.getData()).getDataSetCount()) {
            RadarDataSet dataSet = (RadarDataSet)((RadarData)this.mChart.getData()).getDataSetByIndex(i);
            if (dataSet.isDrawValuesEnabled() && dataSet.getEntryCount() != 0) {
                this.applyValueTextStyle(dataSet);
                List entries = dataSet.getYVals();
                int j = 0;
                while (j < entries.size()) {
                    Entry entry = (Entry)entries.get(j);
                    PointF p = Utils.getPosition(center, (entry.getVal() - this.mChart.getYChartMin()) * factor, sliceangle * (float)j + this.mChart.getRotationAngle());
                    this.drawValue(c, dataSet.getValueFormatter(), entry.getVal(), entry, i, p.x, p.y - yoffset);
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawWeb(c);
    }

    protected void drawWeb(Canvas c) {
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        float rotationangle = this.mChart.getRotationAngle();
        PointF center = this.mChart.getCenterOffsets();
        this.mWebPaint.setStrokeWidth(this.mChart.getWebLineWidth());
        this.mWebPaint.setColor(this.mChart.getWebColor());
        this.mWebPaint.setAlpha(this.mChart.getWebAlpha());
        int xIncrements = 1 + this.mChart.getSkipWebLineCount();
        int i = 0;
        while (i < ((RadarData)this.mChart.getData()).getXValCount()) {
            PointF p = Utils.getPosition(center, this.mChart.getYRange() * factor, sliceangle * (float)i + rotationangle);
            c.drawLine(center.x, center.y, p.x, p.y, this.mWebPaint);
            i += xIncrements;
        }
        this.mWebPaint.setStrokeWidth(this.mChart.getWebLineWidthInner());
        this.mWebPaint.setColor(this.mChart.getWebColorInner());
        this.mWebPaint.setAlpha(this.mChart.getWebAlpha());
        int labelCount = this.mChart.getYAxis().mEntryCount;
        int j = 0;
        while (j < labelCount) {
            int i2 = 0;
            while (i2 < ((RadarData)this.mChart.getData()).getXValCount()) {
                float r = (this.mChart.getYAxis().mEntries[j] - this.mChart.getYChartMin()) * factor;
                PointF p1 = Utils.getPosition(center, r, sliceangle * (float)i2 + rotationangle);
                PointF p2 = Utils.getPosition(center, r, sliceangle * (float)(i2 + 1) + rotationangle);
                c.drawLine(p1.x, p1.y, p2.x, p2.y, this.mWebPaint);
                ++i2;
            }
            ++j;
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        PointF center = this.mChart.getCenterOffsets();
        int i = 0;
        while (i < indices.length) {
            int xIndex;
            Object e;
            RadarDataSet set = (RadarDataSet)((RadarData)this.mChart.getData()).getDataSetByIndex(indices[i].getDataSetIndex());
            if (set != null && set.isHighlightEnabled() && (e = set.getEntryForXIndex(xIndex = indices[i].getXIndex())) != null && ((Entry)e).getXIndex() == xIndex) {
                int j = set.getEntryPosition((Entry)e);
                float y = ((Entry)e).getVal() - this.mChart.getYChartMin();
                if (!Float.isNaN(y)) {
                    PointF p = Utils.getPosition(center, y * factor, sliceangle * (float)j + this.mChart.getRotationAngle());
                    float[] pts = new float[]{p.x, p.y};
                    this.drawHighlightLines(c, pts, set);
                }
            }
            ++i;
        }
    }
}

