/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.PointF;
import org.github.mikephil.charting.charts.RadarChart;
import org.github.mikephil.charting.components.XAxis;
import org.github.mikephil.charting.renderer.XAxisRenderer;
import org.github.mikephil.charting.utils.Utils;
import org.github.mikephil.charting.utils.ViewPortHandler;

public class XAxisRendererRadarChart
extends XAxisRenderer {
    private RadarChart mChart;

    public XAxisRendererRadarChart(ViewPortHandler viewPortHandler, XAxis xAxis, RadarChart chart) {
        super(viewPortHandler, xAxis, null);
        this.mChart = chart;
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mXAxis.isEnabled() || !this.mXAxis.isDrawLabelsEnabled()) {
            return;
        }
        float labelRotationAngleDegrees = this.mXAxis.getLabelRotationAngle();
        PointF drawLabelAnchor = new PointF(0.5f, 0.0f);
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mXAxis.getTextColor());
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        PointF center = this.mChart.getCenterOffsets();
        int mod = this.mXAxis.mAxisLabelModulus;
        int i = 0;
        while (i < this.mXAxis.getValues().size()) {
            String label = this.mXAxis.getValues().get(i);
            float angle = (sliceangle * (float)i + this.mChart.getRotationAngle()) % 360.0f;
            PointF p = Utils.getPosition(center, this.mChart.getYRange() * factor + (float)this.mXAxis.mLabelRotatedWidth / 2.0f, angle);
            this.drawLabel(c, label, i, p.x, p.y - (float)this.mXAxis.mLabelRotatedHeight / 2.0f, drawLabelAnchor, labelRotationAngleDegrees);
            i += mod;
        }
    }

    @Override
    public void renderLimitLines(Canvas c) {
    }
}

