/*
 * Decompiled with CFR 0.152.
 */
package org.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import java.util.List;
import org.github.mikephil.charting.components.LimitLine;
import org.github.mikephil.charting.components.YAxis;
import org.github.mikephil.charting.renderer.YAxisRenderer;
import org.github.mikephil.charting.utils.PointD;
import org.github.mikephil.charting.utils.Transformer;
import org.github.mikephil.charting.utils.Utils;
import org.github.mikephil.charting.utils.ViewPortHandler;

public class YAxisRendererHorizontalBarChart
extends YAxisRenderer {
    public YAxisRendererHorizontalBarChart(ViewPortHandler viewPortHandler, YAxis yAxis, Transformer trans) {
        super(viewPortHandler, yAxis, trans);
        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void computeAxis(float yMin, float yMax) {
        if (this.mViewPortHandler.contentHeight() > 10.0f && !this.mViewPortHandler.isFullyZoomedOutX()) {
            PointD p1 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop());
            PointD p2 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop());
            if (!this.mYAxis.isInverted()) {
                yMin = (float)p1.x;
                yMax = (float)p2.x;
            } else {
                yMin = (float)p2.x;
                yMax = (float)p1.x;
            }
        }
        this.computeAxisValues(yMin, yMax);
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawLabelsEnabled()) {
            return;
        }
        float[] positions = new float[this.mYAxis.mEntryCount * 2];
        int i = 0;
        while (i < positions.length) {
            positions[i] = this.mYAxis.mEntries[i / 2];
            i += 2;
        }
        this.mTrans.pointValuesToPixel(positions);
        this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
        this.mAxisLabelPaint.setTextAlign(Paint.Align.CENTER);
        float baseYOffset = Utils.convertDpToPixel(2.5f);
        float textHeight = Utils.calcTextHeight(this.mAxisLabelPaint, "Q");
        YAxis.AxisDependency dependency = this.mYAxis.getAxisDependency();
        YAxis.YAxisLabelPosition labelPosition = this.mYAxis.getLabelPosition();
        float yPos = 0.0f;
        yPos = dependency == YAxis.AxisDependency.LEFT ? (labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART ? this.mViewPortHandler.contentTop() - baseYOffset : this.mViewPortHandler.contentTop() - baseYOffset) : (labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART ? this.mViewPortHandler.contentBottom() + textHeight + baseYOffset : this.mViewPortHandler.contentBottom() + textHeight + baseYOffset);
        this.drawYLabels(c, yPos, positions, this.mYAxis.getYOffset());
    }

    @Override
    public void renderAxisLine(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawAxisLineEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mYAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mYAxis.getAxisLineWidth());
        if (this.mYAxis.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mAxisLinePaint);
        } else {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }

    @Override
    protected void drawYLabels(Canvas c, float fixedPosition, float[] positions, float offset) {
        this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
        int i = 0;
        while (i < this.mYAxis.mEntryCount) {
            String text = this.mYAxis.getFormattedLabel(i);
            if (!this.mYAxis.isDrawTopYLabelEntryEnabled() && i >= this.mYAxis.mEntryCount - 1) {
                return;
            }
            c.drawText(text, positions[i * 2], fixedPosition - offset, this.mAxisLabelPaint);
            ++i;
        }
    }

    @Override
    public void renderGridLines(Canvas c) {
        if (!this.mYAxis.isDrawGridLinesEnabled() || !this.mYAxis.isEnabled()) {
            return;
        }
        float[] position = new float[2];
        this.mGridPaint.setColor(this.mYAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mYAxis.getGridLineWidth());
        int i = 0;
        while (i < this.mYAxis.mEntryCount) {
            position[0] = this.mYAxis.mEntries[i];
            this.mTrans.pointValuesToPixel(position);
            c.drawLine(position[0], this.mViewPortHandler.contentTop(), position[0], this.mViewPortHandler.contentBottom(), this.mGridPaint);
            ++i;
        }
    }

    @Override
    public void renderLimitLines(Canvas c) {
        List<LimitLine> limitLines = this.mYAxis.getLimitLines();
        if (limitLines == null || limitLines.size() <= 0) {
            return;
        }
        float[] pts = new float[4];
        Path limitLinePath = new Path();
        int i = 0;
        while (i < limitLines.size()) {
            LimitLine l = limitLines.get(i);
            if (l.isEnabled()) {
                pts[0] = l.getLimit();
                pts[2] = l.getLimit();
                this.mTrans.pointValuesToPixel(pts);
                pts[1] = this.mViewPortHandler.contentTop();
                pts[3] = this.mViewPortHandler.contentBottom();
                limitLinePath.moveTo(pts[0], pts[1]);
                limitLinePath.lineTo(pts[2], pts[3]);
                this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
                this.mLimitLinePaint.setColor(l.getLineColor());
                this.mLimitLinePaint.setPathEffect((PathEffect)l.getDashPathEffect());
                this.mLimitLinePaint.setStrokeWidth(l.getLineWidth());
                c.drawPath(limitLinePath, this.mLimitLinePaint);
                limitLinePath.reset();
                String label = l.getLabel();
                if (label != null && !label.equals("")) {
                    float labelLineHeight;
                    this.mLimitLinePaint.setStyle(l.getTextStyle());
                    this.mLimitLinePaint.setPathEffect(null);
                    this.mLimitLinePaint.setColor(l.getTextColor());
                    this.mLimitLinePaint.setTypeface(l.getTypeface());
                    this.mLimitLinePaint.setStrokeWidth(0.5f);
                    this.mLimitLinePaint.setTextSize(l.getTextSize());
                    float xOffset = l.getLineWidth() + l.getXOffset();
                    float yOffset = Utils.convertDpToPixel(2.0f) + l.getYOffset();
                    LimitLine.LimitLabelPosition position = l.getLabelPosition();
                    if (position == LimitLine.LimitLabelPosition.RIGHT_TOP) {
                        labelLineHeight = Utils.calcTextHeight(this.mLimitLinePaint, label);
                        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                        c.drawText(label, pts[0] + xOffset, this.mViewPortHandler.contentTop() + yOffset + labelLineHeight, this.mLimitLinePaint);
                    } else if (position == LimitLine.LimitLabelPosition.RIGHT_BOTTOM) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                        c.drawText(label, pts[0] + xOffset, this.mViewPortHandler.contentBottom() - yOffset, this.mLimitLinePaint);
                    } else if (position == LimitLine.LimitLabelPosition.LEFT_TOP) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        labelLineHeight = Utils.calcTextHeight(this.mLimitLinePaint, label);
                        c.drawText(label, pts[0] - xOffset, this.mViewPortHandler.contentTop() + yOffset + labelLineHeight, this.mLimitLinePaint);
                    } else {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        c.drawText(label, pts[0] - xOffset, this.mViewPortHandler.contentBottom() - yOffset, this.mLimitLinePaint);
                    }
                }
            }
            ++i;
        }
    }
}

