//NetTalk
/*------------------------------------------------------------------------------*\
 =============================
   ģ: AVIOMgr.cpp
 =============================
 
 [Ȩ]
 
   2000-2002  115  Ȩ
                                              
\*------------------------------------------------------------------------------*/

#include "WndX.h"
#include <vfw.h>

#include "AVIOMgr.h"
#include "UDPSocket.h"
#include "g729a.h"
#include "AudioPlay.h"
#include <stdio.h>
/*------------------------------------------------------------------------------*/
CAVIOMgr* pMgrInst=0;


/*------------------------------------------------------------------------------*/
//̣߳ѹ
DWORD WINAPI CAVIOMgr::AudioInThreadProc(LPVOID lpParameter)
{
	CAVIOMgr* pMgr=(CAVIOMgr*)lpParameter;
	MSG msg;
	while(GetMessage(&msg,0,0,0))
	{
		switch(msg.message)
		{
		case WIM_DATA:
			{
				WAVEHDR* pWH=(WAVEHDR*)msg.lParam;
				waveInUnprepareHeader((HWAVEIN)msg.wParam,pWH,sizeof(WAVEHDR));
							
				if(pWH->dwBytesRecorded!=SIZE_AUDIO_FRAME)
					break;//it's not full recorded,i think the wave recorder has ben
				//stopped,discard it,and don't do anything!
				//
				CopyMemory(pMgr->m_AudioLocal,pWH->lpData,SIZE_AUDIO_FRAME);
				pMgr->OnEncodeAudioData(pMgr->m_AudioLocal,SIZE_AUDIO_FRAME);
				
				waveInPrepareHeader((HWAVEIN)msg.wParam,pWH,sizeof(WAVEHDR));
				waveInAddBuffer((HWAVEIN)msg.wParam,pWH,sizeof(WAVEHDR));
			}
			break;
		}
	}	
	return msg.wParam;
}

/*------------------------------------------------------------------------------*/
//Ƶ̣߳Ƶ
DWORD WINAPI CAVIOMgr::AudioOutThreadProc(LPVOID lpParameter)
{
	
	CAVIOMgr* pMgr=(CAVIOMgr*)lpParameter;
	MSG msg;
	while(GetMessage(&msg,0,0,0))
	{
		switch(msg.message)
		{
		case IOM_AUDIO:
			pMgr->OnDecodeAudioData((PACK_AUDIO*)msg.lParam,(int)msg.wParam);
			break;
		case WOM_DONE:
			{
				WAVEHDR* pwh=(WAVEHDR*)msg.lParam;
				waveOutUnprepareHeader((HWAVEOUT)msg.wParam,pwh,sizeof(WAVEHDR));
				pMgr->m_iAudioBuf--;
				delete []pwh->lpData;//ɾPlayʱڴ
				delete pwh;
			}
			break;
		}
	}
	return msg.wParam;
}

/*------------------------------------------------------------------------------*/
//Ƶص
LRESULT CALLBACK CAVIOMgr::VideoStreamCallbackProc(HWND hWnd, LPVIDEOHDR lpVHdr)
{
	
	CAVIOMgr* pMgr=(CAVIOMgr*)capGetUserData(hWnd);
	if(pMgr)
	{
		//ѹƵ
		pMgr->OnEncodeVideoData((char*)lpVHdr->lpData,lpVHdr->dwBytesUsed);
		
	}	
	return TRUE;
}

/*------------------------------------------------------------------------------*/
//Sockeṭ߳
DWORD WINAPI CAVIOMgr::SockThreadProc(LPVOID lpParameter)
{
	CAVIOMgr* pMgr=(CAVIOMgr*)lpParameter;

	char buf[4096];
	int iLen=0;
	while(1)
	{
		iLen=pMgr->m_Socket.RecvFrom(buf,4096,(sockaddr*)&pMgr->m_sockaddr);
		if(iLen>0)
		{
			
			switch(*((short*)buf))//check the flag
			{
			case FLAG_CMD:
				{
				//
					pMgr->OnCommand((PACK_CMD*)buf,iLen);
				}
				break;
			case FLAG_AUDIO:
				{
					//Ƶ
					if(pMgr->m_ds.bAudioOut&&
						pMgr->m_ds.bAudioCodec&&
						pMgr->m_hAudioOut&&
						((PACK_AUDIO*)buf)->session==pMgr->m_session)
					{
						char* p=new char[iLen];
						if(p)
						{
							CopyMemory(p,buf,iLen);
							if(!PostThreadMessage(pMgr->m_dwAudioOutId,IOM_AUDIO,iLen,(LPARAM)p))
								delete []p;
						}
					}
				}
				break;
			case FLAG_VIDEO:
				{
					//Ƶ
					if(pMgr->m_ds.bVideoOut&&
						pMgr->m_ds.bVideoCodec&&
						((PACK_VIDEO*)buf)->session==pMgr->m_session)
					{
						
						pMgr->OnDecodeVideoData((PACK_VIDEO*)buf,iLen);			
						
					}
				}
				
				break;
			}
		}
		else
		{
			if(!pMgr->m_Socket.IsSocket())
				break;
		}//the socket should be closed,that is m_Socket have been
		//destroyed,so break the loop and end the thread
	}
	return 0;
}

/*------------------------------------------------------------------------------*/

CAVIOMgr::CAVIOMgr()
{
	pMgrInst=this;	

	m_hSockThread=NULL;

	m_hAudioOut=0;
	m_hAudioIn=0;

	m_idCmd=0;

	m_bEnable=TRUE;
	m_bEnableBandAdjust=TRUE;
	
}

/*------------------------------------------------------------------------------*/
CAVIOMgr::~CAVIOMgr()
{
	Destroy();
	pMgrInst=0;
}

/*------------------------------------------------------------------------------*/
//ʼSOCKET,ָPORT
BOOL CAVIOMgr::InitSocket(UINT nPort)
{
	
	DestroySocket();	
	
	BOOL bRet=FALSE;	
	if(!m_Socket.Create(nPort))
		goto RET;
	//socket߳(socketΪblockʽ)
	m_hSockThread=CreateThread(0,0,SockThreadProc,(LPVOID)this,0,&m_dwSockThreadId);
	if(!m_hSockThread)	
		goto RET;
	
	
	bRet=TRUE;
RET:
	if(!bRet)
		DestroySocket();
		
	return bRet;
}

/*------------------------------------------------------------------------------*/

BOOL CAVIOMgr::DestroySocket()
{
	m_Socket.Destroy();
	//
	
	if(m_hSockThread)
	{
		BOOL b=FALSE;
		DWORD ExitCode;
		int Timeout = 50; 
		while(Timeout)//ȴ߳̽һʱ仹ûǿƽ
		{			 //ΪSocketѾdestroyˣsocket̻߳᷵
			GetExitCodeThread(m_hSockThread, &ExitCode);
			
			if (ExitCode != STILL_ACTIVE)
			{
				b=TRUE;
				// Thread has ended.
				break;
			}
			else
			{
				Sleep(10);
			}
			
			--Timeout;
		}
		if(!b)//time out ,terminate it
			TerminateThread(m_hSockThread,0);
				
	}
	m_hSockThread=NULL;
	return TRUE;
}

/*------------------------------------------------------------------------------*/
//趨Ŀ
void CAVIOMgr::SetDst(char *ip, unsigned short port)
{
	m_dst.sin_family=AF_INET;
	//IPתΪַ
	m_dst.sin_addr.s_addr=CUDPSocket::Name2Inet(ip);
	m_dst.sin_port=htons(port);
	
}

/*------------------------------------------------------------------------------*/
//ʼƵ룬ʼɣ¼Ϳʼ
BOOL CAVIOMgr::InitAudioRec()
{
	DestroyAudioRec();
	BOOL bRet=FALSE;
	//¼߳
	m_hAudioIn=CreateThread(0,0,AudioInThreadProc,this,0,&m_dwAudioInId);
	if(!m_hAudioIn)
		goto RET;
	if(!m_AudioRec.Create(0,m_dwAudioInId,(DWORD)this,CALLBACK_THREAD,SIZE_AUDIO_FRAME))
		goto RET;
	//ʼ¼
	if(!m_AudioRec.Start())
		goto RET;
	
	bRet=TRUE;
RET:
	if(!bRet)
	{
		//ʧܣڷͳϢ
		PostMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_ERR,IOME_AUDIO_IN),(LPARAM)this);
		DestroyAudioRec();
	}
	
	return bRet;

}

/*------------------------------------------------------------------------------*/
//waveIn¼ʱǳXP»ǻ⣬Ҳ֪ôడ
BOOL CAVIOMgr::DestroyAudioRec()
{
	
	m_AudioRec.Stop();
    m_AudioRec.Destroy();
	if(m_hAudioIn)
	{
		int t=50;
		DWORD ExitCode;
		BOOL bEnd=FALSE;
		//¼̷߳˳Ϣȴ߳̽
		PostThreadMessage(m_dwAudioInId,WM_QUIT,0,0);
		while(t)
		{
			
			GetExitCodeThread(m_hAudioIn,&ExitCode);
			if(ExitCode!= STILL_ACTIVE)
			{
				bEnd=TRUE;
				break;
			}
			else
				Sleep(10);
			t--;
		}
		if(!bEnd)
			TerminateThread(m_hAudioIn,0);
		m_hAudioIn=0;
		
	}	
		
	return TRUE;

}

/*------------------------------------------------------------------------------*/
//ʼ豸
BOOL CAVIOMgr::InitAudioPlay()
{
	BOOL bRet=FALSE;
	DestroyAudioPlay();
	m_iAudioBuf=0;
	m_hAudioOut=CreateThread(0,0,AudioOutThreadProc,this,0,&m_dwAudioOutId);
	if(!m_hAudioOut)
		goto RET;
	if(!m_AudioPlay.Create(0,m_dwAudioOutId,(DWORD)this,CALLBACK_THREAD))
		goto RET;
	bRet=TRUE;
	
	
RET:
	if(!bRet)
	{
		//ڷͳϢ
		PostMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_ERR,IOME_AUDIO_OUT),(LPARAM)this);
		DestroyAudioPlay();
	}
	
	return bRet;
}

/*------------------------------------------------------------------------------*/
//
BOOL CAVIOMgr::DestroyAudioPlay()
{

	m_AudioPlay.Destroy();
	if(m_hAudioOut)
	{
		int t=50;
		DWORD ExitCode;
		BOOL bEnd=FALSE;
		PostThreadMessage(m_dwAudioOutId,WM_QUIT,0,0);
		while(t)
		{
			
			GetExitCodeThread(m_hAudioOut,&ExitCode);
			if(ExitCode!= STILL_ACTIVE)
			{
				bEnd=TRUE;
				break;
			}
			else
				Sleep(10);
			t--;
		}
		if(!bEnd)
			TerminateThread(m_hAudioOut,0);
		m_hAudioOut=0;
		
	}
	return TRUE;
}

/*------------------------------------------------------------------------------*/
//Ƶ룬Ƶݷ͵ҪݵĴ
void CAVIOMgr::OnDecodeAudioData(PACK_AUDIO *ppa, int len)
{
	
	if(m_CodecMgr.DecodeAudioData((char*)ppa->data,SIZE_AUDIO_PACKED,m_AudioRemote,0))
	{	
		//Ϊ˱ӳٹۻĻ峬ʱĻ
		if(m_iAudioBuf<6)
		{
			m_iAudioBuf++;
			m_AudioPlay.Play(m_AudioRemote,SIZE_AUDIO_FRAME);
		}
		if(m_hwndRemoteAudioRcv)
			SendMessage(m_hwndRemoteAudioRcv,IOM_AUDIO,1,(LPARAM)this);
	}
	
	m_uDataRcv+=sizeof(PACK_AUDIO);
	delete []ppa;

}

/*------------------------------------------------------------------------------*/
//ѹƵԭʼݲͳȥ
void CAVIOMgr::OnEncodeAudioData(char *pa, int len)
{
	
	m_AudioPack.flag=FLAG_AUDIO;
	m_AudioPack.session=m_session;
	
	if(m_CodecMgr.EncodeAudioData(pa,len,(char*)m_AudioPack.data,0))
	{			
		m_Socket.SendTo((char*)&m_AudioPack,sizeof(PACK_AUDIO),(sockaddr*)&m_dst);
		m_uDataSend+=sizeof(PACK_AUDIO);
	}
	
	if(m_hwndLocalAudioRcv)
		SendMessage(m_hwndLocalAudioRcv,IOM_AUDIO,0,(LPARAM)this);
		
}

/*------------------------------------------------------------------------------*/
//Ƶ
void CAVIOMgr::OnDecodeVideoData(PACK_VIDEO *ppv, int len)
{	
	
	if(m_CodecMgr.DecodeVideoData(((char*)ppv)+sizeof(PACK_VIDEO),ppv->data_size,m_VideoRemote,0,0))
	{
		m_nFrameCount++;
		
		m_nCurVid=ppv->id;
		//Ƶݷ͵Ƶʾ
		if(m_hwndRemoteVideoRcv)
			SendMessage(m_hwndRemoteVideoRcv,IOM_VIDEO,1,(LPARAM)this);
		
	}
	//ͳյ
	m_uDataRcv+=sizeof(PACK_VIDEO)+ppv->data_size;
}

/*------------------------------------------------------------------------------*/
//Ƶѹ
void CAVIOMgr::OnEncodeVideoData(char *pv, int len)
{
	
	int rlen;
	
	if(m_bVideoSend)
	{			
		if(m_CodecMgr.EncodeVideoData(pv,len,m_VideoPack+sizeof(PACK_VIDEO),&rlen,0))
		{
			
			((PACK_VIDEO*)m_VideoPack)->data_size=(unsigned short)rlen;
			((PACK_VIDEO*)m_VideoPack)->id=m_idVideo++;
			((PACK_VIDEO*)m_VideoPack)->session=m_session;
			m_Socket.SendTo(m_VideoPack,rlen+sizeof(PACK_VIDEO),(sockaddr*)&m_dst);
			//ͳƷ͵
			m_uDataSend+=rlen+sizeof(PACK_VIDEO);
		}
	}
	m_VideoLocal=pv;
	if(m_hwndLocalVideoRcv)
	{
		//Ƶݷ͵Ƶʾ
		SendMessage(m_hwndLocalVideoRcv,IOM_VIDEO,0,(LPARAM)this);
	}

	
}

/*------------------------------------------------------------------------------*/
//ʼSOCKET
BOOL CAVIOMgr::Init(UINT nPort)
{
	Destroy();
		
	m_hwndLocalVideoRcv=0;
	m_hwndLocalAudioRcv=0;
	m_hwndRemoteVideoRcv=0;
	m_hwndRemoteAudioRcv=0;
	m_hwndMainWnd=0;
	m_bVideoSend=TRUE;
	
	m_iStatus=STA_FREE;
	BOOL bRet=FALSE;
	m_uDataRcv=0;
	m_uDataSend=0;
	if(!InitSocket(nPort))
		goto RET;
	//ϢմڣҪڳʱطƣΪҪ趨ܶ಻ͬIDĶʱ
	m_MsgRcvWnd.Create(0,0,0,0,CRectX(0,0,0,0),0,0);
	bRet=TRUE;
RET:
	return bRet;
}

/*------------------------------------------------------------------------------*/
//ʼƵ׽豸
BOOL CAVIOMgr::InitCap()//
{
	HWND hCap;
	
	m_ViCap.Destroy();
	BOOL bRet=FALSE;
	if(!m_ViCap.Init())
		goto RET;
	//õ
	if(!m_ViCap.GetDriverNum())
		goto RET;
	//ӵ
	if(!m_ViCap.ConnectToDriver(0))
		goto RET;
	hCap=m_ViCap.GetCapWindow();
	//Ƶʽ
	if(!capSetVideoFormat(hCap,&m_CodecMgr.m_BmpU,sizeof(BITMAPINFO)))
		goto RET;
	//Ƶص
	if(!capSetCallbackOnVideoStream(hCap,VideoStreamCallbackProc))
		goto RET;
	//userΪAVIOMgrָ
	if(!capSetUserData(hCap,(DWORD)this))
		goto RET;
	//ʼƵ
	if(!capCaptureSequenceNoFile(hCap))
		goto RET;
	
	bRet=TRUE;
RET:
	if(!bRet)
	{
		PostMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_ERR,IOME_VIDEO_IN),(LPARAM)this);
		m_ViCap.Destroy();
	}
	return bRet;
}

/*------------------------------------------------------------------------------*/
BOOL CAVIOMgr::DestroyCap()
{
	
	m_ViCap.Destroy();
	return TRUE;
}

/*------------------------------------------------------------------------------*/
void CAVIOMgr::Destroy()
{
	EndTalk();
	DestroySocket();
	DestroyAudioRec();
	DestroyCap();
	DestroyAudioPlay();
	DestroyAudioCodec();
	DestroyVideoCodec();
}

/*------------------------------------------------------------------------------*/
//
BOOL CAVIOMgr::InitAudioCodec()
{
	
	BOOL bRet=FALSE;
	
	if(!m_CodecMgr.InitCodecA())
		goto RET;
	//ʶʱ	
	SetTimer(m_hwndMainWnd,100,1000,DropRateCounter);
	bRet=TRUE;
RET:
	if(!bRet)
	{
		PostMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_ERR,IOME_AUDIO_CODEC),(LPARAM)this);
		DestroyAudioCodec();
	}
	return bRet;
}

/*------------------------------------------------------------------------------*/
//
void CAVIOMgr::DestroyAudioCodec()
{	
	//رնʶʱ
	KillTimer(m_hwndMainWnd,100);
	m_CodecMgr.DestroyCodecA();
}

/*------------------------------------------------------------------------------*/
//ʼƵ
BOOL CAVIOMgr::InitVideoCodec()
{
	m_idVideo=0;
	m_nFps=0;
	m_nFrameCount=0;
	m_nLastFrameCount=0;
	m_nDropRate=0;
	m_nCurVid=0;
	m_nLastVid=0;
	BOOL bRet=FALSE;
	//
	if(!m_CodecMgr.InitCodecV())
		goto RET;
	
	((PACK_VIDEO*)m_VideoPack)->flag=FLAG_VIDEO;

		
	bRet=TRUE;
RET:
	if(!bRet)
	{
		PostMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_ERR,IOME_VIDEO_CODEC),(LPARAM)this);
		DestroyVideoCodec();
	}
	return bRet;
}

/*------------------------------------------------------------------------------*/
void CAVIOMgr::DestroyVideoCodec()
{
	
	
		
	m_CodecMgr.DestroyCodecV();
}


/*------------------------------------------------------------------------------*/
void CAVIOMgr::GetDeviceSupport(DEVICE_SUPPORT &ds)
{

}

/*------------------------------------------------------------------------------*/
//ĳIP
BOOL CAVIOMgr::Call(char *ip, unsigned short port)
{
	BOOL bRet=FALSE;
	if(m_iStatus!=STA_FREE)
		goto RET;
	SetDst(ip,port);
	PACK_CMD pc;
	m_session=rand()&0xff;
	pc.flag=FLAG_CMD;
	pc.cmd=CMD_CALL;
	pc.type=0;
	pc.data_size_extra=0;
	pc.ext=VER_AVIO&0xff;//AVIO İ汾
	if(!SendCmd(&pc,sizeof(pc),m_dst,TRUE))
		goto RET;
	
	m_iStatus=STA_BUSY;
	bRet=TRUE;
	m_uDataSend=0;
	m_uDataRcv=0;
	
RET:
	return bRet;
}

/*------------------------------------------------------------------------------*/
//ͨ
BOOL CAVIOMgr::EndTalk()
{
	BOOL bRet=FALSE;
	if(m_iStatus==STA_FREE)
		goto RET;
	if(m_iStatus==STA_BUSY)
	{
		m_iStatus=STA_FREE;
	
		PACK_CMD pc;
		pc.flag=FLAG_CMD;
		
		pc.cmd=CMD_END;
		pc.data_size_extra=0;
		pc.type=0;
		SendCmd(&pc,sizeof(pc),m_dst,FALSE);
		ZeroMemory(&m_dst,sizeof(m_dst));
		DestroyVideoCodec();
		DestroyAudioCodec();
		DestroyAudioPlay();
		DestroyAudioRec();
		DestroyCap();
		
		
	}
	
	bRet=TRUE;
RET:
	return bRet;
}

/*------------------------------------------------------------------------------*/
//
BOOL CAVIOMgr::Accept()
{
	BOOL bRet=FALSE;
	if(m_iStatus!=STA_BUSY)
		goto RET;
	PACK_CMD pc;
	pc.flag=FLAG_CMD;
	pc.cmd=CMD_ACCEPT;
	
	pc.data_size_extra=0;
	pc.type=0;
	SendCmd(&pc,sizeof(pc),m_dst,TRUE);
		
	ZeroMemory(&m_ds,sizeof(m_ds));
	m_ds.bVideoOut=true;//always ok
	if(InitVideoCodec())//why this must ahead InitAudioCodec??i don't know why
		m_ds.bVideoCodec=true;
	if(InitAudioCodec())
		m_ds.bAudioCodec=true;
	if(InitAudioPlay())
		m_ds.bAudioOut=true;
	if(InitAudioRec())
		m_ds.bAudioIn=true;
	
	if(m_ds.bVideoCodec&&InitCap())
		m_ds.bVideoIn=true;
	
	if(!m_ds.bAudioCodec&&!m_ds.bVideoCodec)
	{
		DestroyCap();
		DestroyAudioRec();
		DestroyAudioPlay();
		DestroyAudioCodec();
		DestroyVideoCodec();
		
		m_iStatus=STA_FREE;
	}
	bRet=TRUE;
RET:
	return bRet;

}

/*------------------------------------------------------------------------------*/
//ܾ
BOOL CAVIOMgr::Refuse()
{
	BOOL bRet=FALSE;
	if(m_iStatus!=STA_BUSY)
		goto RET;
	PACK_CMD pc;
	pc.flag=FLAG_CMD;
	pc.cmd=CMD_REFUSE;
	
	pc.ext=R_USER;
	pc.data_size_extra=0;
	pc.type=0;
	m_iStatus=STA_FREE;

	SendCmd(&pc,sizeof(pc),m_dst,TRUE);	
	
	bRet=TRUE;
RET:
	return bRet;
}

/*------------------------------------------------------------------------------*/
//ͷ
void CAVIOMgr::OnCommand(PACK_CMD *ppc, int len)
{
	switch(ppc->cmd)
	{
	case CMD_CALL:
		{
			if(ppc->type==0)
			{
				if(m_bEnable)
				{
					//ǿеģͱַ״̬Ϊ״̬
					//ڷͺ֪ͨ
					if(m_iStatus==STA_FREE)
					{
						m_dst=m_sockaddr;
						m_iStatus=STA_BUSY;
						m_session=ppc->session;
						PostMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_CALL,VER_AVIO),(LPARAM)this);
						//ȷ
						PACK_CMD pc;
						pc.flag=FLAG_CMD;
						pc.data_size_extra=0;
						
						pc.cmd=CMD_CALL;
						pc.ext=VER_AVIO&0xff;// AVIOİ汾
						pc.type=1;
						pc.id=ppc->id;
						pc.session=m_session;
						m_Socket.SendTo((char*)&pc,sizeof(pc),(sockaddr*)&m_sockaddr);
						
						
					}
					else
					if(m_iStatus==STA_BUSY&&m_session!=ppc->session)
					{					
						/*//һ̨ܾͨ
						
						PACK_CMD pc;
						pc.flag=FLAG_CMD;
						pc.cmd=CMD_REFUSE;
						pc.data_size_extra=0;
						pc.ext=R_BUSY;
						pc.type=0;
						pc.id=ppc->id;
						pc.session=ppc->session;
						m_Socket.SendTo((char*)&pc,sizeof(pc),(sockaddr*)&m_sockaddr);*/
					}
				}
			}
			//Ӧ
			else
			{
				if(ppc->session==m_session)
				{
					KillTimer(m_MsgRcvWnd,ppc->id);
					m_CmdQueue.Remove(ppc->id);
					PostMessage(m_hwndMainWnd,IOM_NOTIFY,IOMN_CONNECTED,(LPARAM)this);
				}
			}
		}break;
	case CMD_END:
		{
			if(ppc->session==m_session)
			{
				if(ppc->type==0)
				{
					
					if(m_iStatus==STA_BUSY)
					{
						PostMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_END,E_USER),(LPARAM)this);
					}
					PACK_CMD pc;
					pc.flag=FLAG_CMD;
					pc.data_size_extra=0;
					pc.cmd=CMD_END;
					pc.type=1;
					pc.id=ppc->id;
					pc.session=m_session;
					m_Socket.SendTo((char*)&pc,sizeof(pc),(sockaddr*)&m_sockaddr);
					
				}
				else
				{
					KillTimer(m_MsgRcvWnd,ppc->id);
					m_CmdQueue.Remove(ppc->id);
				}
			}
			
		}
		break;
	case CMD_REFUSE:
		{
			if(ppc->session==m_session)
			{
				
				if(ppc->type==0)
				{
					
					if(m_iStatus==STA_BUSY)
					{
						m_iStatus=STA_FREE;
						PostMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_REFUSE,ppc->ext),(LPARAM)this);
					}
					PACK_CMD pc;
					pc.flag=FLAG_CMD;
					pc.data_size_extra=0;
					pc.cmd=CMD_REFUSE;
					pc.type=1;
					pc.id=ppc->id;
					pc.session=m_session;				
					m_Socket.SendTo((char*)&pc,sizeof(pc),(sockaddr*)&m_sockaddr);
					
					
				}
				else
				{
					KillTimer(m_MsgRcvWnd,ppc->id);
					m_CmdQueue.Remove(ppc->id);
				}
			}
		}
		break;
	case CMD_ACCEPT:
		{
			if(ppc->session==m_session)
			{
				if(ppc->type==0)
				{
					
					if(m_iStatus==STA_BUSY)
					{
						PostMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_ACCEPT,VER_AVIO),(LPARAM)this);
					}
					PACK_CMD pc;
					pc.flag=FLAG_CMD;
					pc.data_size_extra=0;
					pc.cmd=CMD_ACCEPT;
					pc.type=1;
					pc.id=ppc->id;
					pc.session=m_session;
					m_Socket.SendTo((char*)&pc,sizeof(pc),(sockaddr*)&m_sockaddr);
					
				}
				else
				{
					KillTimer(m_MsgRcvWnd,ppc->id);
					m_CmdQueue.Remove(ppc->id);
				}
			}
			
		}
		break;
	case CMD_TXT:
		{
			if(ppc->type==0)
			{
				//bug exist
				SendMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_TXT,0),(LPARAM)(((char*)ppc)+sizeof(PACK_CMD)));
				PACK_CMD pc;
				pc.flag=FLAG_CMD;
				pc.data_size_extra=0;
				pc.cmd=CMD_TXT;
				pc.type=1;
				pc.id=ppc->id;
				m_Socket.SendTo((char*)&pc,sizeof(pc),(sockaddr*)&m_sockaddr);
			}
			else
			{
				
				KillTimer(m_MsgRcvWnd,ppc->id);
				UINT len;char resend;sockaddr_in addr;
				char* p=m_CmdQueue.GetBuf(ppc->id,len,resend,addr);
				if(p)
				{
					SendMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_TXT,1),(LPARAM)(p+sizeof(PACK_CMD)));
				}
				m_CmdQueue.Remove(ppc->id);
			}
		}
		break;

	case CMD_DROPRATE:
		{
			//ݶƵ
			if(ppc->type==0&&ppc->session&&m_bEnableBandAdjust)
			{
				SetVideoQuality(100-ppc->ext);
				SendMessage(m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_VQSET,100-ppc->ext),(LPARAM)this);
			}
		}break;
		
	}

}

/*------------------------------------------------------------------------------*/
//öϢӿ
//
void CAVIOMgr::SetMainWnd(HWND hwnd)
{
	m_hwndMainWnd=hwnd;
}

void CAVIOMgr::SetLocalVideoRcvWnd(HWND hwnd)
{
	m_hwndLocalVideoRcv=hwnd;
}

void CAVIOMgr::SetLocalAudioRcvWnd(HWND hwnd)
{
	m_hwndLocalAudioRcv=hwnd;
}

void CAVIOMgr::SetRemoteVideoRcvWnd(HWND hwnd)
{
	m_hwndRemoteVideoRcv=hwnd;
}

void CAVIOMgr::SetRemoteAudioRcvWnd(HWND hwnd)
{
	m_hwndRemoteAudioRcv=hwnd;
}

/*------------------------------------------------------------------------------*/
//õǰ״̬
int CAVIOMgr::GetStatus()
{
	return m_iStatus;
}

/*------------------------------------------------------------------------------*/
//ºҪ
//ֻյӦϢʱܵ
/////////////////////////
///
char* CAVIOMgr::GetLocalVideo(UINT &len)
{
	len=m_CodecMgr.m_BmpU.bmiHeader.biSizeImage;
	return m_VideoLocal;
}

char* CAVIOMgr::GetLocalAudio(UINT &len)
{
	len=SIZE_AUDIO_FRAME;
	return m_AudioLocal;
}

char* CAVIOMgr::GetRemoteVideo(UINT &len)
{
	len=m_CodecMgr.m_BmpU.bmiHeader.biSizeImage;
	return m_VideoRemote;
}

char* CAVIOMgr::GetRemoteAudio(UINT &len)
{
	len=SIZE_AUDIO_FRAME;
	return m_AudioRemote;
}

/*------------------------------------------------------------------------------*/
//õԭʼƵʽ
BITMAPINFO* CAVIOMgr::GetBitampInfo()
{
	return &m_CodecMgr.m_BmpU;
}

/*------------------------------------------------------------------------------*/
//õݷ
UINT CAVIOMgr::GetDataSend()
{
	return m_uDataSend;
}
/*------------------------------------------------------------------------------*/
//õݽ
UINT CAVIOMgr::GetDataRcv()
{
	return m_uDataRcv;
}
/*------------------------------------------------------------------------------*/
//ǷƵ
void CAVIOMgr::VideoSend(BOOL b)
{
	m_bVideoSend=b;
	
}
/*------------------------------------------------------------------------------*/
//õԷַ
sockaddr_in CAVIOMgr::GetRemoteAddr()
{
	return m_dst;
}
/*------------------------------------------------------------------------------*/
//Ƶ
void CAVIOMgr::SetVideoQuality(UINT q)
{
	m_CodecMgr.m_cv.lQ=q*100;
}
/*------------------------------------------------------------------------------*/
//Ԥ
BOOL CAVIOMgr::EnablePreview(BOOL b)
{
	if(m_iStatus==STA_FREE&&b)
	{
		return InitCap();			
	}
	else
	if(m_iStatus==STA_FREE&&!b)
	{
		DestroyCap();
		
	}
	return TRUE;
}

/*------------------------------------------------------------------------------*/
//Է󣬻ܵAcceptϢʱô˺򿪸豸
void CAVIOMgr::OnAccept()
{
	if(m_iStatus==STA_FREE) return;
	ZeroMemory(&m_ds,sizeof(m_ds));

	m_ds.bVideoOut=true;//always ok
	if(InitVideoCodec())
		m_ds.bVideoCodec=true;
	if(InitAudioCodec())
		m_ds.bAudioCodec=true;
	if(InitAudioPlay())
		m_ds.bAudioOut=true;
	if(InitAudioRec())
		m_ds.bAudioIn=true;
	
	if(m_ds.bVideoCodec&&InitCap())
		m_ds.bVideoIn=true;
	
	if(!m_ds.bAudioCodec&&!m_ds.bVideoCodec)
	{
		DestroyCap();
		DestroyAudioRec();
		DestroyAudioPlay();
		DestroyAudioCodec();
		DestroyVideoCodec();
		
		m_iStatus=STA_FREE;
	}


	
}

/*------------------------------------------------------------------------------*/
//õ֡
UINT CAVIOMgr::GetFrameCount()
{
	return m_nFrameCount;
}

/*------------------------------------------------------------------------------*/
//ȽϿɿ
BOOL CAVIOMgr::SendCmd(PACK_CMD *pCmd, UINT nLen,sockaddr_in &addr, BOOL bFlag)
{
	if(!pCmd) return FALSE;
	pCmd->id=m_idCmd++;
	pCmd->session=m_session;
	
	int l=m_Socket.SendTo((char*)pCmd,nLen,(sockaddr*)&addr);
	if(l>0)
	{
		if(bFlag)
		{
			m_CmdQueue.Add(pCmd->id,(char*)pCmd,nLen,addr);//
			SetTimer(m_MsgRcvWnd,pCmd->id,800,CmdTimeOutProc);
		}
		return TRUE;
	}
	else
		return FALSE;
}

/*------------------------------------------------------------------------------*/
//ʱط
void CALLBACK CAVIOMgr::CmdTimeOutProc(HWND hwnd,UINT uMsg,UINT idEvent,DWORD dwTime)
{
	if(pMgrInst)
	{
		UINT len;char resend;sockaddr_in addr;
		char* p=pMgrInst->m_CmdQueue.GetBuf(idEvent,len,resend,addr);//ҳӦID(Ѿʱ,Ҫط)
		if(p)
		{
			if(resend<5)
				pMgrInst->m_Socket.SendTo(p,len,(sockaddr*)&addr);
			else//ط4ʱ,ʧ
			{
				KillTimer(hwnd,idEvent);//
				
				if(pMgrInst)
				{
					PACK_CMD* pCmd=(PACK_CMD*)p;
					switch(pCmd->cmd)
					{
					case CMD_CALL:
						{
							PostMessage(pMgrInst->m_hwndMainWnd,IOM_NOTIFY,MAKEWPARAM(IOMN_REFUSE,R_TIMEOUT),(LPARAM)pMgrInst);
							pMgrInst->m_iStatus=STA_FREE;
							
						}
						break;
					case CMD_REFUSE:
						break;
					case CMD_ACCEPT:
						break;
					case CMD_END:
						break;
					case CMD_TXT:
						break;
					}
				}
				pMgrInst->m_CmdQueue.Remove(idEvent);//ӱƳ
			}
		}
		else
			KillTimer(hwnd,idEvent);
	}
}

/*------------------------------------------------------------------------------*/
//ʼ(֡Ƶʼ)
void CALLBACK CAVIOMgr::DropRateCounter(HWND hwnd,UINT uMsg,UINT idEvent,DWORD dwTime)
{
	//㶪
	if(pMgrInst)
	{
		UINT delt;
		if(pMgrInst->m_nCurVid<pMgrInst->m_nLastVid)
			delt=pMgrInst->m_nCurVid+256-pMgrInst->m_nLastVid;
		else
			delt=pMgrInst->m_nCurVid-pMgrInst->m_nLastVid;
		if(delt>0)
			pMgrInst->m_nDropRate=100-(pMgrInst->m_nFrameCount-pMgrInst->m_nLastFrameCount)*100/delt;
		pMgrInst->m_nLastVid=pMgrInst->m_nCurVid;
		//Ͷ
		PACK_CMD pc;
		pc.flag=FLAG_CMD;
		pc.cmd=CMD_DROPRATE;
		pc.session=pMgrInst->m_session;
		pc.type=0;
		pc.data_size_extra=0;
		pc.ext=pMgrInst->m_nDropRate;
		pMgrInst->m_Socket.SendTo((char*)&pc,sizeof(PACK_CMD),(SOCKADDR*)&pMgrInst->m_dst);		
		//֡Ƶ
		pMgrInst->m_nFps=(pMgrInst->m_nFrameCount-pMgrInst->m_nLastFrameCount);
		
		
		pMgrInst->m_nLastFrameCount=pMgrInst->m_nFrameCount;
	}

}

/*------------------------------------------------------------------------------*/
UINT CAVIOMgr::GetFps()
{
	return m_nFps;
}

/*------------------------------------------------------------------------------*/
//ıϢ
BOOL CAVIOMgr::SendTxt(char *ip, unsigned short port, char *txt)
{
	BOOL bRet=FALSE;
	
	PACK_CMD *ppc=(PACK_CMD*)new char[sizeof(PACK_CMD)+strlen(txt)+1];
	strcpy(((char*)ppc)+sizeof(PACK_CMD),txt);
	ppc->flag=FLAG_CMD;
	ppc->cmd=CMD_TXT;
	ppc->type=0;
	ppc->data_size_extra=strlen(txt)+1;
	//ipportת
	sockaddr_in addr;
	addr.sin_family=AF_INET;
	addr.sin_addr.s_addr=CUDPSocket::Name2Inet(ip);
	addr.sin_port=htons(port);
	//
	if(!SendCmd(ppc,sizeof(PACK_CMD)+ppc->data_size_extra,addr,TRUE))
		goto RET;
	
	bRet=TRUE;
		
RET:
	return bRet;
}

/*------------------------------------------------------------------------------*/
//õǰһηݵĵַ
sockaddr_in& CAVIOMgr::GetCurrentAddr()
{
	return m_sockaddr;
}

/*------------------------------------------------------------------------------*/
//
BOOL CAVIOMgr::Enable(BOOL bEnable)
{
	BOOL t=m_bEnable;
	m_bEnable=bEnable;
	return t;
}

/*------------------------------------------------------------------------------*/
//ǷԶͼ
BOOL CAVIOMgr::EnableBandAdjust(BOOL bEnable)
{
	BOOL t=m_bEnableBandAdjust;
	m_bEnableBandAdjust=bEnable;
	return t;
}
