//NetTalk
/*------------------------------------------------------------------------------*\
 =============================
   ģ: VideoCapture.cpp
 =============================
 
 [Ȩ]
 
   2000-2002  115  Ȩ
                                              
\*------------------------------------------------------------------------------*/
#include "WndX.h"
#include <vfw.h>
#include "VideoCapture.h"

#include "AVIOMgr.h"

#pragma comment(lib,"vfw32")

/*------------------------------------------------------------------------------*/

CVideoCapture::CVideoCapture()

{
	
	m_hWndCap = NULL;
	
	
	
}
/*------------------------------------------------------------------------------*/
CVideoCapture::~CVideoCapture()
{
	Destroy();
}
/*------------------------------------------------------------------------------*/
BOOL CVideoCapture::Init()
{
	
	BOOL bRet = FALSE;
	int i;	
	Destroy();	
	
	m_hWndCap=capCreateCaptureWindow(0,0,0,0,0,0,0,0);
	if(!m_hWndCap)
		goto RET;
	for(i=0;i<MAX_VFW_DEVICES;i++)
		m_DriverIndex[i]=-1;

	capSetUserData(m_hWndCap,this);
		
			
	bRet=TRUE;
RET:	
	
	return bRet;
}

/*------------------------------------------------------------------------------*/

HWND CVideoCapture::GetCapWindow()
{
	return m_hWndCap;
}

/*------------------------------------------------------------------------------*/

VOID CVideoCapture::Destroy()
{

	if (m_hWndCap)
	{
		if(IsWindow(m_hWndCap))
		capCaptureAbort(m_hWndCap);
		capSetCallbackOnVideoStream(m_hWndCap, NULL);
		DisconnectFromDriver();
	}
	DestroyWindow(m_hWndCap);
	m_hWndCap = NULL;
}

/*------------------------------------------------------------------------------*/
//豸
BOOL CVideoCapture::ConnectToDriver(SHORT DriverIndex)
{
	BOOL bRet = FALSE;
	CAPTUREPARMS CapParms = {0};
	
	
	if(DriverIndex>=MAX_VFW_DEVICES)
	{
	
		goto RET;
	}
	
	
	if (m_hWndCap==NULL||m_DriverIndex[DriverIndex]==-1)
		goto RET;
	capCaptureAbort(m_hWndCap);
		
	if(!capDriverConnect(m_hWndCap, m_DriverIndex[DriverIndex]))
		goto RET;
			
	
	capCaptureGetSetup(m_hWndCap,&CapParms,sizeof(CapParms));
	CapParms.vKeyAbort=0;
	CapParms.fAbortLeftMouse = FALSE;
	CapParms.fAbortRightMouse = FALSE;
	CapParms.fYield = TRUE;
	CapParms.fCaptureAudio=FALSE;
	CapParms.wPercentDropForError = 100;
	capCaptureSetSetup(m_hWndCap,&CapParms,sizeof(CapParms));	
	bRet=TRUE;
RET:
	
	return bRet;
}


/*------------------------------------------------------------------------------*/


//õ豸
int CVideoCapture::GetDriverNum()
{
	int iDriverNum=0;
	char szName[200],szVer[200];
	for(int i=0;i<MAX_VFW_DEVICES;i++)
	{
		if(capGetDriverDescription(i,szName,200,szVer,200))
		{
			m_DriverIndex[iDriverNum]=(SHORT)i;
			iDriverNum++;
		}
	}
	return iDriverNum;
}
/*------------------------------------------------------------------------------*/
//Ͽ
BOOL CVideoCapture::DisconnectFromDriver()
{
	BOOL bRet=FALSE;
	if(!m_hWndCap)
		goto RET;
	if(!capDriverDisconnect(m_hWndCap))
		goto RET;
	
	bRet=TRUE;
RET:
	return bRet;
}






