//NetTalk
/*------------------------------------------------------------------------------*\
 =============================
   ģ: AddrBook.cpp
 =============================
 
 [Ȩ]
 
   2000-2002  115  Ȩ
                                              
\*------------------------------------------------------------------------------*/

#include "WndX.h"
#include "AddrBook.h"
#include "resource.h"
#include <stdio.h>
#include "NewMsgBox.h"

/*------------------------------------------------------------------------------*/

CAddrBook::CAddrBook()
{
	m_bModify=FALSE;//modify޸
}

/*------------------------------------------------------------------------------*/

CAddrBook::~CAddrBook()
{

}

/*------------------------------------------------------------------------------*/

LRESULT CAddrBook::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_COMMAND:
		return OnCommand(wParam,lParam);
	case WM_INITDIALOG:
		return OnInitDialog();
	case WM_CLOSE://ͨѶ¼رʱmodify־Ա
		if(m_bModify)
			SaveList();
		OnClose();
		break;
	default:
		return CGraphDlg::WndProc(uMsg,wParam,lParam);
	}
	return TRUE;
}

/*------------------------------------------------------------------------------*/

BOOL CAddrBook::OnInitDialog()
{
	CGraphDlg::OnInitDialog();

	SetWindowText(m_hWnd,"ͨѶ¼");

	HWND h=GetDlgItem(m_hWnd,IDC_LIST);
	LVCOLUMN lvc;
	lvc.mask=LVCF_TEXT|LVCF_WIDTH;
	lvc.cx=60;
	lvc.pszText="";
	ListView_InsertColumn(h,0,&lvc);
	lvc.pszText="/IP";
	lvc.cx=100;
	ListView_InsertColumn(h,1,&lvc);
	//ͨѶ¼
	LoadList();
	return FALSE;
}

/*------------------------------------------------------------------------------*/

BOOL CAddrBook::OnCommand(WPARAM wParam, LPARAM lParam)
{
	CGraphDlg::OnCommand(wParam,lParam);
	switch(LOWORD(wParam))
	{
	case IDC_EDIT://༭
		{
			HWND h=GetDlgItem(m_hWnd,IDC_LIST);
			int iItem=ListView_GetNextItem(h,-1,LVNI_SELECTED);
			if(iItem>=0)
			{
				CModifyDlg md;
				ListView_GetItemText(h,iItem,0,md.m_szName,64);
				ListView_GetItemText(h,iItem,1,md.m_szIP,64);
				if(md.DoModal(LPCTSTR(IDD_MODIFY),m_hWnd))
				{
					
					ListView_SetItemText(h,iItem,0,md.m_szName);
					ListView_SetItemText(h,iItem,1,md.m_szIP);
					m_bModify=TRUE;
				}
			}
		}
		break;
	case IDC_ADD://
		{
			HWND h=GetDlgItem(m_hWnd,IDC_LIST);
			CModifyDlg md;
			if(md.DoModal(LPCTSTR(IDD_MODIFY),m_hWnd))
			{
				LVITEM li;
				li.iSubItem=0;						
				li.mask=LVIF_TEXT;
				li.iItem=10000;
				li.pszText=md.m_szName;
				int iItem=ListView_InsertItem(h,&li);
				ListView_SetItemText(h,iItem,1,md.m_szIP);
				
				m_bModify=TRUE;
			}
		}
		break;
	case IDC_DEL://ɾ
		{
			HWND h=GetDlgItem(m_hWnd,IDC_LIST);
			int iItem=ListView_GetNextItem(h,-1,LVNI_SELECTED);
			if(iItem>=0)
			{
				if(CMsgBox::MessageBox(m_hWnd,IDS_MSG_DELREC,IDS_WAR,MB_YESNO,IDI_INFO)==IDYES)
				{
					ListView_DeleteItem(h,iItem);
					m_bModify=TRUE;
				}
			}
		}
		break;
	case IDC_C://
		{
			HWND h=GetDlgItem(m_hWnd,IDC_LIST);
			int iItem=ListView_GetNextItem(h,-1,LVNI_SELECTED);
			if(iItem>=0)
			{
				char szIP[64];
				ListView_GetItemText(h,iItem,1,szIP,64);
				HWND hp=GetParent(m_hWnd);
				SendMessage(m_hWnd,WM_CLOSE,0,0);
				SendMessage(hp,WM_COMMAND,0,(LPARAM)szIP);
			}
		}
		break;
		
	
	}
	return TRUE;
}

/*------------------------------------------------------------------------------*/
//ͨѶ¼
void CAddrBook::LoadList()
{
	//õ·
	char szPath[256];
	GetModuleFileName(0,szPath,255);
	int i;
	for(i=strlen(szPath);i>0;i--)
	{
		if(szPath[i]=='\\')
		{
			szPath[i+1]=0;
			break;
		}
	}

	//
	strcpy(szPath+strlen(szPath),"addr.db");
	HWND h=GetDlgItem(m_hWnd,IDC_LIST);
	//õ¼
	int count=GetPrivateProfileInt("addr","count",0,szPath);
	char sz[64];
	LVITEM li;
	li.iItem=10000;
	
	li.mask=LVIF_TEXT;
	li.pszText=sz;
	//¼ӵб
	for(i=0;i<count;i++)
	{
		char s[10];
		sprintf(s,"%da",i);
		li.iSubItem=0;
		GetPrivateProfileString("addr",s,"",sz,64,szPath);
		int iItem=ListView_InsertItem(h,&li);
		li.iSubItem=1;
		sprintf(s,"%db",i);
		GetPrivateProfileString("addr",s,"",sz,64,szPath);
		ListView_SetItemText(h,iItem,1,sz);
	}

}
/*------------------------------------------------------------------------------*/
//ͨѶ¼
void CAddrBook::SaveList()
{
	//õ·
	char szPath[256];
	GetModuleFileName(0,szPath,255);
	int i;
	for(i=strlen(szPath);i>0;i--)
	{
		if(szPath[i]=='\\')
		{
			szPath[i+1]=0;
			break;
		}
	}
	//
	strcpy(szPath+strlen(szPath),"addr.db");
	HWND h=GetDlgItem(m_hWnd,IDC_LIST);
	//õ¼
	int count=ListView_GetItemCount(h);
	char sz[64];
	sprintf(sz,"%d",count);
	//дļ
	WritePrivateProfileString("addr","count",sz,szPath);
	for(i=0;i<count;i++)
	{
		char s[10];
		sprintf(s,"%da",i);
		ListView_GetItemText(h,i,0,sz,64);
		WritePrivateProfileString("addr",s,sz,szPath);
		sprintf(s,"%db",i);
		ListView_GetItemText(h,i,1,sz,64);
		WritePrivateProfileString("addr",s,sz,szPath);
	}

}

/*------------------------------------------------------------------------------*/

CModifyDlg::CModifyDlg()
{
	m_szName[0]=0;
	m_szIP[0]=0;
}

/*------------------------------------------------------------------------------*/
CModifyDlg::~CModifyDlg()
{

}

/*------------------------------------------------------------------------------*/
LRESULT CModifyDlg::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_INITDIALOG:
		CGraphDlg::OnInitDialog();
		SetWindowText(m_hWnd,"¼");
		SetDlgItemText(m_hWnd,IDC_NAME,m_szName);
		SetDlgItemText(m_hWnd,IDC_IP,m_szIP);
		return FALSE;
	case WM_COMMAND:
		CGraphDlg::OnCommand(wParam,lParam);
		switch(LOWORD(wParam))
		{
		case IDC_OK:
			GetDlgItemText(m_hWnd,IDC_NAME,m_szName,64);
			if(strlen(m_szName)==0)
				break;
			GetDlgItemText(m_hWnd,IDC_IP,m_szIP,64);
			if(strlen(m_szIP)==0)
				break;
			EndDialog(m_hWnd,TRUE);
			break;
		case IDC_CANCEL:
			EndDialog(m_hWnd,FALSE);
			break;
		}
		break;
	case WM_CLOSE:
		EndDialog(m_hWnd,FALSE);
		break;
	default:
		return CGraphDlg::WndProc(uMsg,wParam,lParam);
	}
	return TRUE;
}

