//NetTalk
/*------------------------------------------------------------------------------*\
 =============================
   ģ: CoolBtn.cpp
 =============================
 
 [Ȩ]
 
   2000-2002  115  Ȩ
                                              
\*------------------------------------------------------------------------------*/
#include "WndX.h"
#include "CoolBtn.h"
#include <Windowsx.h>

/*------------------------------------------------------------------------------*/

CCoolBtn::~CCoolBtn()
{

}
/*------------------------------------------------------------------------------*/
CCoolBtn::CCoolBtn()
{
	
	m_hNormal=0;
	m_hHover=0;
	m_hDown=0;

	m_uState=0;

}
/*------------------------------------------------------------------------------*/

LRESULT CCoolBtn::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_PAINT:
		OnPaint();
		return TRUE;
	case WM_ERASEBKGND:
		return TRUE;
	case WM_DESTROY:
		{
			//Դ
			if(m_hNormal)
				DeleteObject(m_hNormal);
			if(m_hHover)
				DeleteObject(m_hHover);
			if(m_hDown)
				DeleteObject(m_hDown);	
			m_hNormal=0;
			m_hHover=0;
			m_hDown=0;
		}
		break;
	case WM_MOUSEMOVE:
		{
			POINT point;
			point.x=GET_X_LPARAM(lParam); 
			point.y=GET_Y_LPARAM(lParam); 
			OnMouseMove(wParam,point);
		}
		return TRUE;
	case WM_LBUTTONDBLCLK:
	case WM_LBUTTONDOWN:
		{
			POINT point;
			point.x=GET_X_LPARAM(lParam); 
			point.y=GET_Y_LPARAM(lParam); 
			OnLButtonDown(wParam,point);
		}
		return TRUE;
	case WM_TIMER:
		OnTimer(wParam);
		break;
	}
	return CallWindowProc(m_OldProc,m_hWnd,uMsg,wParam,lParam);
}

/*------------------------------------------------------------------------------*/
void CCoolBtn::OnPaint()
{
	//״̬ʱİť
	HBITMAP h;
	switch(m_uState)
	{
	case 0:
		h=m_hNormal;
		break;
	case 1:
		h=m_hHover;
		break;
	case 2:
		h=m_hDown;
		break;
	}
	PAINTSTRUCT ps;
	HDC hdc=BeginPaint(m_hWnd,&ps);
	HDC hMemDC=CreateCompatibleDC(hdc);
	HBITMAP hob=(HBITMAP)SelectObject(hMemDC,h);
	CRectX rc;
	GetWindowRect(m_hWnd,&rc);
	BitBlt(hdc,0,0,rc.Width(),rc.Height(),hMemDC,0,0,SRCCOPY);
	SelectObject(hMemDC,hob);
	DeleteDC(hMemDC);
	EndPaint(m_hWnd,&ps);
}

/*------------------------------------------------------------------------------*/

BOOL CCoolBtn::Create(RECT &rc, HWND hParent, UINT uID)
{
	return CButtonX::Create(0,WS_CHILD|WS_VISIBLE,rc,hParent,uID);
}

/*------------------------------------------------------------------------------*/
//λͼ
void CCoolBtn::LoadBitmaps(UINT uBmpNormal, UINT uBmpHover, UINT uBmpDown)
{
	if(m_hNormal)
		DeleteObject(m_hNormal);
	if(m_hHover)
		DeleteObject(m_hHover);
	if(m_hDown)
		DeleteObject(m_hDown);
	m_hNormal=LoadBitmap(hInstX,(LPCTSTR)uBmpNormal);
	m_hHover=LoadBitmap(hInstX,(LPCTSTR)uBmpHover);
	m_hDown=LoadBitmap(hInstX,(LPCTSTR)uBmpDown);

}

/*------------------------------------------------------------------------------*/

void CCoolBtn::OnMouseMove(UINT nFlags, POINT point)
{

	if(m_uState==0)
	{
		m_uState=1;
		HDC hdc=GetDC(m_hWnd);
		HDC hMemDC=CreateCompatibleDC(hdc);
		HBITMAP hob=(HBITMAP)SelectObject(hMemDC,m_hHover);
		CRectX rc;
		GetWindowRect(m_hWnd,&rc);
		BitBlt(hdc,0,0,rc.Width(),rc.Height(),hMemDC,0,0,SRCCOPY);
		SelectObject(hMemDC,hob);
		DeleteDC(hMemDC);
		ReleaseDC(m_hWnd,hdc);
		SetTimer(m_hWnd,1,50,0);
	}
}

/*------------------------------------------------------------------------------*/

void CCoolBtn::OnTimer(UINT nIDEvent)
{
	POINT pt;
	GetCursorPos(&pt);
	RECT rc;
	GetWindowRect(m_hWnd,&rc);
	if(!PtInRect(&rc,pt))
	{
		m_uState=0;
		HDC hdc=GetDC(m_hWnd);
		HDC hMemDC=CreateCompatibleDC(hdc);
		HBITMAP hob=(HBITMAP)SelectObject(hMemDC,m_hNormal);
		CRectX rc;
		GetWindowRect(m_hWnd,&rc);
		BitBlt(hdc,0,0,rc.Width(),rc.Height(),hMemDC,0,0,SRCCOPY);
		SelectObject(hMemDC,hob);
		DeleteDC(hMemDC);
		ReleaseDC(m_hWnd,hdc);
		
		KillTimer(m_hWnd,nIDEvent);
	}

}

/*------------------------------------------------------------------------------*/

void CCoolBtn::OnLButtonDown(UINT nFlags, POINT &point)
{
	m_uState=2;
	KillTimer(m_hWnd,1);
	SetCapture(m_hWnd);
	HDC hdc=GetDC(m_hWnd);
	HDC hMemDC=CreateCompatibleDC(hdc);
	HBITMAP hob=(HBITMAP)SelectObject(hMemDC,m_hDown);
	CRectX rc;
	GetWindowRect(m_hWnd,&rc);
	BitBlt(hdc,0,0,rc.Width(),rc.Height(),hMemDC,0,0,SRCCOPY);
	SelectObject(hMemDC,hob);
	DeleteDC(hMemDC);
	ReleaseDC(m_hWnd,hdc);
		
	MSG msg;
	while(GetMessage(&msg, NULL, 0, 0))
	{
		
		if (GetCapture()!=m_hWnd)
		{
			DispatchMessage(&msg);
			break;
		}
		
		switch (msg.message)
		{
			
		case WM_MOUSEMOVE:
			break;
		case WM_LBUTTONUP:
			{				
				POINT pt;
				GetCursorPos(&pt);
				RECT rc;
				GetWindowRect(m_hWnd,&rc);
				if(PtInRect(&rc,pt))
				{
					SendMessage(GetParent(m_hWnd),WM_COMMAND,GetDlgCtrlID(m_hWnd),0);
				}
			}
			goto EXITLOOP;
				
		default:
			DispatchMessage(&msg);
			break;
		}
	}
	
EXITLOOP:
	m_uState=0;
	hdc=GetDC(m_hWnd);
	hMemDC=CreateCompatibleDC(hdc);
	hob=(HBITMAP)SelectObject(hMemDC,m_hNormal);
	GetWindowRect(m_hWnd,&rc);
	BitBlt(hdc,0,0,rc.Width(),rc.Height(),hMemDC,0,0,SRCCOPY);
	SelectObject(hMemDC,hob);
	DeleteDC(hMemDC);
	ReleaseDC(m_hWnd,hdc);	
	ReleaseCapture();
}
