//NetTalk
/*------------------------------------------------------------------------------*\
 =============================
   ģ: GraphDlg.cpp
 =============================
 
 [Ȩ]
 
   2000-2002  115  Ȩ
                                              
\*------------------------------------------------------------------------------*/

#include "wndx.h"
#include "GraphDlg.h"
#include <Windowsx.h>
#include "resource.h"
#define BORDER_WIDTH 1
#define TITLE_HEIGHT 18



/*------------------------------------------------------------------------------*/
CGraphDlg::CGraphDlg()
{
	m_bHilight=0;
	m_hbBkS=CreateSolidBrush(0x00b9b4b3);//Static ctrl's bg color
	m_hbBkE=CreateSolidBrush(0x00ffffff);//Edit ctrl's bg color
}


/*------------------------------------------------------------------------------*/
CGraphDlg::~CGraphDlg()
{
	if(m_hbBkS)
		DeleteObject(m_hbBkS);
	if(m_hbBkE)
		DeleteObject(m_hbBkE);
}
/*------------------------------------------------------------------------------*/
LRESULT CGraphDlg::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	
	case WM_CTLCOLORSTATIC:
		{
			SetBkMode((HDC)wParam,TRANSPARENT);
			return (LRESULT)m_hbBkS;
		}
		break;
	case WM_CTLCOLOREDIT:
		{
			SetTextColor((HDC)wParam,0x00632201);
			return (LRESULT)m_hbBkE;
		}
		break;
	case WM_DESTROY:
		OnDestroy();
		break;
	case WM_INITDIALOG:
		
		return OnInitDialog();
		break;
	case WM_COMMAND:
		return OnCommand(wParam,lParam);
		
		break;
	case WM_ERASEBKGND:
		OnEraseBkgnd((HDC)wParam);
		return TRUE;
	
	
	case WM_MOUSEMOVE:
		{
			POINT point;
			point.x=GET_X_LPARAM(lParam); 
			point.y=GET_Y_LPARAM(lParam); 
			OnMouseMove(wParam,point);
		}
		break;
	case WM_LBUTTONDOWN:
		{
			POINT point;
			point.x=GET_X_LPARAM(lParam); 
			point.y=GET_Y_LPARAM(lParam); 
			OnLButtonDown(wParam,point);	
		}
		break;
	case WM_TIMER:
		OnTimer(wParam);
		break;
	default:
		return CDialogX::WndProc(uMsg,wParam,lParam);
	}
	return TRUE;

}

/*------------------------------------------------------------------------------*/

void CGraphDlg::OnEraseBkgnd(HDC hdc)
{
	
	CRectX rc;
	GetClientRect(m_hWnd,&rc);
	HDC hMemDC=CreateCompatibleDC(hdc);
	HBITMAP hb=CreateCompatibleBitmap(hdc,rc.Width(),rc.Height());
	HBITMAP hob=(HBITMAP)SelectObject(hMemDC,hb);
	//ͻ

	FillSolidRectX(hMemDC,CRectX(rc.left+2,BORDER_WIDTH,rc.right-2,rc.bottom-2),0x00b9b4b3);
	//
	DrawTitleBar(hMemDC);
	
	//
	DrawRectX(hMemDC,rc,0);
	CRectX rc2;
	rc2=rc;
	InflateRect(&rc2,-1,-1);
	Draw3dRectX(hMemDC,rc2,0x00e8e8e8,0x009c9c9c,1);
	
	BitBlt(hdc,0,0,rc.Width(),rc.Height(),hMemDC,0,0,SRCCOPY);
	SelectObject(hMemDC,hob);
	DeleteObject(hb);
	DeleteDC(hMemDC);
}

/*------------------------------------------------------------------------------*/
//make the title bar dragable
void CGraphDlg::OnLButtonDown(UINT nFlags, POINT &point)
{	
	
	if(PtInRegion(m_hTRgn,point.x,point.y))
	{

		SetCapture(m_hWnd);
		
		RECT rc;
		GetWindowRect(m_hWnd,&rc);
		MSG msg;
		while(GetMessage(&msg, NULL, 0, 0))
		{
			if (GetCapture()!=m_hWnd)
			{
				DispatchMessage(&msg);
				break;
			}
			switch(msg.message)
			{
			case WM_MOUSEMOVE:
				{
					POINT pt;
					pt.x=GET_X_LPARAM(msg.lParam);
					pt.y=GET_Y_LPARAM(msg.lParam);
					rc.left+=pt.x-point.x;
					rc.top+=pt.y-point.y;
					SetWindowPos(m_hWnd,0,rc.left,
						rc.top,0,0,SWP_NOSIZE);
				}
				break;
			case WM_LBUTTONUP:
				
				goto EXITLOOP1;					
				
			default:
				DispatchMessage(&msg);
				break;
				
			}
		}
EXITLOOP1:
		ReleaseCapture();
	}
}
/*------------------------------------------------------------------------------*/
//Hilight the title bar when mouse hover the title bar
void CGraphDlg::OnMouseMove(UINT nFlags, POINT &point)
{
	if(PtInRegion(m_hTRgn,point.x,point.y))
	{
		if(!m_bHilight)
		{
			m_bHilight=TRUE;
			HDC hdc=GetDC(m_hWnd);
			DrawTitleBar(hdc);
			ReleaseDC(m_hWnd,hdc);
			SetTimer(m_hWnd,101,50,0);
		}
	}
}


/*------------------------------------------------------------------------------*/
//
BOOL CGraphDlg::OnInitDialog()
{
	RECT rc;
	//
	
	GetClientRect(m_hWnd,&rc);
	//make the title bar region
	POINT pt[4];
	pt[0].x=2;
	pt[0].y=2;
	pt[1].x=rc.right-30;
	pt[1].y=2;
	pt[2].x=rc.right-30-TITLE_HEIGHT;
	pt[2].y=TITLE_HEIGHT+BORDER_WIDTH;
	pt[3].x=2;
	pt[3].y=TITLE_HEIGHT+BORDER_WIDTH;
	m_hTRgn=CreatePolygonRgn(pt,4,ALTERNATE);

	//create the close button
	rc.left=rc.right-20;
	rc.right-=8;
	rc.top=5;
	rc.bottom=17;
	m_btnClose.LoadBitmaps(IDB_CLOSE1,IDB_CLOSE2,IDB_CLOSE3);
	m_btnClose.Create(rc,m_hWnd,IDC_CLOSE);
	return FALSE;
}
/*------------------------------------------------------------------------------*/
BOOL CGraphDlg::OnCommand(WPARAM wParam, LPARAM lParam)
{
	CDialogX::OnCommand(wParam,lParam);
	switch(LOWORD(wParam))
	{
	case IDC_CLOSE:
		SendMessage(m_hWnd,WM_CLOSE,0,0);
		break;
	}
	return TRUE;
}
/*------------------------------------------------------------------------------*/
void CGraphDlg::DrawTitleBar(HDC hdc)
{
	//file the title bar region,and make it 3d look
	RECT rc;
	GetClientRect(m_hWnd,&rc);
	HBRUSH hbr;
	if(m_bHilight)
		hbr=CreateSolidBrush(0x00886655);		
	else
		hbr=CreateSolidBrush(0x00553322);		

	FillRgn(hdc,m_hTRgn,hbr);
	DeleteObject(hbr);
	
	HPEN hp=CreatePen(PS_SOLID,1,0);
	HPEN hop=(HPEN)SelectObject(hdc,hp);
	MoveToEx(hdc,2,TITLE_HEIGHT+BORDER_WIDTH,0);
	LineTo(hdc,2,2);
	LineTo(hdc,rc.right-30,2);
	SelectObject(hdc,hop);
	DeleteObject(hp);
	hp=CreatePen(PS_SOLID,1,0x00eeeeee);
	hop=(HPEN)SelectObject(hdc,hp);
	LineTo(hdc,rc.right-30-TITLE_HEIGHT+1,TITLE_HEIGHT+BORDER_WIDTH);
	LineTo(hdc,1,TITLE_HEIGHT+BORDER_WIDTH);
	SelectObject(hdc,hop);
	DeleteObject(hp);

	//caption
	char szTitle[64]="";
	NONCLIENTMETRICS ncm;
	ncm.cbSize = sizeof(ncm);
	SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, &ncm, 0);
	HFONT hf=CreateFontIndirect(&ncm.lfCaptionFont);
	HFONT hof=(HFONT)SelectObject(hdc,hf);
	SetBkMode(hdc,TRANSPARENT);
	SetTextColor(hdc,0x00ffffff);
	GetWindowText(m_hWnd,szTitle,63);
	
	DrawText(hdc,szTitle,strlen(szTitle),&CRectX(6,4,rc.right-30,30),DT_LEFT);
	SelectObject(hdc,hof);
	DeleteObject(hf);
}
/*------------------------------------------------------------------------------*/
//when the mouse leave the region of title bar ,recover the title bar
void CGraphDlg::OnTimer(UINT nIDEvent)
{
	if(nIDEvent==101)
	{
		DWORD dw=GetMessagePos();
		POINT pt;
		pt.x=GET_X_LPARAM(dw);
		pt.y=GET_Y_LPARAM(dw);
		ScreenToClient(m_hWnd,&pt);
		if(m_bHilight)
		{
					
			if(!PtInRegion(m_hTRgn,pt.x,pt.y))
			{
				RECT rc;
				SetRect(&rc,2,2,119,16);
				m_bHilight=FALSE;
				HDC hdc=GetDC(m_hWnd);
				
				DrawTitleBar(hdc);
				ReleaseDC(m_hWnd,hdc);
				KillTimer(m_hWnd,nIDEvent);
			}
			
			
		}
	}
}
/*------------------------------------------------------------------------------*/
//
void CGraphDlg::OnDestroy()
{
	DeleteObject(m_hTRgn);
}
