#include "WndX.h"
#include <WindowsX.h>
#include "MsgBox.h"
#include "resource.h"

CMsgBox::CMsgBox()
{
	m_hbmpClose=LoadBitmap(hInstX,LPCTSTR(IDB_CLOSE));
	m_hbmpFace=LoadBitmap(hInstX,LPCTSTR(IDB_MSGBOX));
	m_hbmpT1=LoadBitmap(hInstX,LPCTSTR(IDB_MSGTITLE1));
	m_hbmpT2=LoadBitmap(hInstX,LPCTSTR(IDB_MSGTITLE2));
	//HRGN hrgnTitle=
}

CMsgBox::~CMsgBox()
{
	if(m_hbmpClose)
		DeleteObject(m_hbmpClose);
	if(m_hbmpFace)
		DeleteObject(m_hbmpFace);
	if(m_hbmpT1)
		DeleteObject(m_hbmpT1);
	if(m_hbmpT2)
		DeleteObject(m_hbmpT2);

}

LRESULT CMsgBox::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_INITDIALOG:
		{
			POINT pt[5]={{0,11},{11,0},{238,0},{238,102},{0,102}};
			HRGN h=CreatePolygonRgn(pt,5,ALTERNATE);
			SetWindowRgn(m_hWnd,h,0);
			
			
			m_btnClose.SetType(CCoolBtn::tFlat|CCoolBtn::tBitmap);
			m_btnClose.SetColor(CCoolBtn::fFace,0x00b9b4b3);
			m_btnClose.SetBitmap(m_hbmpClose,0x00ffffff);
			m_btnClose.SetRect((RECT)CRectX(60,3,72,15));
			m_btn1.SetType(CCoolBtn::tText);
			m_btn2.SetType(CCoolBtn::tText);
			m_btn1.SetColor(CCoolBtn::fFace,0x00b9b4b3);
			m_btn2.SetColor(CCoolBtn::fFace,0x00b9b4b3);
			if(m_type==MBX_OK)
				m_btn1.SetText("ȷ");
			if(m_type==MBX_YESNO)
			{
				m_btn1.SetText("");
				m_btn2.SetText("");
			}
			m_btn1.SetRect((RECT)CRectX(165,57,180,70));
			m_btn2.SetRect((RECT)CRectX(140,57,160,70));
		}
		break;
	case WM_ERASEBKGND:
		return OnEraseBkgnd((HDC)wParam);
		break;
	case WM_MOUSEMOVE:
		{
			POINT point;
			point.x=GET_X_LPARAM(lParam); 
			point.y=GET_Y_LPARAM(lParam); 
			OnMouseMove(wParam,point);
		}
		break;
	case WM_LBUTTONDOWN:
		{
			POINT point;
			point.x=GET_X_LPARAM(lParam); 
			point.y=GET_Y_LPARAM(lParam); 
			OnLButtonDown(wParam,point);	
		}
		break;
	case WM_SETCURSOR:
		{
			DWORD dw=GetMessagePos();
			POINT pt;
			pt.x=GET_X_LPARAM(dw);
			pt.y=GET_Y_LPARAM(dw);
			ScreenToClient(m_hWnd,&pt);
			if(PtInRegion(m_hrgnTitle,pt.x,pt.y))
			{
				SetCursor(LoadCursor(hInstX,LPCTSTR(IDC_DRAG)));
				return TRUE;
			}
			return FALSE;
		}
		break;
	default:
		return CDialogX::WndProc(uMsg,wParam,lParam);
	}
	return TRUE;
}

UINT CMsgBox::ShowMsg(char *caption, char *msg, UINT type, HWND hwnd)
{
	if(caption)
		strncpy(m_caption,caption,127);
	if(msg)
		strncpy(m_msg,msg,255);
	m_type=type;
	return (UINT)DoModal((LPCTSTR)IDD_MSG_DLG,hwnd);
}

int CMsgBox::DoModal(LPCTSTR lpszTemplateName, HWND hWndParent)
{
	CDialogX::DoModal(lpszTemplateName,hWndParent);

	return m_uResult;
}

BOOL CMsgBox::OnEraseBkgnd(HDC hdc)
{
	HDC hMemDC;
	hMemDC=CreateCompatibleDC(hdc);
	
	HBITMAP hob=(HBITMAP)SelectObject(hMemDC,m_hbmpFace);

	if(m_bHilight)
	{
		DrawTransBmpX(hMemDC,m_rcTitle,m_hbmpT2,0,0,0);
	}
	else
	{	
		DrawTransBmpX(hMemDC,m_rcTitle,m_hbmpT1,0,0,0);
	}
	
	
	m_btnClose.Paint(hMemDC);
	HFONT hf=GetWindowFont(m_hWnd);
	TxtBlt(hMemDC,m_msg,m_rcMsg,0,0x00b9b4b3,hf,FALSE);


	BitBlt(hdc,0,0,m_rc.Width(),m_rc.Height(),hMemDC,0,0,SRCCOPY);
	
	SelectObject(hMemDC,hob);
	DeleteObject(m_hbmpFace);
	
	
	DeleteDC(hMemDC);
	return TRUE;
}

void CMsgBox::OnMouseMove(UINT nFlags, POINT point)
{
	if(PtInRegion(m_hrgnTitle,point.x,point.y))
	{
		if(!m_bHilight)
		{
			m_bHilight=TRUE;
			HDC hdc=GetDC(m_hWnd);
			
			DrawTransBmpX(hdc,m_rcTitle,m_hbmpT2,0,0,0);
			
			ReleaseDC(m_hWnd,hdc);
			SetTimer(m_hWnd,1,100,0);
		}
	}
	else
	if(m_btnClose.IsMouseOn(point))
	{
		
		HDC hdc=GetDC(m_hWnd);
		m_btnZoom.Paint(hdc);
		m_btnClose.Paint(hdc,CCoolBtn::sHover);
		ReleaseDC(m_hWnd,hdc);
		SetTimer(m_hWnd,1,100,0);
	}
	else
	if(m_btnZoom.IsMouseOn(point))
	{
		HDC hdc=GetDC(m_hWnd);
		m_btnClose.Paint(hdc);
		m_btnZoom.Paint(hdc,CCoolBtn::sHover);
		ReleaseDC(m_hWnd,hdc);
		SetTimer(m_hWnd,1,100,0);
	}
	else
	if(m_bHilight)
	{
		
		
		m_bHilight=FALSE;
		HDC hdc=GetDC(m_hWnd);
		
		DrawTransBmpX(hdc,m_rcTitle,m_hbmpT1,0,0,0);
		ReleaseDC(m_hWnd,hdc);
		KillTimer(m_hWnd,1);
	}
	else
	{
		HDC hdc=GetDC(m_hWnd);
		m_btnZoom.Paint(hdc);
		m_btnClose.Paint(hdc);
		ReleaseDC(m_hWnd,hdc);
	}
}

void CMsgBox::OnLButtonDown(UINT nFlags, POINT &point)
{
	if(PtInRegion(m_hrgnTitle,point.x,point.y))
	{
		SetCapture(m_hWnd);
		
		RECT rc;
		GetWindowRect(m_hWnd,&rc);
		MSG msg;
		while(GetMessage(&msg, NULL, 0, 0))
		{
			if (GetCapture()!=m_hWnd)
			{
				DispatchMessage(&msg);
				break;
			}
			switch(msg.message)
			{
			case WM_MOUSEMOVE:
				{
					POINT pt;
					pt.x=GET_X_LPARAM(msg.lParam);
					pt.y=GET_Y_LPARAM(msg.lParam);
					rc.left+=pt.x-point.x;
					rc.top+=pt.y-point.y;
					SetWindowPos(m_hWnd,0,rc.left,
						rc.top,0,0,SWP_NOSIZE);
				}
				break;
			case WM_LBUTTONUP:
				
				goto EXITLOOP1;					
				
			default:
				DispatchMessage(&msg);
				break;
				
			}
		}
EXITLOOP1:
		ReleaseCapture();
	}
	if(m_btnClose.IsMouseOn(point))
	{
		KillTimer(m_hWnd,1);
		SetCapture(m_hWnd);
		HDC hdc=GetDC(m_hWnd);
		m_btnClose.Paint(hdc,CCoolBtn::sDown);
		ReleaseDC(m_hWnd,hdc);
		
		MSG msg;
		while(GetMessage(&msg, NULL, 0, 0))
		{
			
			if (GetCapture()!=m_hWnd)
			{
				DispatchMessage(&msg);
				break;
			}
			
			switch (msg.message)
			{
				
			case WM_MOUSEMOVE:
				break;
			case WM_LBUTTONUP:
				{
					POINT pt;
					pt.x=GET_X_LPARAM(msg.lParam);
					pt.y=GET_Y_LPARAM(msg.lParam);
					if(m_btnClose.IsMouseOn(pt))
					{
						SendMessage(m_hWnd,WM_CLOSE,0,0);
					}
				}
				goto EXITLOOP2;
				
			case WM_KEYDOWN:	
				if (msg.wParam != VK_ESCAPE) 
					break;
				
			default:
				DispatchMessage(&msg);
				break;
			}
		}
		
EXITLOOP2:
		if(m_hWnd)
		{
			hdc=GetDC(m_hWnd);
			m_btnClose.Paint(hdc);
			ReleaseDC(m_hWnd,hdc);
		}
		ReleaseCapture();
		
	}
	
	
	
}
void CMsgBox::OnTimer(UINT nIDEvent)
{
	DWORD dw=GetMessagePos();
	POINT pt;
	pt.x=GET_X_LPARAM(dw);
	pt.y=GET_Y_LPARAM(dw);
	ScreenToClient(m_hWnd,&pt);
	if(m_bHilight)
	{
	
		
		if(!PtInRegion(m_hrgnTitle,pt.x,pt.y))
		{
			RECT rc;
			SetRect(&rc,2,2,119,16);
			m_bHilight=FALSE;
			HDC hdc=GetDC(m_hWnd);
			
			DrawTransBmpX(hdc,rc,m_hbmpT1,0,0,0);
			ReleaseDC(m_hWnd,hdc);
			KillTimer(m_hWnd,1);
		}
		
		
	}
	if(!m_btnClose.IsMouseOn(pt))
	{
		HDC hdc=GetDC(m_hWnd);
		m_btnClose.Paint(hdc);
		ReleaseDC(m_hWnd,hdc);
	}

}


