//NetTalk
/*------------------------------------------------------------------------------*\
 =============================
   ģ: NewMsgBox.cpp
 =============================
 
 [Ȩ]
 
   2000-2002  115  Ȩ
                                              
\*------------------------------------------------------------------------------*/
#include "wndx.h"
#include "WndX.h"
#include "NewMsgBox.h"
#include <stdio.h>


/*------------------------------------------------------------------------------*/
CMsgBox::CMsgBox()
{
}
/*------------------------------------------------------------------------------*/
CMsgBox::~CMsgBox()
{

}
/*------------------------------------------------------------------------------*/
LRESULT CMsgBox::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_INITDIALOG:
		return OnInitDialog();
		break;
	case WM_COMMAND:
		return OnCommand(wParam,lParam);
	case WM_ERASEBKGND:
		OnEraseBkgnd((HDC)wParam);
		return TRUE;

	default:
		return CGraphDlg::WndProc(uMsg,wParam,lParam);
	}
	return TRUE;
}
/*------------------------------------------------------------------------------*/
BOOL CMsgBox::OnInitDialog()
{
	CGraphDlg::OnInitDialog();
	SetWindowText(m_hWnd,m_szCap);
	SetDlgItemText(m_hWnd,IDC_TXT,m_szTxt);
	//make it topmost
	if(m_uType&MB_SYSTEMMODAL)
		SetWindowPos(m_hWnd,HWND_TOPMOST,0,0,0,0,SWP_NOSIZE|SWP_NOMOVE);
	if(m_uType&MB_YESNO)
	{
		SetDlgItemText(m_hWnd,IDC_OK,"(&Y)");
		SetDlgItemText(m_hWnd,IDC_CANCEL,"(&N)");

	}
	else
	if(m_uType&MB_OKCANCEL)
	{
		SetDlgItemText(m_hWnd,IDC_OK,"ȷ");
		SetDlgItemText(m_hWnd,IDC_CANCEL,"ȡ");
	}
	else
	{
		SetDlgItemText(m_hWnd,IDC_OK,"ȷ");
		ShowWindow(GetDlgItem(m_hWnd,IDC_CANCEL),SW_HIDE);
	}
	PlaySound(LPCTSTR(IDR_MSG),hInstX,SND_ASYNC|SND_RESOURCE);
	SetForegroundWindow(m_hWnd);
	SetActiveWindow(m_hWnd);
	
	return FALSE;
}

/*------------------------------------------------------------------------------*/

int CMsgBox::MessageBox(HWND hWnd, char *pszTxt, char *pszCap,UINT utype,UINT uIcon)
{
	CMsgBox mb;
	return mb.MsgBox(hWnd,pszTxt,pszCap,utype,uIcon);
}
/*------------------------------------------------------------------------------*/
int CMsgBox::MessageBox(HWND hWnd,const int iTxtId,const int iCapId, UINT utype,UINT uIcon)
{
	CMsgBox mb;
	return mb.MsgBox(hWnd,iTxtId,iCapId,utype,uIcon);
}
/*------------------------------------------------------------------------------*/
int CMsgBox::MsgBox(HWND hWnd, int iTxtId, int iCapId, UINT utype,UINT uIcon)
{
	LoadString(hInstX,iTxtId,m_szTxt,255);
	LoadString(hInstX,iCapId,m_szCap,127);
	m_uType=utype;
	m_uIcon=uIcon;
	return CGraphDlg::DoModal(LPCTSTR(IDD_MSGBOX),hWnd);
}
/*------------------------------------------------------------------------------*/
int CMsgBox::MsgBox(HWND hWnd, char *pszTxt, char *pszCap, UINT utype,UINT uIcon)
{
	strncpy(m_szTxt,pszTxt,255);
	strncpy(m_szCap,pszCap,127);
	m_uType=utype;
	m_uIcon=uIcon;
	return CGraphDlg::DoModal(LPCTSTR(IDD_MSGBOX),hWnd);
	
}
/*------------------------------------------------------------------------------*/
BOOL CMsgBox::OnCommand(WPARAM wParam, LPARAM lParam)
{
	CGraphDlg::OnCommand(wParam,lParam);
	switch(LOWORD(wParam))
	{
	case IDC_OK:
		{
			if(m_uType&MB_YESNO)
			{
				EndDialog(m_hWnd,IDYES);
			}
			else
			if(m_uType&MB_OKCANCEL)
			{
				EndDialog(m_hWnd,IDOK);
			}
			else
				EndDialog(m_hWnd,IDOK);
		}
		break;
	case IDC_CANCEL:
		{
			if(m_uType&MB_YESNO)
			{
				EndDialog(m_hWnd,IDNO);
			}
			else
			if(m_uType&MB_OKCANCEL)
			{
				EndDialog(m_hWnd,IDCANCEL);
			}
		}
		break;
	}
	return TRUE;

}
/*------------------------------------------------------------------------------*/
void CMsgBox::OnEraseBkgnd(HDC hdc)
{
	CGraphDlg::OnEraseBkgnd(hdc);
	DrawIcon(hdc,25,45,LoadIcon(hInstX,LPCTSTR(m_uIcon)));
}

