//NetTalk
/*------------------------------------------------------------------------------*\
 =============================
   ģ: SlideBar.cpp
 =============================
 
 [Ȩ]
 
   2000-2002  115  Ȩ
                                              
\*------------------------------------------------------------------------------*/
#include "Wndx.h"

#include "SlideBar.h"
#include <Windowsx.h>

/*------------------------------------------------------------------------------*/
CSlideBar::CSlideBar()
{
	
	m_hbmpFace1=0;
	m_hbmpFace2=0;
	m_iPos=0;
	
	
}

/*------------------------------------------------------------------------------*/
CSlideBar::~CSlideBar()
{
	

}
/*------------------------------------------------------------------------------*/

void CSlideBar::SetPos(int iPos)
{
	m_iPos=iPos;
	InvalidateRect(m_hWnd,0,FALSE);
}
/*------------------------------------------------------------------------------*/
int CSlideBar::GetPos()
{
	return m_iPos;
}

/*------------------------------------------------------------------------------*/
void CSlideBar::MakeBmp(HDC hdc)
{
	if(m_hbmpFace1)
		DeleteObject(m_hbmpFace1);
	if(m_hbmpFace2)
		DeleteObject(m_hbmpFace2);

	HDC hMemDC=CreateCompatibleDC(hdc);
	HPEN hp=CreatePen(PS_SOLID,1,0x00808080);
	HPEN hop=(HPEN)SelectObject(hMemDC,hp);
	CRectX rc;
	GetClientRect(m_hWnd,&rc);
	m_hbmpFace1=CreateCompatibleBitmap(hdc,rc.Width(),rc.Height());
	m_hbmpFace2=CreateCompatibleBitmap(hdc,rc.Width(),rc.Height());

	HBITMAP hob=(HBITMAP)SelectObject(hMemDC,m_hbmpFace1);
	FillSolidRectX(hMemDC,CRectX(0,0,rc.Width(),rc.Height()),0x00a2a2a2);
	
	int i = 0;

	for(i=0;i<rc.Width()/2;i++)
	{
		MoveToEx(hMemDC,i*2,0,0);
		LineTo(hMemDC,i*2,rc.Height());
	}	

	SelectObject(hMemDC,m_hbmpFace2);
	FillSolidRectX(hMemDC,CRectX(0,0,rc.Width(),rc.Height()),0x00a2a2a2);

	SelectObject(hMemDC,hop);
	DeleteObject(hp);
	hp=CreatePen(PS_SOLID,1,0x00ffeeee);
	SelectObject(hMemDC,hp);

	for(i=0;i<rc.Width()/2;i++)
	{
		MoveToEx(hMemDC,i*2,0,0);
		LineTo(hMemDC,i*2,rc.Height());
	}

	SelectObject(hMemDC,hop);
	DeleteObject(hp);
	
	SelectObject(hMemDC,hob);
	DeleteDC(hMemDC);
	


}

/*------------------------------------------------------------------------------*/
BOOL CSlideBar::Create(RECT &rc,HWND hParent, UINT uID)
{
	return CWndX::Create(0,0,0,WS_CHILD|WS_VISIBLE,rc,hParent,(HMENU)uID,0);

}
/*------------------------------------------------------------------------------*/
LRESULT CSlideBar::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_PAINT:
		OnPaint();
		return TRUE;
	case WM_DESTROY:
		if(m_hbmpFace1)
			DeleteObject(m_hbmpFace1);
		if(m_hbmpFace2)
			DeleteObject(m_hbmpFace2);
		m_hbmpFace1=0;
		m_hbmpFace2=0;
		break;
	case WM_LBUTTONDOWN:
		{
			POINT point;
			point.x=GET_X_LPARAM(lParam); 
			point.y=GET_Y_LPARAM(lParam); 
			OnLButtonDown(wParam,point);
		}
		break;
			
	}
	return CWndX::WndProc(uMsg,wParam,lParam);
}
/*------------------------------------------------------------------------------*/
void CSlideBar::OnPaint()
{
	PAINTSTRUCT ps;
	HDC hdc=BeginPaint(m_hWnd,&ps);
	if(!m_hbmpFace1)
	{
		MakeBmp(hdc);
	}
	CRectX rc;
	GetClientRect(m_hWnd,&rc);
	HDC hMemDC=CreateCompatibleDC(hdc);

    HBITMAP hob=(HBITMAP)SelectObject(hMemDC,m_hbmpFace2);
	int p=rc.Width()*m_iPos/100;
	BitBlt(hdc,rc.left,rc.top,p,rc.Height(),hMemDC,0,0,SRCCOPY);
	SelectObject(hMemDC,m_hbmpFace1);
	BitBlt(hdc,rc.left+p,rc.top,rc.Width()-p,rc.Height(),hMemDC,p,0,SRCCOPY);
	
	SelectObject(hMemDC,hob);

	DeleteDC(hMemDC);
	EndPaint(m_hWnd,&ps);
}
/*------------------------------------------------------------------------------*/
void CSlideBar::OnLButtonDown(UINT nFlags, POINT &point)
{
	SetCapture(m_hWnd);
	CRectX rc;
	GetClientRect(m_hWnd,&rc);
	SetPos(point.x*100/rc.Width());
	SendMessage(GetParent(m_hWnd),WM_SLD,m_iPos,(LPARAM)m_hWnd);
	MSG msg;
	while(GetMessage(&msg, NULL, 0, 0))
	{
		
		if (GetCapture()!=m_hWnd)
		{
			DispatchMessage(&msg);
			break;
		}
		
		switch (msg.message)
		{
			
		case WM_MOUSEMOVE:
			if(GET_X_LPARAM(msg.lParam)>rc.right)
				SetPos(100);
			else
			if(GET_X_LPARAM(msg.lParam)<rc.left)
				SetPos(0);
			else
				SetPos(GET_X_LPARAM(msg.lParam)*100/rc.Width());
			SendMessage(GetParent(m_hWnd),WM_SLD,m_iPos,(LPARAM)m_hWnd);
			break;
		case WM_LBUTTONUP:
			
			goto EXITLOOP;
				
		default:
			DispatchMessage(&msg);
			break;
		}
	}
	
EXITLOOP:
		
	ReleaseCapture();
}
